package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class InfrastructureSpecBuilder extends InfrastructureSpecFluentImpl<InfrastructureSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<InfrastructureSpec,InfrastructureSpecBuilder> {

    InfrastructureSpecFluent<?> fluent;
    Boolean validationEnabled;

    public InfrastructureSpecBuilder() {
        this(true);
    }

    public InfrastructureSpecBuilder(Boolean validationEnabled) {
        this(new InfrastructureSpec(), validationEnabled);
    }

    public InfrastructureSpecBuilder(InfrastructureSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public InfrastructureSpecBuilder(InfrastructureSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new InfrastructureSpec(), validationEnabled);
    }

    public InfrastructureSpecBuilder(InfrastructureSpecFluent<?> fluent,InfrastructureSpec instance) {
        this(fluent, instance, true);
    }

    public InfrastructureSpecBuilder(InfrastructureSpecFluent<?> fluent,InfrastructureSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCloudConfig(instance.getCloudConfig()); 
        fluent.withPlatformSpec(instance.getPlatformSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public InfrastructureSpecBuilder(InfrastructureSpec instance) {
        this(instance,true);
    }

    public InfrastructureSpecBuilder(InfrastructureSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withCloudConfig(instance.getCloudConfig()); 
        this.withPlatformSpec(instance.getPlatformSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public InfrastructureSpec build() {
        InfrastructureSpec buildable = new InfrastructureSpec(fluent.getCloudConfig(),fluent.getPlatformSpec());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        InfrastructureSpecBuilder that = (InfrastructureSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
