package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OperatorHubStatusBuilder extends OperatorHubStatusFluentImpl<OperatorHubStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<OperatorHubStatus,OperatorHubStatusBuilder> {

    OperatorHubStatusFluent<?> fluent;
    Boolean validationEnabled;

    public OperatorHubStatusBuilder() {
        this(true);
    }

    public OperatorHubStatusBuilder(Boolean validationEnabled) {
        this(new OperatorHubStatus(), validationEnabled);
    }

    public OperatorHubStatusBuilder(OperatorHubStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public OperatorHubStatusBuilder(OperatorHubStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new OperatorHubStatus(), validationEnabled);
    }

    public OperatorHubStatusBuilder(OperatorHubStatusFluent<?> fluent,OperatorHubStatus instance) {
        this(fluent, instance, true);
    }

    public OperatorHubStatusBuilder(OperatorHubStatusFluent<?> fluent,OperatorHubStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withSources(instance.getSources()); 
        this.validationEnabled = validationEnabled; 
    }

    public OperatorHubStatusBuilder(OperatorHubStatus instance) {
        this(instance,true);
    }

    public OperatorHubStatusBuilder(OperatorHubStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withSources(instance.getSources()); 
        this.validationEnabled = validationEnabled; 
    }

    public OperatorHubStatus build() {
        OperatorHubStatus buildable = new OperatorHubStatus(fluent.getSources());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OperatorHubStatusBuilder that = (OperatorHubStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
