package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.lang.StringBuffer;

public class PlatformSpecFluentImpl<A extends PlatformSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PlatformSpecFluent<A> {

    private AWSPlatformSpecBuilder aws;
    private AzurePlatformSpecBuilder azure;
    private BareMetalPlatformSpecBuilder baremetal;
    private GCPPlatformSpecBuilder gcp;
    private IBMCloudPlatformSpecBuilder ibmcloud;
    private OpenStackPlatformSpecBuilder openstack;
    private OvirtPlatformSpecBuilder ovirt;
    private String type;
    private VSpherePlatformSpecBuilder vsphere;

    public PlatformSpecFluentImpl() {
    }

    public PlatformSpecFluentImpl(PlatformSpec instance) {
        this.withAws(instance.getAws()); 
        this.withAzure(instance.getAzure()); 
        this.withBaremetal(instance.getBaremetal()); 
        this.withGcp(instance.getGcp()); 
        this.withIbmcloud(instance.getIbmcloud()); 
        this.withOpenstack(instance.getOpenstack()); 
        this.withOvirt(instance.getOvirt()); 
        this.withType(instance.getType()); 
        this.withVsphere(instance.getVsphere()); 
    }

    
/**
 * This method has been deprecated, please use method buildAws instead.
 * @return The buildable object.
 */
@Deprecated public AWSPlatformSpec getAws() {
        return this.aws!=null?this.aws.build():null;
    }

    public AWSPlatformSpec buildAws() {
        return this.aws!=null?this.aws.build():null;
    }

    public A withAws(AWSPlatformSpec aws) {
        _visitables.get("aws").remove(this.aws);
        if (aws!=null){ this.aws= new AWSPlatformSpecBuilder(aws); _visitables.get("aws").add(this.aws);} return (A) this;
    }

    public Boolean hasAws() {
        return this.aws != null;
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.AwsNested<A> withNewAws() {
        return new AwsNestedImpl();
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.AwsNested<A> withNewAwsLike(AWSPlatformSpec item) {
        return new AwsNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.AwsNested<A> editAws() {
        return withNewAwsLike(getAws());
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.AwsNested<A> editOrNewAws() {
        return withNewAwsLike(getAws() != null ? getAws(): new AWSPlatformSpecBuilder().build());
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.AwsNested<A> editOrNewAwsLike(AWSPlatformSpec item) {
        return withNewAwsLike(getAws() != null ? getAws(): item);
    }

    
/**
 * This method has been deprecated, please use method buildAzure instead.
 * @return The buildable object.
 */
@Deprecated public AzurePlatformSpec getAzure() {
        return this.azure!=null?this.azure.build():null;
    }

    public AzurePlatformSpec buildAzure() {
        return this.azure!=null?this.azure.build():null;
    }

    public A withAzure(AzurePlatformSpec azure) {
        _visitables.get("azure").remove(this.azure);
        if (azure!=null){ this.azure= new AzurePlatformSpecBuilder(azure); _visitables.get("azure").add(this.azure);} return (A) this;
    }

    public Boolean hasAzure() {
        return this.azure != null;
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.AzureNested<A> withNewAzure() {
        return new AzureNestedImpl();
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.AzureNested<A> withNewAzureLike(AzurePlatformSpec item) {
        return new AzureNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.AzureNested<A> editAzure() {
        return withNewAzureLike(getAzure());
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.AzureNested<A> editOrNewAzure() {
        return withNewAzureLike(getAzure() != null ? getAzure(): new AzurePlatformSpecBuilder().build());
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.AzureNested<A> editOrNewAzureLike(AzurePlatformSpec item) {
        return withNewAzureLike(getAzure() != null ? getAzure(): item);
    }

    
/**
 * This method has been deprecated, please use method buildBaremetal instead.
 * @return The buildable object.
 */
@Deprecated public BareMetalPlatformSpec getBaremetal() {
        return this.baremetal!=null?this.baremetal.build():null;
    }

    public BareMetalPlatformSpec buildBaremetal() {
        return this.baremetal!=null?this.baremetal.build():null;
    }

    public A withBaremetal(BareMetalPlatformSpec baremetal) {
        _visitables.get("baremetal").remove(this.baremetal);
        if (baremetal!=null){ this.baremetal= new BareMetalPlatformSpecBuilder(baremetal); _visitables.get("baremetal").add(this.baremetal);} return (A) this;
    }

    public Boolean hasBaremetal() {
        return this.baremetal != null;
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.BaremetalNested<A> withNewBaremetal() {
        return new BaremetalNestedImpl();
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.BaremetalNested<A> withNewBaremetalLike(BareMetalPlatformSpec item) {
        return new BaremetalNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.BaremetalNested<A> editBaremetal() {
        return withNewBaremetalLike(getBaremetal());
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.BaremetalNested<A> editOrNewBaremetal() {
        return withNewBaremetalLike(getBaremetal() != null ? getBaremetal(): new BareMetalPlatformSpecBuilder().build());
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.BaremetalNested<A> editOrNewBaremetalLike(BareMetalPlatformSpec item) {
        return withNewBaremetalLike(getBaremetal() != null ? getBaremetal(): item);
    }

    
/**
 * This method has been deprecated, please use method buildGcp instead.
 * @return The buildable object.
 */
@Deprecated public GCPPlatformSpec getGcp() {
        return this.gcp!=null?this.gcp.build():null;
    }

    public GCPPlatformSpec buildGcp() {
        return this.gcp!=null?this.gcp.build():null;
    }

    public A withGcp(GCPPlatformSpec gcp) {
        _visitables.get("gcp").remove(this.gcp);
        if (gcp!=null){ this.gcp= new GCPPlatformSpecBuilder(gcp); _visitables.get("gcp").add(this.gcp);} return (A) this;
    }

    public Boolean hasGcp() {
        return this.gcp != null;
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.GcpNested<A> withNewGcp() {
        return new GcpNestedImpl();
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.GcpNested<A> withNewGcpLike(GCPPlatformSpec item) {
        return new GcpNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.GcpNested<A> editGcp() {
        return withNewGcpLike(getGcp());
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.GcpNested<A> editOrNewGcp() {
        return withNewGcpLike(getGcp() != null ? getGcp(): new GCPPlatformSpecBuilder().build());
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.GcpNested<A> editOrNewGcpLike(GCPPlatformSpec item) {
        return withNewGcpLike(getGcp() != null ? getGcp(): item);
    }

    
/**
 * This method has been deprecated, please use method buildIbmcloud instead.
 * @return The buildable object.
 */
@Deprecated public IBMCloudPlatformSpec getIbmcloud() {
        return this.ibmcloud!=null?this.ibmcloud.build():null;
    }

    public IBMCloudPlatformSpec buildIbmcloud() {
        return this.ibmcloud!=null?this.ibmcloud.build():null;
    }

    public A withIbmcloud(IBMCloudPlatformSpec ibmcloud) {
        _visitables.get("ibmcloud").remove(this.ibmcloud);
        if (ibmcloud!=null){ this.ibmcloud= new IBMCloudPlatformSpecBuilder(ibmcloud); _visitables.get("ibmcloud").add(this.ibmcloud);} return (A) this;
    }

    public Boolean hasIbmcloud() {
        return this.ibmcloud != null;
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.IbmcloudNested<A> withNewIbmcloud() {
        return new IbmcloudNestedImpl();
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.IbmcloudNested<A> withNewIbmcloudLike(IBMCloudPlatformSpec item) {
        return new IbmcloudNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.IbmcloudNested<A> editIbmcloud() {
        return withNewIbmcloudLike(getIbmcloud());
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.IbmcloudNested<A> editOrNewIbmcloud() {
        return withNewIbmcloudLike(getIbmcloud() != null ? getIbmcloud(): new IBMCloudPlatformSpecBuilder().build());
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.IbmcloudNested<A> editOrNewIbmcloudLike(IBMCloudPlatformSpec item) {
        return withNewIbmcloudLike(getIbmcloud() != null ? getIbmcloud(): item);
    }

    
/**
 * This method has been deprecated, please use method buildOpenstack instead.
 * @return The buildable object.
 */
@Deprecated public OpenStackPlatformSpec getOpenstack() {
        return this.openstack!=null?this.openstack.build():null;
    }

    public OpenStackPlatformSpec buildOpenstack() {
        return this.openstack!=null?this.openstack.build():null;
    }

    public A withOpenstack(OpenStackPlatformSpec openstack) {
        _visitables.get("openstack").remove(this.openstack);
        if (openstack!=null){ this.openstack= new OpenStackPlatformSpecBuilder(openstack); _visitables.get("openstack").add(this.openstack);} return (A) this;
    }

    public Boolean hasOpenstack() {
        return this.openstack != null;
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.OpenstackNested<A> withNewOpenstack() {
        return new OpenstackNestedImpl();
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.OpenstackNested<A> withNewOpenstackLike(OpenStackPlatformSpec item) {
        return new OpenstackNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.OpenstackNested<A> editOpenstack() {
        return withNewOpenstackLike(getOpenstack());
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.OpenstackNested<A> editOrNewOpenstack() {
        return withNewOpenstackLike(getOpenstack() != null ? getOpenstack(): new OpenStackPlatformSpecBuilder().build());
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.OpenstackNested<A> editOrNewOpenstackLike(OpenStackPlatformSpec item) {
        return withNewOpenstackLike(getOpenstack() != null ? getOpenstack(): item);
    }

    
/**
 * This method has been deprecated, please use method buildOvirt instead.
 * @return The buildable object.
 */
@Deprecated public OvirtPlatformSpec getOvirt() {
        return this.ovirt!=null?this.ovirt.build():null;
    }

    public OvirtPlatformSpec buildOvirt() {
        return this.ovirt!=null?this.ovirt.build():null;
    }

    public A withOvirt(OvirtPlatformSpec ovirt) {
        _visitables.get("ovirt").remove(this.ovirt);
        if (ovirt!=null){ this.ovirt= new OvirtPlatformSpecBuilder(ovirt); _visitables.get("ovirt").add(this.ovirt);} return (A) this;
    }

    public Boolean hasOvirt() {
        return this.ovirt != null;
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.OvirtNested<A> withNewOvirt() {
        return new OvirtNestedImpl();
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.OvirtNested<A> withNewOvirtLike(OvirtPlatformSpec item) {
        return new OvirtNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.OvirtNested<A> editOvirt() {
        return withNewOvirtLike(getOvirt());
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.OvirtNested<A> editOrNewOvirt() {
        return withNewOvirtLike(getOvirt() != null ? getOvirt(): new OvirtPlatformSpecBuilder().build());
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.OvirtNested<A> editOrNewOvirtLike(OvirtPlatformSpec item) {
        return withNewOvirtLike(getOvirt() != null ? getOvirt(): item);
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(int[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(char[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(byte[] arg1,int arg2) {
        return (A)withType(new String(arg1, arg2));
    }

    public A withNewType(byte[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(char[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withType(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildVsphere instead.
 * @return The buildable object.
 */
@Deprecated public VSpherePlatformSpec getVsphere() {
        return this.vsphere!=null?this.vsphere.build():null;
    }

    public VSpherePlatformSpec buildVsphere() {
        return this.vsphere!=null?this.vsphere.build():null;
    }

    public A withVsphere(VSpherePlatformSpec vsphere) {
        _visitables.get("vsphere").remove(this.vsphere);
        if (vsphere!=null){ this.vsphere= new VSpherePlatformSpecBuilder(vsphere); _visitables.get("vsphere").add(this.vsphere);} return (A) this;
    }

    public Boolean hasVsphere() {
        return this.vsphere != null;
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.VsphereNested<A> withNewVsphere() {
        return new VsphereNestedImpl();
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.VsphereNested<A> withNewVsphereLike(VSpherePlatformSpec item) {
        return new VsphereNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.VsphereNested<A> editVsphere() {
        return withNewVsphereLike(getVsphere());
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.VsphereNested<A> editOrNewVsphere() {
        return withNewVsphereLike(getVsphere() != null ? getVsphere(): new VSpherePlatformSpecBuilder().build());
    }

    public io.fabric8.openshift.api.model.PlatformSpecFluent.VsphereNested<A> editOrNewVsphereLike(VSpherePlatformSpec item) {
        return withNewVsphereLike(getVsphere() != null ? getVsphere(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PlatformSpecFluentImpl that = (PlatformSpecFluentImpl) o;
        if (aws != null ? !aws.equals(that.aws) :that.aws != null) return false;
        if (azure != null ? !azure.equals(that.azure) :that.azure != null) return false;
        if (baremetal != null ? !baremetal.equals(that.baremetal) :that.baremetal != null) return false;
        if (gcp != null ? !gcp.equals(that.gcp) :that.gcp != null) return false;
        if (ibmcloud != null ? !ibmcloud.equals(that.ibmcloud) :that.ibmcloud != null) return false;
        if (openstack != null ? !openstack.equals(that.openstack) :that.openstack != null) return false;
        if (ovirt != null ? !ovirt.equals(that.ovirt) :that.ovirt != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        if (vsphere != null ? !vsphere.equals(that.vsphere) :that.vsphere != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(aws,  azure,  baremetal,  gcp,  ibmcloud,  openstack,  ovirt,  type,  vsphere,  super.hashCode());
    }

    public class AwsNestedImpl<N> extends AWSPlatformSpecFluentImpl<io.fabric8.openshift.api.model.PlatformSpecFluent.AwsNested<N>> implements io.fabric8.openshift.api.model.PlatformSpecFluent.AwsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AWSPlatformSpecBuilder builder;

            AwsNestedImpl(AWSPlatformSpec item) {
                this.builder = new AWSPlatformSpecBuilder(this, item);
                        
            }

            AwsNestedImpl() {
                this.builder = new AWSPlatformSpecBuilder(this);
                        
            }

            public N and() {
                return (N) PlatformSpecFluentImpl.this.withAws(builder.build());
            }

            public N endAws() {
                return and();
            }
    }


    public class AzureNestedImpl<N> extends AzurePlatformSpecFluentImpl<io.fabric8.openshift.api.model.PlatformSpecFluent.AzureNested<N>> implements io.fabric8.openshift.api.model.PlatformSpecFluent.AzureNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AzurePlatformSpecBuilder builder;

            AzureNestedImpl(AzurePlatformSpec item) {
                this.builder = new AzurePlatformSpecBuilder(this, item);
                        
            }

            AzureNestedImpl() {
                this.builder = new AzurePlatformSpecBuilder(this);
                        
            }

            public N and() {
                return (N) PlatformSpecFluentImpl.this.withAzure(builder.build());
            }

            public N endAzure() {
                return and();
            }
    }


    public class BaremetalNestedImpl<N> extends BareMetalPlatformSpecFluentImpl<io.fabric8.openshift.api.model.PlatformSpecFluent.BaremetalNested<N>> implements io.fabric8.openshift.api.model.PlatformSpecFluent.BaremetalNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BareMetalPlatformSpecBuilder builder;

            BaremetalNestedImpl(BareMetalPlatformSpec item) {
                this.builder = new BareMetalPlatformSpecBuilder(this, item);
                        
            }

            BaremetalNestedImpl() {
                this.builder = new BareMetalPlatformSpecBuilder(this);
                        
            }

            public N and() {
                return (N) PlatformSpecFluentImpl.this.withBaremetal(builder.build());
            }

            public N endBaremetal() {
                return and();
            }
    }


    public class GcpNestedImpl<N> extends GCPPlatformSpecFluentImpl<io.fabric8.openshift.api.model.PlatformSpecFluent.GcpNested<N>> implements io.fabric8.openshift.api.model.PlatformSpecFluent.GcpNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GCPPlatformSpecBuilder builder;

            GcpNestedImpl(GCPPlatformSpec item) {
                this.builder = new GCPPlatformSpecBuilder(this, item);
                        
            }

            GcpNestedImpl() {
                this.builder = new GCPPlatformSpecBuilder(this);
                        
            }

            public N and() {
                return (N) PlatformSpecFluentImpl.this.withGcp(builder.build());
            }

            public N endGcp() {
                return and();
            }
    }


    public class IbmcloudNestedImpl<N> extends IBMCloudPlatformSpecFluentImpl<io.fabric8.openshift.api.model.PlatformSpecFluent.IbmcloudNested<N>> implements io.fabric8.openshift.api.model.PlatformSpecFluent.IbmcloudNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IBMCloudPlatformSpecBuilder builder;

            IbmcloudNestedImpl(IBMCloudPlatformSpec item) {
                this.builder = new IBMCloudPlatformSpecBuilder(this, item);
                        
            }

            IbmcloudNestedImpl() {
                this.builder = new IBMCloudPlatformSpecBuilder(this);
                        
            }

            public N and() {
                return (N) PlatformSpecFluentImpl.this.withIbmcloud(builder.build());
            }

            public N endIbmcloud() {
                return and();
            }
    }


    public class OpenstackNestedImpl<N> extends OpenStackPlatformSpecFluentImpl<io.fabric8.openshift.api.model.PlatformSpecFluent.OpenstackNested<N>> implements io.fabric8.openshift.api.model.PlatformSpecFluent.OpenstackNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OpenStackPlatformSpecBuilder builder;

            OpenstackNestedImpl(OpenStackPlatformSpec item) {
                this.builder = new OpenStackPlatformSpecBuilder(this, item);
                        
            }

            OpenstackNestedImpl() {
                this.builder = new OpenStackPlatformSpecBuilder(this);
                        
            }

            public N and() {
                return (N) PlatformSpecFluentImpl.this.withOpenstack(builder.build());
            }

            public N endOpenstack() {
                return and();
            }
    }


    public class OvirtNestedImpl<N> extends OvirtPlatformSpecFluentImpl<io.fabric8.openshift.api.model.PlatformSpecFluent.OvirtNested<N>> implements io.fabric8.openshift.api.model.PlatformSpecFluent.OvirtNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OvirtPlatformSpecBuilder builder;

            OvirtNestedImpl(OvirtPlatformSpec item) {
                this.builder = new OvirtPlatformSpecBuilder(this, item);
                        
            }

            OvirtNestedImpl() {
                this.builder = new OvirtPlatformSpecBuilder(this);
                        
            }

            public N and() {
                return (N) PlatformSpecFluentImpl.this.withOvirt(builder.build());
            }

            public N endOvirt() {
                return and();
            }
    }


    public class VsphereNestedImpl<N> extends VSpherePlatformSpecFluentImpl<io.fabric8.openshift.api.model.PlatformSpecFluent.VsphereNested<N>> implements io.fabric8.openshift.api.model.PlatformSpecFluent.VsphereNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final VSpherePlatformSpecBuilder builder;

            VsphereNestedImpl(VSpherePlatformSpec item) {
                this.builder = new VSpherePlatformSpecBuilder(this, item);
                        
            }

            VsphereNestedImpl() {
                this.builder = new VSpherePlatformSpecBuilder(this);
                        
            }

            public N and() {
                return (N) PlatformSpecFluentImpl.this.withVsphere(builder.build());
            }

            public N endVsphere() {
                return and();
            }
    }


}
