package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ProjectRequestFluentImpl<A extends ProjectRequestFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ProjectRequestFluent<A> {

    private String apiVersion;
    private String description;
    private String displayName;
    private String kind;
    private ObjectMetaBuilder metadata;

    public ProjectRequestFluentImpl() {
    }

    public ProjectRequestFluentImpl(ProjectRequest instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withDescription(instance.getDescription()); 
        this.withDisplayName(instance.getDisplayName()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(int[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(char[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(byte[] arg1,int arg2) {
        return (A)withApiVersion(new String(arg1, arg2));
    }

    public A withNewApiVersion(byte[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(char[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withApiVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getDescription() {
        return this.description;
    }

    public A withDescription(String description) {
        this.description=description; return (A) this;
    }

    public Boolean hasDescription() {
        return this.description != null;
    }

    public A withNewDescription(StringBuilder arg1) {
        return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(int[] arg1,int arg2,int arg3) {
        return (A)withDescription(new String(arg1, arg2, arg3));
    }

    public A withNewDescription(char[] arg1) {
        return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(StringBuffer arg1) {
        return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(byte[] arg1,int arg2) {
        return (A)withDescription(new String(arg1, arg2));
    }

    public A withNewDescription(byte[] arg1) {
        return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(char[] arg1,int arg2,int arg3) {
        return (A)withDescription(new String(arg1, arg2, arg3));
    }

    public A withNewDescription(byte[] arg1,int arg2,int arg3) {
        return (A)withDescription(new String(arg1, arg2, arg3));
    }

    public A withNewDescription(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withDescription(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewDescription(String arg1) {
        return (A)withDescription(new String(arg1));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public A withDisplayName(String displayName) {
        this.displayName=displayName; return (A) this;
    }

    public Boolean hasDisplayName() {
        return this.displayName != null;
    }

    public A withNewDisplayName(StringBuilder arg1) {
        return (A)withDisplayName(new String(arg1));
    }

    public A withNewDisplayName(int[] arg1,int arg2,int arg3) {
        return (A)withDisplayName(new String(arg1, arg2, arg3));
    }

    public A withNewDisplayName(char[] arg1) {
        return (A)withDisplayName(new String(arg1));
    }

    public A withNewDisplayName(StringBuffer arg1) {
        return (A)withDisplayName(new String(arg1));
    }

    public A withNewDisplayName(byte[] arg1,int arg2) {
        return (A)withDisplayName(new String(arg1, arg2));
    }

    public A withNewDisplayName(byte[] arg1) {
        return (A)withDisplayName(new String(arg1));
    }

    public A withNewDisplayName(char[] arg1,int arg2,int arg3) {
        return (A)withDisplayName(new String(arg1, arg2, arg3));
    }

    public A withNewDisplayName(byte[] arg1,int arg2,int arg3) {
        return (A)withDisplayName(new String(arg1, arg2, arg3));
    }

    public A withNewDisplayName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withDisplayName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewDisplayName(String arg1) {
        return (A)withDisplayName(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(int[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(char[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(byte[] arg1,int arg2) {
        return (A)withKind(new String(arg1, arg2));
    }

    public A withNewKind(byte[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(char[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withKind(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.fabric8.openshift.api.model.ProjectRequestFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public io.fabric8.openshift.api.model.ProjectRequestFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.ProjectRequestFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.fabric8.openshift.api.model.ProjectRequestFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public io.fabric8.openshift.api.model.ProjectRequestFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ProjectRequestFluentImpl that = (ProjectRequestFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (description != null ? !description.equals(that.description) :that.description != null) return false;
        if (displayName != null ? !displayName.equals(that.displayName) :that.displayName != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  description,  displayName,  kind,  metadata,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<io.fabric8.openshift.api.model.ProjectRequestFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.ProjectRequestFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectMetaBuilder builder;

            MetadataNestedImpl(ObjectMeta item) {
                this.builder = new ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) ProjectRequestFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


}
