package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ProxySpecFluent<A extends ProxySpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public String getHttpProxy();
    public A withHttpProxy(String httpProxy);
    public Boolean hasHttpProxy();
    public A withNewHttpProxy(StringBuilder arg1);
    public A withNewHttpProxy(int[] arg1,int arg2,int arg3);
    public A withNewHttpProxy(char[] arg1);
    public A withNewHttpProxy(StringBuffer arg1);
    public A withNewHttpProxy(byte[] arg1,int arg2);
    public A withNewHttpProxy(byte[] arg1);
    public A withNewHttpProxy(char[] arg1,int arg2,int arg3);
    public A withNewHttpProxy(byte[] arg1,int arg2,int arg3);
    public A withNewHttpProxy(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewHttpProxy(String arg1);
    public String getHttpsProxy();
    public A withHttpsProxy(String httpsProxy);
    public Boolean hasHttpsProxy();
    public A withNewHttpsProxy(StringBuilder arg1);
    public A withNewHttpsProxy(int[] arg1,int arg2,int arg3);
    public A withNewHttpsProxy(char[] arg1);
    public A withNewHttpsProxy(StringBuffer arg1);
    public A withNewHttpsProxy(byte[] arg1,int arg2);
    public A withNewHttpsProxy(byte[] arg1);
    public A withNewHttpsProxy(char[] arg1,int arg2,int arg3);
    public A withNewHttpsProxy(byte[] arg1,int arg2,int arg3);
    public A withNewHttpsProxy(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewHttpsProxy(String arg1);
    public String getNoProxy();
    public A withNoProxy(String noProxy);
    public Boolean hasNoProxy();
    public A withNewNoProxy(StringBuilder arg1);
    public A withNewNoProxy(int[] arg1,int arg2,int arg3);
    public A withNewNoProxy(char[] arg1);
    public A withNewNoProxy(StringBuffer arg1);
    public A withNewNoProxy(byte[] arg1,int arg2);
    public A withNewNoProxy(byte[] arg1);
    public A withNewNoProxy(char[] arg1,int arg2,int arg3);
    public A withNewNoProxy(byte[] arg1,int arg2,int arg3);
    public A withNewNoProxy(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewNoProxy(String arg1);
    public A addToReadinessEndpoints(int index,String item);
    public A setToReadinessEndpoints(int index,String item);
    public A addToReadinessEndpoints(String... items);
    public A addAllToReadinessEndpoints(Collection<String> items);
    public A removeFromReadinessEndpoints(String... items);
    public A removeAllFromReadinessEndpoints(Collection<String> items);
    public List<String> getReadinessEndpoints();
    public String getReadinessEndpoint(int index);
    public String getFirstReadinessEndpoint();
    public String getLastReadinessEndpoint();
    public String getMatchingReadinessEndpoint(Predicate<String> predicate);
    public Boolean hasMatchingReadinessEndpoint(Predicate<String> predicate);
    public A withReadinessEndpoints(List<String> readinessEndpoints);
    public A withReadinessEndpoints(String... readinessEndpoints);
    public Boolean hasReadinessEndpoints();
    public A addNewReadinessEndpoint(StringBuilder arg1);
    public A addNewReadinessEndpoint(int[] arg1,int arg2,int arg3);
    public A addNewReadinessEndpoint(char[] arg1);
    public A addNewReadinessEndpoint(StringBuffer arg1);
    public A addNewReadinessEndpoint(byte[] arg1,int arg2);
    public A addNewReadinessEndpoint(byte[] arg1);
    public A addNewReadinessEndpoint(char[] arg1,int arg2,int arg3);
    public A addNewReadinessEndpoint(byte[] arg1,int arg2,int arg3);
    public A addNewReadinessEndpoint(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewReadinessEndpoint(String arg1);
    
/**
 * This method has been deprecated, please use method buildTrustedCA instead.
 * @return The buildable object.
 */
@Deprecated public ConfigMapNameReference getTrustedCA();
    public ConfigMapNameReference buildTrustedCA();
    public A withTrustedCA(ConfigMapNameReference trustedCA);
    public Boolean hasTrustedCA();
    public A withNewTrustedCA(String name);
    public io.fabric8.openshift.api.model.ProxySpecFluent.TrustedCANested<A> withNewTrustedCA();
    public io.fabric8.openshift.api.model.ProxySpecFluent.TrustedCANested<A> withNewTrustedCALike(ConfigMapNameReference item);
    public io.fabric8.openshift.api.model.ProxySpecFluent.TrustedCANested<A> editTrustedCA();
    public io.fabric8.openshift.api.model.ProxySpecFluent.TrustedCANested<A> editOrNewTrustedCA();
    public io.fabric8.openshift.api.model.ProxySpecFluent.TrustedCANested<A> editOrNewTrustedCALike(ConfigMapNameReference item);
    public interface TrustedCANested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConfigMapNameReferenceFluent<io.fabric8.openshift.api.model.ProxySpecFluent.TrustedCANested<N>> {

            public N and();
            public N endTrustedCA();    }


}
