package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class SelfSubjectRulesReviewSpecFluentImpl<A extends SelfSubjectRulesReviewSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SelfSubjectRulesReviewSpecFluent<A> {

    private List<String> scopes = new ArrayList<String>();

    public SelfSubjectRulesReviewSpecFluentImpl() {
    }

    public SelfSubjectRulesReviewSpecFluentImpl(SelfSubjectRulesReviewSpec instance) {
        this.withScopes(instance.getScopes()); 
    }

    public A addToScopes(int index,String item) {
        if (this.scopes == null) {this.scopes = new ArrayList<String>();}
        this.scopes.add(index, item);
        return (A)this;
    }

    public A setToScopes(int index,String item) {
        if (this.scopes == null) {this.scopes = new ArrayList<String>();}
        this.scopes.set(index, item); return (A)this;
    }

    public A addToScopes(String... items) {
        if (this.scopes == null) {this.scopes = new ArrayList<String>();}
        for (String item : items) {this.scopes.add(item);} return (A)this;
    }

    public A addAllToScopes(Collection<String> items) {
        if (this.scopes == null) {this.scopes = new ArrayList<String>();}
        for (String item : items) {this.scopes.add(item);} return (A)this;
    }

    public A removeFromScopes(String... items) {
        for (String item : items) {if (this.scopes!= null){ this.scopes.remove(item);}} return (A)this;
    }

    public A removeAllFromScopes(Collection<String> items) {
        for (String item : items) {if (this.scopes!= null){ this.scopes.remove(item);}} return (A)this;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public String getScope(int index) {
        return this.scopes.get(index);
    }

    public String getFirstScope() {
        return this.scopes.get(0);
    }

    public String getLastScope() {
        return this.scopes.get(scopes.size() - 1);
    }

    public String getMatchingScope(Predicate<String> predicate) {
        for (String item: scopes) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingScope(Predicate<String> predicate) {
        for (String item: scopes) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withScopes(List<String> scopes) {
        if (this.scopes != null) { _visitables.get("scopes").removeAll(this.scopes);}
        if (scopes != null) {this.scopes = new ArrayList<String>(); for (String item : scopes){this.addToScopes(item);}} else { this.scopes = null;} return (A) this;
    }

    public A withScopes(String... scopes) {
        if (this.scopes != null) {this.scopes.clear();}
        if (scopes != null) {for (String item :scopes){ this.addToScopes(item);}} return (A) this;
    }

    public Boolean hasScopes() {
        return scopes != null && !scopes.isEmpty();
    }

    public A addNewScope(StringBuilder arg1) {
        return (A)addToScopes(new String(arg1));
    }

    public A addNewScope(int[] arg1,int arg2,int arg3) {
        return (A)addToScopes(new String(arg1, arg2, arg3));
    }

    public A addNewScope(char[] arg1) {
        return (A)addToScopes(new String(arg1));
    }

    public A addNewScope(StringBuffer arg1) {
        return (A)addToScopes(new String(arg1));
    }

    public A addNewScope(byte[] arg1,int arg2) {
        return (A)addToScopes(new String(arg1, arg2));
    }

    public A addNewScope(byte[] arg1) {
        return (A)addToScopes(new String(arg1));
    }

    public A addNewScope(char[] arg1,int arg2,int arg3) {
        return (A)addToScopes(new String(arg1, arg2, arg3));
    }

    public A addNewScope(byte[] arg1,int arg2,int arg3) {
        return (A)addToScopes(new String(arg1, arg2, arg3));
    }

    public A addNewScope(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToScopes(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewScope(String arg1) {
        return (A)addToScopes(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SelfSubjectRulesReviewSpecFluentImpl that = (SelfSubjectRulesReviewSpecFluentImpl) o;
        if (scopes != null ? !scopes.equals(that.scopes) :that.scopes != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(scopes,  super.hashCode());
    }

}
