package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface DeploymentConfigSpecFluent<A extends DeploymentConfigSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Integer getMinReadySeconds();
    public A withMinReadySeconds(Integer minReadySeconds);
    public Boolean hasMinReadySeconds();
    public A withNewMinReadySeconds(int arg0);
    public Boolean getPaused();
    public A withPaused(Boolean paused);
    public Boolean hasPaused();
    public A withNewPaused(String arg1);
    public A withNewPaused(boolean arg1);
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Boolean hasReplicas();
    public A withNewReplicas(int arg0);
    public Integer getRevisionHistoryLimit();
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit);
    public Boolean hasRevisionHistoryLimit();
    public A withNewRevisionHistoryLimit(int arg0);
    public A addToSelector(String key,String value);
    public A addToSelector(java.util.Map<String,String> map);
    public A removeFromSelector(String key);
    public A removeFromSelector(java.util.Map<String,String> map);
    public java.util.Map<String,String> getSelector();
    public <K extends Object,V extends Object>A withSelector(java.util.Map<String,String> selector);
    public Boolean hasSelector();
    
/**
 * This method has been deprecated, please use method buildStrategy instead.
 * @return The buildable object.
 */
@Deprecated public DeploymentStrategy getStrategy();
    public DeploymentStrategy buildStrategy();
    public A withStrategy(DeploymentStrategy strategy);
    public Boolean hasStrategy();
    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.StrategyNested<A> withNewStrategy();
    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.StrategyNested<A> withNewStrategyLike(DeploymentStrategy item);
    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.StrategyNested<A> editStrategy();
    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.StrategyNested<A> editOrNewStrategy();
    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.StrategyNested<A> editOrNewStrategyLike(DeploymentStrategy item);
    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public PodTemplateSpec getTemplate();
    public PodTemplateSpec buildTemplate();
    public A withTemplate(PodTemplateSpec template);
    public Boolean hasTemplate();
    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TemplateNested<A> withNewTemplate();
    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item);
    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TemplateNested<A> editTemplate();
    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TemplateNested<A> editOrNewTemplate();
    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item);
    public Boolean getTest();
    public A withTest(Boolean test);
    public Boolean hasTest();
    public A withNewTest(String arg1);
    public A withNewTest(boolean arg1);
    public A addToTriggers(int index,DeploymentTriggerPolicy item);
    public A setToTriggers(int index,DeploymentTriggerPolicy item);
    public A addToTriggers(DeploymentTriggerPolicy... items);
    public A addAllToTriggers(Collection<DeploymentTriggerPolicy> items);
    public A removeFromTriggers(DeploymentTriggerPolicy... items);
    public A removeAllFromTriggers(Collection<DeploymentTriggerPolicy> items);
    public A removeMatchingFromTriggers(Predicate<DeploymentTriggerPolicyBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildTriggers instead.
 * @return The buildable object.
 */
@Deprecated public List<DeploymentTriggerPolicy> getTriggers();
    public List<DeploymentTriggerPolicy> buildTriggers();
    public DeploymentTriggerPolicy buildTrigger(int index);
    public DeploymentTriggerPolicy buildFirstTrigger();
    public DeploymentTriggerPolicy buildLastTrigger();
    public DeploymentTriggerPolicy buildMatchingTrigger(Predicate<DeploymentTriggerPolicyBuilder> predicate);
    public Boolean hasMatchingTrigger(Predicate<DeploymentTriggerPolicyBuilder> predicate);
    public A withTriggers(List<DeploymentTriggerPolicy> triggers);
    public A withTriggers(DeploymentTriggerPolicy... triggers);
    public Boolean hasTriggers();
    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TriggersNested<A> addNewTrigger();
    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TriggersNested<A> addNewTriggerLike(DeploymentTriggerPolicy item);
    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TriggersNested<A> setNewTriggerLike(int index,DeploymentTriggerPolicy item);
    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TriggersNested<A> editTrigger(int index);
    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TriggersNested<A> editFirstTrigger();
    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TriggersNested<A> editLastTrigger();
    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TriggersNested<A> editMatchingTrigger(Predicate<DeploymentTriggerPolicyBuilder> predicate);
    public interface StrategyNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeploymentStrategyFluent<io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.StrategyNested<N>> {

            public N and();
            public N endStrategy();    }


    public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodTemplateSpecFluent<io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TemplateNested<N>> {

            public N and();
            public N endTemplate();    }


    public interface TriggersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeploymentTriggerPolicyFluent<io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TriggersNested<N>> {

            public N and();
            public N endTrigger();    }


}
