package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface DeploymentConfigStatusFluent<A extends DeploymentConfigStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Integer getAvailableReplicas();
    public A withAvailableReplicas(Integer availableReplicas);
    public Boolean hasAvailableReplicas();
    public A withNewAvailableReplicas(int arg0);
    public A addToConditions(int index,DeploymentCondition item);
    public A setToConditions(int index,DeploymentCondition item);
    public A addToConditions(DeploymentCondition... items);
    public A addAllToConditions(Collection<DeploymentCondition> items);
    public A removeFromConditions(DeploymentCondition... items);
    public A removeAllFromConditions(Collection<DeploymentCondition> items);
    public A removeMatchingFromConditions(Predicate<DeploymentConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<DeploymentCondition> getConditions();
    public List<DeploymentCondition> buildConditions();
    public DeploymentCondition buildCondition(int index);
    public DeploymentCondition buildFirstCondition();
    public DeploymentCondition buildLastCondition();
    public DeploymentCondition buildMatchingCondition(Predicate<DeploymentConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<DeploymentConditionBuilder> predicate);
    public A withConditions(List<DeploymentCondition> conditions);
    public A withConditions(DeploymentCondition... conditions);
    public Boolean hasConditions();
    public io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.ConditionsNested<A> addNewCondition();
    public io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.ConditionsNested<A> addNewConditionLike(DeploymentCondition item);
    public io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.ConditionsNested<A> setNewConditionLike(int index,DeploymentCondition item);
    public io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.ConditionsNested<A> editCondition(int index);
    public io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.ConditionsNested<A> editFirstCondition();
    public io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.ConditionsNested<A> editLastCondition();
    public io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<DeploymentConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildDetails instead.
 * @return The buildable object.
 */
@Deprecated public DeploymentDetails getDetails();
    public DeploymentDetails buildDetails();
    public A withDetails(DeploymentDetails details);
    public Boolean hasDetails();
    public io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.DetailsNested<A> withNewDetails();
    public io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.DetailsNested<A> withNewDetailsLike(DeploymentDetails item);
    public io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.DetailsNested<A> editDetails();
    public io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.DetailsNested<A> editOrNewDetails();
    public io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.DetailsNested<A> editOrNewDetailsLike(DeploymentDetails item);
    public Long getLatestVersion();
    public A withLatestVersion(Long latestVersion);
    public Boolean hasLatestVersion();
    public A withNewLatestVersion(long arg1);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public A withNewObservedGeneration(long arg1);
    public Integer getReadyReplicas();
    public A withReadyReplicas(Integer readyReplicas);
    public Boolean hasReadyReplicas();
    public A withNewReadyReplicas(int arg0);
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Boolean hasReplicas();
    public A withNewReplicas(int arg0);
    public Integer getUnavailableReplicas();
    public A withUnavailableReplicas(Integer unavailableReplicas);
    public Boolean hasUnavailableReplicas();
    public A withNewUnavailableReplicas(int arg0);
    public Integer getUpdatedReplicas();
    public A withUpdatedReplicas(Integer updatedReplicas);
    public Boolean hasUpdatedReplicas();
    public A withNewUpdatedReplicas(int arg0);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeploymentConditionFluent<io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


    public interface DetailsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeploymentDetailsFluent<io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.DetailsNested<N>> {

            public N and();
            public N endDetails();    }


}
