package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface ImageStreamImportSpecFluent<A extends ImageStreamImportSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToImages(int index,ImageImportSpec item);
    public A setToImages(int index,ImageImportSpec item);
    public A addToImages(ImageImportSpec... items);
    public A addAllToImages(Collection<ImageImportSpec> items);
    public A removeFromImages(ImageImportSpec... items);
    public A removeAllFromImages(Collection<ImageImportSpec> items);
    public A removeMatchingFromImages(Predicate<ImageImportSpecBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildImages instead.
 * @return The buildable object.
 */
@Deprecated public List<ImageImportSpec> getImages();
    public List<ImageImportSpec> buildImages();
    public ImageImportSpec buildImage(int index);
    public ImageImportSpec buildFirstImage();
    public ImageImportSpec buildLastImage();
    public ImageImportSpec buildMatchingImage(Predicate<ImageImportSpecBuilder> predicate);
    public Boolean hasMatchingImage(Predicate<ImageImportSpecBuilder> predicate);
    public A withImages(List<ImageImportSpec> images);
    public A withImages(ImageImportSpec... images);
    public Boolean hasImages();
    public io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.ImagesNested<A> addNewImage();
    public io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.ImagesNested<A> addNewImageLike(ImageImportSpec item);
    public io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.ImagesNested<A> setNewImageLike(int index,ImageImportSpec item);
    public io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.ImagesNested<A> editImage(int index);
    public io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.ImagesNested<A> editFirstImage();
    public io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.ImagesNested<A> editLastImage();
    public io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.ImagesNested<A> editMatchingImage(Predicate<ImageImportSpecBuilder> predicate);
    public Boolean getImport();
    public A withImport(Boolean _import);
    public Boolean hasImport();
    public A withNewImport(String arg1);
    public A withNewImport(boolean arg1);
    
/**
 * This method has been deprecated, please use method buildRepository instead.
 * @return The buildable object.
 */
@Deprecated public RepositoryImportSpec getRepository();
    public RepositoryImportSpec buildRepository();
    public A withRepository(RepositoryImportSpec repository);
    public Boolean hasRepository();
    public io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.RepositoryNested<A> withNewRepository();
    public io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.RepositoryNested<A> withNewRepositoryLike(RepositoryImportSpec item);
    public io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.RepositoryNested<A> editRepository();
    public io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.RepositoryNested<A> editOrNewRepository();
    public io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.RepositoryNested<A> editOrNewRepositoryLike(RepositoryImportSpec item);
    public interface ImagesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageImportSpecFluent<io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.ImagesNested<N>> {

            public N and();
            public N endImage();    }


    public interface RepositoryNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RepositoryImportSpecFluent<io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.RepositoryNested<N>> {

            public N and();
            public N endRepository();    }


}
