package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class OperatorHubStatusFluentImpl<A extends OperatorHubStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements OperatorHubStatusFluent<A> {

    private List<HubSourceStatusBuilder> sources =  new ArrayList<HubSourceStatusBuilder>();

    public OperatorHubStatusFluentImpl() {
    }

    public OperatorHubStatusFluentImpl(OperatorHubStatus instance) {
        this.withSources(instance.getSources()); 
    }

    public A addToSources(int index,HubSourceStatus item) {
        if (this.sources == null) {this.sources = new ArrayList<HubSourceStatusBuilder>();}
        HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);_visitables.get("sources").add(index >= 0 ? index : _visitables.get("sources").size(), builder);this.sources.add(index >= 0 ? index : sources.size(), builder); return (A)this;
    }

    public A setToSources(int index,HubSourceStatus item) {
        if (this.sources == null) {this.sources = new ArrayList<HubSourceStatusBuilder>();}
        HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);
        if (index < 0 || index >= _visitables.get("sources").size()) { _visitables.get("sources").add(builder); } else { _visitables.get("sources").set(index, builder);}
        if (index < 0 || index >= sources.size()) { sources.add(builder); } else { sources.set(index, builder);}
         return (A)this;
    }

    public A addToSources(HubSourceStatus... items) {
        if (this.sources == null) {this.sources = new ArrayList<HubSourceStatusBuilder>();}
        for (HubSourceStatus item : items) {HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
    }

    public A addAllToSources(Collection<HubSourceStatus> items) {
        if (this.sources == null) {this.sources = new ArrayList<HubSourceStatusBuilder>();}
        for (HubSourceStatus item : items) {HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
    }

    public A removeFromSources(HubSourceStatus... items) {
        for (HubSourceStatus item : items) {HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
    }

    public A removeAllFromSources(Collection<HubSourceStatus> items) {
        for (HubSourceStatus item : items) {HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSources(Predicate<HubSourceStatusBuilder> predicate) {
        if (sources == null) return (A) this;
        final Iterator<HubSourceStatusBuilder> each = sources.iterator();
        final List visitables = _visitables.get("sources");
        while (each.hasNext()) {
          HubSourceStatusBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSources instead.
 * @return The buildable object.
 */
@Deprecated public List<HubSourceStatus> getSources() {
        return build(sources);
    }

    public List<HubSourceStatus> buildSources() {
        return build(sources);
    }

    public HubSourceStatus buildSource(int index) {
        return this.sources.get(index).build();
    }

    public HubSourceStatus buildFirstSource() {
        return this.sources.get(0).build();
    }

    public HubSourceStatus buildLastSource() {
        return this.sources.get(sources.size() - 1).build();
    }

    public HubSourceStatus buildMatchingSource(Predicate<HubSourceStatusBuilder> predicate) {
        for (HubSourceStatusBuilder item: sources) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingSource(Predicate<HubSourceStatusBuilder> predicate) {
        for (HubSourceStatusBuilder item: sources) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSources(List<HubSourceStatus> sources) {
        if (this.sources != null) { _visitables.get("sources").removeAll(this.sources);}
        if (sources != null) {this.sources = new ArrayList<HubSourceStatusBuilder>(); for (HubSourceStatus item : sources){this.addToSources(item);}} else { this.sources = null;} return (A) this;
    }

    public A withSources(HubSourceStatus... sources) {
        if (this.sources != null) {this.sources.clear();}
        if (sources != null) {for (HubSourceStatus item :sources){ this.addToSources(item);}} return (A) this;
    }

    public Boolean hasSources() {
        return sources != null && !sources.isEmpty();
    }

    public A addNewSource(Boolean disabled,String message,String name,String status) {
        return (A)addToSources(new HubSourceStatus(disabled, message, name, status));
    }

    public io.fabric8.openshift.api.model.OperatorHubStatusFluent.SourcesNested<A> addNewSource() {
        return new SourcesNestedImpl();
    }

    public io.fabric8.openshift.api.model.OperatorHubStatusFluent.SourcesNested<A> addNewSourceLike(HubSourceStatus item) {
        return new SourcesNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.OperatorHubStatusFluent.SourcesNested<A> setNewSourceLike(int index,HubSourceStatus item) {
        return new SourcesNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.OperatorHubStatusFluent.SourcesNested<A> editSource(int index) {
        if (sources.size() <= index) throw new RuntimeException("Can't edit sources. Index exceeds size.");
        return setNewSourceLike(index, buildSource(index));
    }

    public io.fabric8.openshift.api.model.OperatorHubStatusFluent.SourcesNested<A> editFirstSource() {
        if (sources.size() == 0) throw new RuntimeException("Can't edit first sources. The list is empty.");
        return setNewSourceLike(0, buildSource(0));
    }

    public io.fabric8.openshift.api.model.OperatorHubStatusFluent.SourcesNested<A> editLastSource() {
        int index = sources.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last sources. The list is empty.");
        return setNewSourceLike(index, buildSource(index));
    }

    public io.fabric8.openshift.api.model.OperatorHubStatusFluent.SourcesNested<A> editMatchingSource(Predicate<HubSourceStatusBuilder> predicate) {
        int index = -1;
        for (int i=0;i<sources.size();i++) { 
        if (predicate.test(sources.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching sources. No match found.");
        return setNewSourceLike(index, buildSource(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OperatorHubStatusFluentImpl that = (OperatorHubStatusFluentImpl) o;
        if (sources != null ? !sources.equals(that.sources) :that.sources != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(sources,  super.hashCode());
    }

    public class SourcesNestedImpl<N> extends HubSourceStatusFluentImpl<io.fabric8.openshift.api.model.OperatorHubStatusFluent.SourcesNested<N>> implements io.fabric8.openshift.api.model.OperatorHubStatusFluent.SourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final HubSourceStatusBuilder builder;
        private final int index;

            SourcesNestedImpl(int index,HubSourceStatus item) {
                this.index = index;
                this.builder = new HubSourceStatusBuilder(this, item);
                        
            }

            SourcesNestedImpl() {
                this.index = -1;
                this.builder = new HubSourceStatusBuilder(this);
                        
            }

            public N and() {
                return (N) OperatorHubStatusFluentImpl.this.setToSources(index,builder.build());
            }

            public N endSource() {
                return and();
            }
    }


}
