package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class PodSecurityPolicyReviewStatusFluentImpl<A extends PodSecurityPolicyReviewStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PodSecurityPolicyReviewStatusFluent<A> {

    private List<ServiceAccountPodSecurityPolicyReviewStatusBuilder> allowedServiceAccounts =  new ArrayList<ServiceAccountPodSecurityPolicyReviewStatusBuilder>();

    public PodSecurityPolicyReviewStatusFluentImpl() {
    }

    public PodSecurityPolicyReviewStatusFluentImpl(PodSecurityPolicyReviewStatus instance) {
        this.withAllowedServiceAccounts(instance.getAllowedServiceAccounts()); 
    }

    public A addToAllowedServiceAccounts(int index,ServiceAccountPodSecurityPolicyReviewStatus item) {
        if (this.allowedServiceAccounts == null) {this.allowedServiceAccounts = new ArrayList<ServiceAccountPodSecurityPolicyReviewStatusBuilder>();}
        ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(item);_visitables.get("allowedServiceAccounts").add(index >= 0 ? index : _visitables.get("allowedServiceAccounts").size(), builder);this.allowedServiceAccounts.add(index >= 0 ? index : allowedServiceAccounts.size(), builder); return (A)this;
    }

    public A setToAllowedServiceAccounts(int index,ServiceAccountPodSecurityPolicyReviewStatus item) {
        if (this.allowedServiceAccounts == null) {this.allowedServiceAccounts = new ArrayList<ServiceAccountPodSecurityPolicyReviewStatusBuilder>();}
        ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(item);
        if (index < 0 || index >= _visitables.get("allowedServiceAccounts").size()) { _visitables.get("allowedServiceAccounts").add(builder); } else { _visitables.get("allowedServiceAccounts").set(index, builder);}
        if (index < 0 || index >= allowedServiceAccounts.size()) { allowedServiceAccounts.add(builder); } else { allowedServiceAccounts.set(index, builder);}
         return (A)this;
    }

    public A addToAllowedServiceAccounts(ServiceAccountPodSecurityPolicyReviewStatus... items) {
        if (this.allowedServiceAccounts == null) {this.allowedServiceAccounts = new ArrayList<ServiceAccountPodSecurityPolicyReviewStatusBuilder>();}
        for (ServiceAccountPodSecurityPolicyReviewStatus item : items) {ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(item);_visitables.get("allowedServiceAccounts").add(builder);this.allowedServiceAccounts.add(builder);} return (A)this;
    }

    public A addAllToAllowedServiceAccounts(Collection<ServiceAccountPodSecurityPolicyReviewStatus> items) {
        if (this.allowedServiceAccounts == null) {this.allowedServiceAccounts = new ArrayList<ServiceAccountPodSecurityPolicyReviewStatusBuilder>();}
        for (ServiceAccountPodSecurityPolicyReviewStatus item : items) {ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(item);_visitables.get("allowedServiceAccounts").add(builder);this.allowedServiceAccounts.add(builder);} return (A)this;
    }

    public A removeFromAllowedServiceAccounts(ServiceAccountPodSecurityPolicyReviewStatus... items) {
        for (ServiceAccountPodSecurityPolicyReviewStatus item : items) {ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(item);_visitables.get("allowedServiceAccounts").remove(builder);if (this.allowedServiceAccounts != null) {this.allowedServiceAccounts.remove(builder);}} return (A)this;
    }

    public A removeAllFromAllowedServiceAccounts(Collection<ServiceAccountPodSecurityPolicyReviewStatus> items) {
        for (ServiceAccountPodSecurityPolicyReviewStatus item : items) {ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(item);_visitables.get("allowedServiceAccounts").remove(builder);if (this.allowedServiceAccounts != null) {this.allowedServiceAccounts.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromAllowedServiceAccounts(Predicate<ServiceAccountPodSecurityPolicyReviewStatusBuilder> predicate) {
        if (allowedServiceAccounts == null) return (A) this;
        final Iterator<ServiceAccountPodSecurityPolicyReviewStatusBuilder> each = allowedServiceAccounts.iterator();
        final List visitables = _visitables.get("allowedServiceAccounts");
        while (each.hasNext()) {
          ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildAllowedServiceAccounts instead.
 * @return The buildable object.
 */
@Deprecated public List<ServiceAccountPodSecurityPolicyReviewStatus> getAllowedServiceAccounts() {
        return build(allowedServiceAccounts);
    }

    public List<ServiceAccountPodSecurityPolicyReviewStatus> buildAllowedServiceAccounts() {
        return build(allowedServiceAccounts);
    }

    public ServiceAccountPodSecurityPolicyReviewStatus buildAllowedServiceAccount(int index) {
        return this.allowedServiceAccounts.get(index).build();
    }

    public ServiceAccountPodSecurityPolicyReviewStatus buildFirstAllowedServiceAccount() {
        return this.allowedServiceAccounts.get(0).build();
    }

    public ServiceAccountPodSecurityPolicyReviewStatus buildLastAllowedServiceAccount() {
        return this.allowedServiceAccounts.get(allowedServiceAccounts.size() - 1).build();
    }

    public ServiceAccountPodSecurityPolicyReviewStatus buildMatchingAllowedServiceAccount(Predicate<ServiceAccountPodSecurityPolicyReviewStatusBuilder> predicate) {
        for (ServiceAccountPodSecurityPolicyReviewStatusBuilder item: allowedServiceAccounts) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingAllowedServiceAccount(Predicate<ServiceAccountPodSecurityPolicyReviewStatusBuilder> predicate) {
        for (ServiceAccountPodSecurityPolicyReviewStatusBuilder item: allowedServiceAccounts) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAllowedServiceAccounts(List<ServiceAccountPodSecurityPolicyReviewStatus> allowedServiceAccounts) {
        if (this.allowedServiceAccounts != null) { _visitables.get("allowedServiceAccounts").removeAll(this.allowedServiceAccounts);}
        if (allowedServiceAccounts != null) {this.allowedServiceAccounts = new ArrayList<ServiceAccountPodSecurityPolicyReviewStatusBuilder>(); for (ServiceAccountPodSecurityPolicyReviewStatus item : allowedServiceAccounts){this.addToAllowedServiceAccounts(item);}} else { this.allowedServiceAccounts = null;} return (A) this;
    }

    public A withAllowedServiceAccounts(ServiceAccountPodSecurityPolicyReviewStatus... allowedServiceAccounts) {
        if (this.allowedServiceAccounts != null) {this.allowedServiceAccounts.clear();}
        if (allowedServiceAccounts != null) {for (ServiceAccountPodSecurityPolicyReviewStatus item :allowedServiceAccounts){ this.addToAllowedServiceAccounts(item);}} return (A) this;
    }

    public Boolean hasAllowedServiceAccounts() {
        return allowedServiceAccounts != null && !allowedServiceAccounts.isEmpty();
    }

    public io.fabric8.openshift.api.model.PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> addNewAllowedServiceAccount() {
        return new AllowedServiceAccountsNestedImpl();
    }

    public io.fabric8.openshift.api.model.PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> addNewAllowedServiceAccountLike(ServiceAccountPodSecurityPolicyReviewStatus item) {
        return new AllowedServiceAccountsNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> setNewAllowedServiceAccountLike(int index,ServiceAccountPodSecurityPolicyReviewStatus item) {
        return new AllowedServiceAccountsNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> editAllowedServiceAccount(int index) {
        if (allowedServiceAccounts.size() <= index) throw new RuntimeException("Can't edit allowedServiceAccounts. Index exceeds size.");
        return setNewAllowedServiceAccountLike(index, buildAllowedServiceAccount(index));
    }

    public io.fabric8.openshift.api.model.PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> editFirstAllowedServiceAccount() {
        if (allowedServiceAccounts.size() == 0) throw new RuntimeException("Can't edit first allowedServiceAccounts. The list is empty.");
        return setNewAllowedServiceAccountLike(0, buildAllowedServiceAccount(0));
    }

    public io.fabric8.openshift.api.model.PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> editLastAllowedServiceAccount() {
        int index = allowedServiceAccounts.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last allowedServiceAccounts. The list is empty.");
        return setNewAllowedServiceAccountLike(index, buildAllowedServiceAccount(index));
    }

    public io.fabric8.openshift.api.model.PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> editMatchingAllowedServiceAccount(Predicate<ServiceAccountPodSecurityPolicyReviewStatusBuilder> predicate) {
        int index = -1;
        for (int i=0;i<allowedServiceAccounts.size();i++) { 
        if (predicate.test(allowedServiceAccounts.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching allowedServiceAccounts. No match found.");
        return setNewAllowedServiceAccountLike(index, buildAllowedServiceAccount(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PodSecurityPolicyReviewStatusFluentImpl that = (PodSecurityPolicyReviewStatusFluentImpl) o;
        if (allowedServiceAccounts != null ? !allowedServiceAccounts.equals(that.allowedServiceAccounts) :that.allowedServiceAccounts != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(allowedServiceAccounts,  super.hashCode());
    }

    public class AllowedServiceAccountsNestedImpl<N> extends ServiceAccountPodSecurityPolicyReviewStatusFluentImpl<io.fabric8.openshift.api.model.PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<N>> implements io.fabric8.openshift.api.model.PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServiceAccountPodSecurityPolicyReviewStatusBuilder builder;
        private final int index;

            AllowedServiceAccountsNestedImpl(int index,ServiceAccountPodSecurityPolicyReviewStatus item) {
                this.index = index;
                this.builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(this, item);
                        
            }

            AllowedServiceAccountsNestedImpl() {
                this.index = -1;
                this.builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(this);
                        
            }

            public N and() {
                return (N) PodSecurityPolicyReviewStatusFluentImpl.this.setToAllowedServiceAccounts(index,builder.build());
            }

            public N endAllowedServiceAccount() {
                return and();
            }
    }


}
