package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodSecurityPolicySelfSubjectReviewBuilder extends PodSecurityPolicySelfSubjectReviewFluentImpl<PodSecurityPolicySelfSubjectReviewBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<PodSecurityPolicySelfSubjectReview,PodSecurityPolicySelfSubjectReviewBuilder> {

    PodSecurityPolicySelfSubjectReviewFluent<?> fluent;
    Boolean validationEnabled;

    public PodSecurityPolicySelfSubjectReviewBuilder() {
        this(true);
    }

    public PodSecurityPolicySelfSubjectReviewBuilder(Boolean validationEnabled) {
        this(new PodSecurityPolicySelfSubjectReview(), validationEnabled);
    }

    public PodSecurityPolicySelfSubjectReviewBuilder(PodSecurityPolicySelfSubjectReviewFluent<?> fluent) {
        this(fluent, true);
    }

    public PodSecurityPolicySelfSubjectReviewBuilder(PodSecurityPolicySelfSubjectReviewFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PodSecurityPolicySelfSubjectReview(), validationEnabled);
    }

    public PodSecurityPolicySelfSubjectReviewBuilder(PodSecurityPolicySelfSubjectReviewFluent<?> fluent,PodSecurityPolicySelfSubjectReview instance) {
        this(fluent, instance, true);
    }

    public PodSecurityPolicySelfSubjectReviewBuilder(PodSecurityPolicySelfSubjectReviewFluent<?> fluent,PodSecurityPolicySelfSubjectReview instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodSecurityPolicySelfSubjectReviewBuilder(PodSecurityPolicySelfSubjectReview instance) {
        this(instance,true);
    }

    public PodSecurityPolicySelfSubjectReviewBuilder(PodSecurityPolicySelfSubjectReview instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodSecurityPolicySelfSubjectReview build() {
        PodSecurityPolicySelfSubjectReview buildable = new PodSecurityPolicySelfSubjectReview(fluent.getApiVersion(),fluent.getKind(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodSecurityPolicySelfSubjectReviewBuilder that = (PodSecurityPolicySelfSubjectReviewBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
