package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterResourceQuotaBuilder extends ClusterResourceQuotaFluentImpl<ClusterResourceQuotaBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<ClusterResourceQuota,ClusterResourceQuotaBuilder> {

    ClusterResourceQuotaFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterResourceQuotaBuilder() {
        this(true);
    }

    public ClusterResourceQuotaBuilder(Boolean validationEnabled) {
        this(new ClusterResourceQuota(), validationEnabled);
    }

    public ClusterResourceQuotaBuilder(ClusterResourceQuotaFluent<?> fluent) {
        this(fluent, true);
    }

    public ClusterResourceQuotaBuilder(ClusterResourceQuotaFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ClusterResourceQuota(), validationEnabled);
    }

    public ClusterResourceQuotaBuilder(ClusterResourceQuotaFluent<?> fluent,ClusterResourceQuota instance) {
        this(fluent, instance, true);
    }

    public ClusterResourceQuotaBuilder(ClusterResourceQuotaFluent<?> fluent,ClusterResourceQuota instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterResourceQuotaBuilder(ClusterResourceQuota instance) {
        this(instance,true);
    }

    public ClusterResourceQuotaBuilder(ClusterResourceQuota instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterResourceQuota build() {
        ClusterResourceQuota buildable = new ClusterResourceQuota(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterResourceQuotaBuilder that = (ClusterResourceQuotaBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
