package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConfigMapNameReferenceBuilder extends ConfigMapNameReferenceFluentImpl<ConfigMapNameReferenceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<ConfigMapNameReference,ConfigMapNameReferenceBuilder> {

    ConfigMapNameReferenceFluent<?> fluent;
    Boolean validationEnabled;

    public ConfigMapNameReferenceBuilder() {
        this(true);
    }

    public ConfigMapNameReferenceBuilder(Boolean validationEnabled) {
        this(new ConfigMapNameReference(), validationEnabled);
    }

    public ConfigMapNameReferenceBuilder(ConfigMapNameReferenceFluent<?> fluent) {
        this(fluent, true);
    }

    public ConfigMapNameReferenceBuilder(ConfigMapNameReferenceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ConfigMapNameReference(), validationEnabled);
    }

    public ConfigMapNameReferenceBuilder(ConfigMapNameReferenceFluent<?> fluent,ConfigMapNameReference instance) {
        this(fluent, instance, true);
    }

    public ConfigMapNameReferenceBuilder(ConfigMapNameReferenceFluent<?> fluent,ConfigMapNameReference instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConfigMapNameReferenceBuilder(ConfigMapNameReference instance) {
        this(instance,true);
    }

    public ConfigMapNameReferenceBuilder(ConfigMapNameReference instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConfigMapNameReference build() {
        ConfigMapNameReference buildable = new ConfigMapNameReference(fluent.getName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConfigMapNameReferenceBuilder that = (ConfigMapNameReferenceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
