package io.fabric8.openshift.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ImageSourcePathFluentImpl<A extends ImageSourcePathFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ImageSourcePathFluent<A> {

    private String destinationDir;
    private String sourcePath;

    public ImageSourcePathFluentImpl() {
    }

    public ImageSourcePathFluentImpl(ImageSourcePath instance) {
        this.withDestinationDir(instance.getDestinationDir()); 
        this.withSourcePath(instance.getSourcePath()); 
    }

    public String getDestinationDir() {
        return this.destinationDir;
    }

    public A withDestinationDir(String destinationDir) {
        this.destinationDir=destinationDir; return (A) this;
    }

    public Boolean hasDestinationDir() {
        return this.destinationDir != null;
    }

    public A withNewDestinationDir(StringBuilder arg1) {
        return (A)withDestinationDir(new String(arg1));
    }

    public A withNewDestinationDir(int[] arg1,int arg2,int arg3) {
        return (A)withDestinationDir(new String(arg1, arg2, arg3));
    }

    public A withNewDestinationDir(char[] arg1) {
        return (A)withDestinationDir(new String(arg1));
    }

    public A withNewDestinationDir(StringBuffer arg1) {
        return (A)withDestinationDir(new String(arg1));
    }

    public A withNewDestinationDir(byte[] arg1,int arg2) {
        return (A)withDestinationDir(new String(arg1, arg2));
    }

    public A withNewDestinationDir(byte[] arg1) {
        return (A)withDestinationDir(new String(arg1));
    }

    public A withNewDestinationDir(char[] arg1,int arg2,int arg3) {
        return (A)withDestinationDir(new String(arg1, arg2, arg3));
    }

    public A withNewDestinationDir(byte[] arg1,int arg2,int arg3) {
        return (A)withDestinationDir(new String(arg1, arg2, arg3));
    }

    public A withNewDestinationDir(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withDestinationDir(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewDestinationDir(String arg1) {
        return (A)withDestinationDir(new String(arg1));
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public A withSourcePath(String sourcePath) {
        this.sourcePath=sourcePath; return (A) this;
    }

    public Boolean hasSourcePath() {
        return this.sourcePath != null;
    }

    public A withNewSourcePath(StringBuilder arg1) {
        return (A)withSourcePath(new String(arg1));
    }

    public A withNewSourcePath(int[] arg1,int arg2,int arg3) {
        return (A)withSourcePath(new String(arg1, arg2, arg3));
    }

    public A withNewSourcePath(char[] arg1) {
        return (A)withSourcePath(new String(arg1));
    }

    public A withNewSourcePath(StringBuffer arg1) {
        return (A)withSourcePath(new String(arg1));
    }

    public A withNewSourcePath(byte[] arg1,int arg2) {
        return (A)withSourcePath(new String(arg1, arg2));
    }

    public A withNewSourcePath(byte[] arg1) {
        return (A)withSourcePath(new String(arg1));
    }

    public A withNewSourcePath(char[] arg1,int arg2,int arg3) {
        return (A)withSourcePath(new String(arg1, arg2, arg3));
    }

    public A withNewSourcePath(byte[] arg1,int arg2,int arg3) {
        return (A)withSourcePath(new String(arg1, arg2, arg3));
    }

    public A withNewSourcePath(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withSourcePath(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewSourcePath(String arg1) {
        return (A)withSourcePath(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ImageSourcePathFluentImpl that = (ImageSourcePathFluentImpl) o;
        if (destinationDir != null ? !destinationDir.equals(that.destinationDir) :that.destinationDir != null) return false;
        if (sourcePath != null ? !sourcePath.equals(that.sourcePath) :that.sourcePath != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(destinationDir,  sourcePath,  super.hashCode());
    }

}
