package io.fabric8.openshift.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class IngressSpecFluentImpl<A extends IngressSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IngressSpecFluent<A> {

    private String domain;

    public IngressSpecFluentImpl() {
    }

    public IngressSpecFluentImpl(IngressSpec instance) {
        this.withDomain(instance.getDomain()); 
    }

    public String getDomain() {
        return this.domain;
    }

    public A withDomain(String domain) {
        this.domain=domain; return (A) this;
    }

    public Boolean hasDomain() {
        return this.domain != null;
    }

    public A withNewDomain(StringBuilder arg1) {
        return (A)withDomain(new String(arg1));
    }

    public A withNewDomain(int[] arg1,int arg2,int arg3) {
        return (A)withDomain(new String(arg1, arg2, arg3));
    }

    public A withNewDomain(char[] arg1) {
        return (A)withDomain(new String(arg1));
    }

    public A withNewDomain(StringBuffer arg1) {
        return (A)withDomain(new String(arg1));
    }

    public A withNewDomain(byte[] arg1,int arg2) {
        return (A)withDomain(new String(arg1, arg2));
    }

    public A withNewDomain(byte[] arg1) {
        return (A)withDomain(new String(arg1));
    }

    public A withNewDomain(char[] arg1,int arg2,int arg3) {
        return (A)withDomain(new String(arg1, arg2, arg3));
    }

    public A withNewDomain(byte[] arg1,int arg2,int arg3) {
        return (A)withDomain(new String(arg1, arg2, arg3));
    }

    public A withNewDomain(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withDomain(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewDomain(String arg1) {
        return (A)withDomain(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IngressSpecFluentImpl that = (IngressSpecFluentImpl) o;
        if (domain != null ? !domain.equals(that.domain) :that.domain != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(domain,  super.hashCode());
    }

}
