package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class LifecycleHookFluentImpl<A extends LifecycleHookFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements LifecycleHookFluent<A> {

    private ExecNewPodHookBuilder execNewPod;
    private String failurePolicy;
    private List<TagImageHookBuilder> tagImages =  new ArrayList<TagImageHookBuilder>();

    public LifecycleHookFluentImpl() {
    }

    public LifecycleHookFluentImpl(LifecycleHook instance) {
        this.withExecNewPod(instance.getExecNewPod()); 
        this.withFailurePolicy(instance.getFailurePolicy()); 
        this.withTagImages(instance.getTagImages()); 
    }

    
/**
 * This method has been deprecated, please use method buildExecNewPod instead.
 * @return The buildable object.
 */
@Deprecated public ExecNewPodHook getExecNewPod() {
        return this.execNewPod!=null?this.execNewPod.build():null;
    }

    public ExecNewPodHook buildExecNewPod() {
        return this.execNewPod!=null?this.execNewPod.build():null;
    }

    public A withExecNewPod(ExecNewPodHook execNewPod) {
        _visitables.get("execNewPod").remove(this.execNewPod);
        if (execNewPod!=null){ this.execNewPod= new ExecNewPodHookBuilder(execNewPod); _visitables.get("execNewPod").add(this.execNewPod);} return (A) this;
    }

    public Boolean hasExecNewPod() {
        return this.execNewPod != null;
    }

    public io.fabric8.openshift.api.model.LifecycleHookFluent.ExecNewPodNested<A> withNewExecNewPod() {
        return new ExecNewPodNestedImpl();
    }

    public io.fabric8.openshift.api.model.LifecycleHookFluent.ExecNewPodNested<A> withNewExecNewPodLike(ExecNewPodHook item) {
        return new ExecNewPodNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.LifecycleHookFluent.ExecNewPodNested<A> editExecNewPod() {
        return withNewExecNewPodLike(getExecNewPod());
    }

    public io.fabric8.openshift.api.model.LifecycleHookFluent.ExecNewPodNested<A> editOrNewExecNewPod() {
        return withNewExecNewPodLike(getExecNewPod() != null ? getExecNewPod(): new ExecNewPodHookBuilder().build());
    }

    public io.fabric8.openshift.api.model.LifecycleHookFluent.ExecNewPodNested<A> editOrNewExecNewPodLike(ExecNewPodHook item) {
        return withNewExecNewPodLike(getExecNewPod() != null ? getExecNewPod(): item);
    }

    public String getFailurePolicy() {
        return this.failurePolicy;
    }

    public A withFailurePolicy(String failurePolicy) {
        this.failurePolicy=failurePolicy; return (A) this;
    }

    public Boolean hasFailurePolicy() {
        return this.failurePolicy != null;
    }

    public A withNewFailurePolicy(StringBuilder arg1) {
        return (A)withFailurePolicy(new String(arg1));
    }

    public A withNewFailurePolicy(int[] arg1,int arg2,int arg3) {
        return (A)withFailurePolicy(new String(arg1, arg2, arg3));
    }

    public A withNewFailurePolicy(char[] arg1) {
        return (A)withFailurePolicy(new String(arg1));
    }

    public A withNewFailurePolicy(StringBuffer arg1) {
        return (A)withFailurePolicy(new String(arg1));
    }

    public A withNewFailurePolicy(byte[] arg1,int arg2) {
        return (A)withFailurePolicy(new String(arg1, arg2));
    }

    public A withNewFailurePolicy(byte[] arg1) {
        return (A)withFailurePolicy(new String(arg1));
    }

    public A withNewFailurePolicy(char[] arg1,int arg2,int arg3) {
        return (A)withFailurePolicy(new String(arg1, arg2, arg3));
    }

    public A withNewFailurePolicy(byte[] arg1,int arg2,int arg3) {
        return (A)withFailurePolicy(new String(arg1, arg2, arg3));
    }

    public A withNewFailurePolicy(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withFailurePolicy(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewFailurePolicy(String arg1) {
        return (A)withFailurePolicy(new String(arg1));
    }

    public A addToTagImages(int index,TagImageHook item) {
        if (this.tagImages == null) {this.tagImages = new ArrayList<TagImageHookBuilder>();}
        TagImageHookBuilder builder = new TagImageHookBuilder(item);_visitables.get("tagImages").add(index >= 0 ? index : _visitables.get("tagImages").size(), builder);this.tagImages.add(index >= 0 ? index : tagImages.size(), builder); return (A)this;
    }

    public A setToTagImages(int index,TagImageHook item) {
        if (this.tagImages == null) {this.tagImages = new ArrayList<TagImageHookBuilder>();}
        TagImageHookBuilder builder = new TagImageHookBuilder(item);
        if (index < 0 || index >= _visitables.get("tagImages").size()) { _visitables.get("tagImages").add(builder); } else { _visitables.get("tagImages").set(index, builder);}
        if (index < 0 || index >= tagImages.size()) { tagImages.add(builder); } else { tagImages.set(index, builder);}
         return (A)this;
    }

    public A addToTagImages(TagImageHook... items) {
        if (this.tagImages == null) {this.tagImages = new ArrayList<TagImageHookBuilder>();}
        for (TagImageHook item : items) {TagImageHookBuilder builder = new TagImageHookBuilder(item);_visitables.get("tagImages").add(builder);this.tagImages.add(builder);} return (A)this;
    }

    public A addAllToTagImages(Collection<TagImageHook> items) {
        if (this.tagImages == null) {this.tagImages = new ArrayList<TagImageHookBuilder>();}
        for (TagImageHook item : items) {TagImageHookBuilder builder = new TagImageHookBuilder(item);_visitables.get("tagImages").add(builder);this.tagImages.add(builder);} return (A)this;
    }

    public A removeFromTagImages(TagImageHook... items) {
        for (TagImageHook item : items) {TagImageHookBuilder builder = new TagImageHookBuilder(item);_visitables.get("tagImages").remove(builder);if (this.tagImages != null) {this.tagImages.remove(builder);}} return (A)this;
    }

    public A removeAllFromTagImages(Collection<TagImageHook> items) {
        for (TagImageHook item : items) {TagImageHookBuilder builder = new TagImageHookBuilder(item);_visitables.get("tagImages").remove(builder);if (this.tagImages != null) {this.tagImages.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTagImages(Predicate<TagImageHookBuilder> predicate) {
        if (tagImages == null) return (A) this;
        final Iterator<TagImageHookBuilder> each = tagImages.iterator();
        final List visitables = _visitables.get("tagImages");
        while (each.hasNext()) {
          TagImageHookBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTagImages instead.
 * @return The buildable object.
 */
@Deprecated public List<TagImageHook> getTagImages() {
        return build(tagImages);
    }

    public List<TagImageHook> buildTagImages() {
        return build(tagImages);
    }

    public TagImageHook buildTagImage(int index) {
        return this.tagImages.get(index).build();
    }

    public TagImageHook buildFirstTagImage() {
        return this.tagImages.get(0).build();
    }

    public TagImageHook buildLastTagImage() {
        return this.tagImages.get(tagImages.size() - 1).build();
    }

    public TagImageHook buildMatchingTagImage(Predicate<TagImageHookBuilder> predicate) {
        for (TagImageHookBuilder item: tagImages) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingTagImage(Predicate<TagImageHookBuilder> predicate) {
        for (TagImageHookBuilder item: tagImages) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTagImages(List<TagImageHook> tagImages) {
        if (this.tagImages != null) { _visitables.get("tagImages").removeAll(this.tagImages);}
        if (tagImages != null) {this.tagImages = new ArrayList<TagImageHookBuilder>(); for (TagImageHook item : tagImages){this.addToTagImages(item);}} else { this.tagImages = null;} return (A) this;
    }

    public A withTagImages(TagImageHook... tagImages) {
        if (this.tagImages != null) {this.tagImages.clear();}
        if (tagImages != null) {for (TagImageHook item :tagImages){ this.addToTagImages(item);}} return (A) this;
    }

    public Boolean hasTagImages() {
        return tagImages != null && !tagImages.isEmpty();
    }

    public io.fabric8.openshift.api.model.LifecycleHookFluent.TagImagesNested<A> addNewTagImage() {
        return new TagImagesNestedImpl();
    }

    public io.fabric8.openshift.api.model.LifecycleHookFluent.TagImagesNested<A> addNewTagImageLike(TagImageHook item) {
        return new TagImagesNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.LifecycleHookFluent.TagImagesNested<A> setNewTagImageLike(int index,TagImageHook item) {
        return new TagImagesNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.LifecycleHookFluent.TagImagesNested<A> editTagImage(int index) {
        if (tagImages.size() <= index) throw new RuntimeException("Can't edit tagImages. Index exceeds size.");
        return setNewTagImageLike(index, buildTagImage(index));
    }

    public io.fabric8.openshift.api.model.LifecycleHookFluent.TagImagesNested<A> editFirstTagImage() {
        if (tagImages.size() == 0) throw new RuntimeException("Can't edit first tagImages. The list is empty.");
        return setNewTagImageLike(0, buildTagImage(0));
    }

    public io.fabric8.openshift.api.model.LifecycleHookFluent.TagImagesNested<A> editLastTagImage() {
        int index = tagImages.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last tagImages. The list is empty.");
        return setNewTagImageLike(index, buildTagImage(index));
    }

    public io.fabric8.openshift.api.model.LifecycleHookFluent.TagImagesNested<A> editMatchingTagImage(Predicate<TagImageHookBuilder> predicate) {
        int index = -1;
        for (int i=0;i<tagImages.size();i++) { 
        if (predicate.test(tagImages.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching tagImages. No match found.");
        return setNewTagImageLike(index, buildTagImage(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LifecycleHookFluentImpl that = (LifecycleHookFluentImpl) o;
        if (execNewPod != null ? !execNewPod.equals(that.execNewPod) :that.execNewPod != null) return false;
        if (failurePolicy != null ? !failurePolicy.equals(that.failurePolicy) :that.failurePolicy != null) return false;
        if (tagImages != null ? !tagImages.equals(that.tagImages) :that.tagImages != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(execNewPod,  failurePolicy,  tagImages,  super.hashCode());
    }

    public class ExecNewPodNestedImpl<N> extends ExecNewPodHookFluentImpl<io.fabric8.openshift.api.model.LifecycleHookFluent.ExecNewPodNested<N>> implements io.fabric8.openshift.api.model.LifecycleHookFluent.ExecNewPodNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ExecNewPodHookBuilder builder;

            ExecNewPodNestedImpl(ExecNewPodHook item) {
                this.builder = new ExecNewPodHookBuilder(this, item);
                        
            }

            ExecNewPodNestedImpl() {
                this.builder = new ExecNewPodHookBuilder(this);
                        
            }

            public N and() {
                return (N) LifecycleHookFluentImpl.this.withExecNewPod(builder.build());
            }

            public N endExecNewPod() {
                return and();
            }
    }


    public class TagImagesNestedImpl<N> extends TagImageHookFluentImpl<io.fabric8.openshift.api.model.LifecycleHookFluent.TagImagesNested<N>> implements io.fabric8.openshift.api.model.LifecycleHookFluent.TagImagesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TagImageHookBuilder builder;
        private final int index;

            TagImagesNestedImpl(int index,TagImageHook item) {
                this.index = index;
                this.builder = new TagImageHookBuilder(this, item);
                        
            }

            TagImagesNestedImpl() {
                this.index = -1;
                this.builder = new TagImageHookBuilder(this);
                        
            }

            public N and() {
                return (N) LifecycleHookFluentImpl.this.setToTagImages(index,builder.build());
            }

            public N endTagImage() {
                return and();
            }
    }


}
