package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface OAuthClientFluent<A extends OAuthClientFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Integer getAccessTokenInactivityTimeoutSeconds();
    public A withAccessTokenInactivityTimeoutSeconds(Integer accessTokenInactivityTimeoutSeconds);
    public Boolean hasAccessTokenInactivityTimeoutSeconds();
    public A withNewAccessTokenInactivityTimeoutSeconds(int arg0);
    public Integer getAccessTokenMaxAgeSeconds();
    public A withAccessTokenMaxAgeSeconds(Integer accessTokenMaxAgeSeconds);
    public Boolean hasAccessTokenMaxAgeSeconds();
    public A withNewAccessTokenMaxAgeSeconds(int arg0);
    public A addToAdditionalSecrets(int index,String item);
    public A setToAdditionalSecrets(int index,String item);
    public A addToAdditionalSecrets(String... items);
    public A addAllToAdditionalSecrets(Collection<String> items);
    public A removeFromAdditionalSecrets(String... items);
    public A removeAllFromAdditionalSecrets(Collection<String> items);
    public List<String> getAdditionalSecrets();
    public String getAdditionalSecret(int index);
    public String getFirstAdditionalSecret();
    public String getLastAdditionalSecret();
    public String getMatchingAdditionalSecret(Predicate<String> predicate);
    public Boolean hasMatchingAdditionalSecret(Predicate<String> predicate);
    public A withAdditionalSecrets(List<String> additionalSecrets);
    public A withAdditionalSecrets(String... additionalSecrets);
    public Boolean hasAdditionalSecrets();
    public A addNewAdditionalSecret(StringBuilder arg1);
    public A addNewAdditionalSecret(int[] arg1,int arg2,int arg3);
    public A addNewAdditionalSecret(char[] arg1);
    public A addNewAdditionalSecret(StringBuffer arg1);
    public A addNewAdditionalSecret(byte[] arg1,int arg2);
    public A addNewAdditionalSecret(byte[] arg1);
    public A addNewAdditionalSecret(char[] arg1,int arg2,int arg3);
    public A addNewAdditionalSecret(byte[] arg1,int arg2,int arg3);
    public A addNewAdditionalSecret(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewAdditionalSecret(String arg1);
    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public String getGrantMethod();
    public A withGrantMethod(String grantMethod);
    public Boolean hasGrantMethod();
    public A withNewGrantMethod(StringBuilder arg1);
    public A withNewGrantMethod(int[] arg1,int arg2,int arg3);
    public A withNewGrantMethod(char[] arg1);
    public A withNewGrantMethod(StringBuffer arg1);
    public A withNewGrantMethod(byte[] arg1,int arg2);
    public A withNewGrantMethod(byte[] arg1);
    public A withNewGrantMethod(char[] arg1,int arg2,int arg3);
    public A withNewGrantMethod(byte[] arg1,int arg2,int arg3);
    public A withNewGrantMethod(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewGrantMethod(String arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public io.fabric8.openshift.api.model.OAuthClientFluent.MetadataNested<A> withNewMetadata();
    public io.fabric8.openshift.api.model.OAuthClientFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public io.fabric8.openshift.api.model.OAuthClientFluent.MetadataNested<A> editMetadata();
    public io.fabric8.openshift.api.model.OAuthClientFluent.MetadataNested<A> editOrNewMetadata();
    public io.fabric8.openshift.api.model.OAuthClientFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public A addToRedirectURIs(int index,String item);
    public A setToRedirectURIs(int index,String item);
    public A addToRedirectURIs(String... items);
    public A addAllToRedirectURIs(Collection<String> items);
    public A removeFromRedirectURIs(String... items);
    public A removeAllFromRedirectURIs(Collection<String> items);
    public List<String> getRedirectURIs();
    public String getRedirectURI(int index);
    public String getFirstRedirectURI();
    public String getLastRedirectURI();
    public String getMatchingRedirectURI(Predicate<String> predicate);
    public Boolean hasMatchingRedirectURI(Predicate<String> predicate);
    public A withRedirectURIs(List<String> redirectURIs);
    public A withRedirectURIs(String... redirectURIs);
    public Boolean hasRedirectURIs();
    public A addNewRedirectURI(StringBuilder arg1);
    public A addNewRedirectURI(int[] arg1,int arg2,int arg3);
    public A addNewRedirectURI(char[] arg1);
    public A addNewRedirectURI(StringBuffer arg1);
    public A addNewRedirectURI(byte[] arg1,int arg2);
    public A addNewRedirectURI(byte[] arg1);
    public A addNewRedirectURI(char[] arg1,int arg2,int arg3);
    public A addNewRedirectURI(byte[] arg1,int arg2,int arg3);
    public A addNewRedirectURI(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewRedirectURI(String arg1);
    public Boolean getRespondWithChallenges();
    public A withRespondWithChallenges(Boolean respondWithChallenges);
    public Boolean hasRespondWithChallenges();
    public A withNewRespondWithChallenges(String arg1);
    public A withNewRespondWithChallenges(boolean arg1);
    public A addToScopeRestrictions(int index,ScopeRestriction item);
    public A setToScopeRestrictions(int index,ScopeRestriction item);
    public A addToScopeRestrictions(ScopeRestriction... items);
    public A addAllToScopeRestrictions(Collection<ScopeRestriction> items);
    public A removeFromScopeRestrictions(ScopeRestriction... items);
    public A removeAllFromScopeRestrictions(Collection<ScopeRestriction> items);
    public A removeMatchingFromScopeRestrictions(Predicate<ScopeRestrictionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildScopeRestrictions instead.
 * @return The buildable object.
 */
@Deprecated public List<ScopeRestriction> getScopeRestrictions();
    public List<ScopeRestriction> buildScopeRestrictions();
    public ScopeRestriction buildScopeRestriction(int index);
    public ScopeRestriction buildFirstScopeRestriction();
    public ScopeRestriction buildLastScopeRestriction();
    public ScopeRestriction buildMatchingScopeRestriction(Predicate<ScopeRestrictionBuilder> predicate);
    public Boolean hasMatchingScopeRestriction(Predicate<ScopeRestrictionBuilder> predicate);
    public A withScopeRestrictions(List<ScopeRestriction> scopeRestrictions);
    public A withScopeRestrictions(ScopeRestriction... scopeRestrictions);
    public Boolean hasScopeRestrictions();
    public io.fabric8.openshift.api.model.OAuthClientFluent.ScopeRestrictionsNested<A> addNewScopeRestriction();
    public io.fabric8.openshift.api.model.OAuthClientFluent.ScopeRestrictionsNested<A> addNewScopeRestrictionLike(ScopeRestriction item);
    public io.fabric8.openshift.api.model.OAuthClientFluent.ScopeRestrictionsNested<A> setNewScopeRestrictionLike(int index,ScopeRestriction item);
    public io.fabric8.openshift.api.model.OAuthClientFluent.ScopeRestrictionsNested<A> editScopeRestriction(int index);
    public io.fabric8.openshift.api.model.OAuthClientFluent.ScopeRestrictionsNested<A> editFirstScopeRestriction();
    public io.fabric8.openshift.api.model.OAuthClientFluent.ScopeRestrictionsNested<A> editLastScopeRestriction();
    public io.fabric8.openshift.api.model.OAuthClientFluent.ScopeRestrictionsNested<A> editMatchingScopeRestriction(Predicate<ScopeRestrictionBuilder> predicate);
    public String getSecret();
    public A withSecret(String secret);
    public Boolean hasSecret();
    public A withNewSecret(StringBuilder arg1);
    public A withNewSecret(int[] arg1,int arg2,int arg3);
    public A withNewSecret(char[] arg1);
    public A withNewSecret(StringBuffer arg1);
    public A withNewSecret(byte[] arg1,int arg2);
    public A withNewSecret(byte[] arg1);
    public A withNewSecret(char[] arg1,int arg2,int arg3);
    public A withNewSecret(byte[] arg1,int arg2,int arg3);
    public A withNewSecret(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewSecret(String arg1);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<io.fabric8.openshift.api.model.OAuthClientFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


    public interface ScopeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ScopeRestrictionFluent<io.fabric8.openshift.api.model.OAuthClientFluent.ScopeRestrictionsNested<N>> {

            public N and();
            public N endScopeRestriction();    }


}
