package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface OperatorHubListFluent<A extends OperatorHubListFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public A addToItems(int index,OperatorHub item);
    public A setToItems(int index,OperatorHub item);
    public A addToItems(OperatorHub... items);
    public A addAllToItems(Collection<OperatorHub> items);
    public A removeFromItems(OperatorHub... items);
    public A removeAllFromItems(Collection<OperatorHub> items);
    public A removeMatchingFromItems(Predicate<OperatorHubBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<OperatorHub> getItems();
    public List<OperatorHub> buildItems();
    public OperatorHub buildItem(int index);
    public OperatorHub buildFirstItem();
    public OperatorHub buildLastItem();
    public OperatorHub buildMatchingItem(Predicate<OperatorHubBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<OperatorHubBuilder> predicate);
    public A withItems(List<OperatorHub> items);
    public A withItems(OperatorHub... items);
    public Boolean hasItems();
    public io.fabric8.openshift.api.model.OperatorHubListFluent.ItemsNested<A> addNewItem();
    public io.fabric8.openshift.api.model.OperatorHubListFluent.ItemsNested<A> addNewItemLike(OperatorHub item);
    public io.fabric8.openshift.api.model.OperatorHubListFluent.ItemsNested<A> setNewItemLike(int index,OperatorHub item);
    public io.fabric8.openshift.api.model.OperatorHubListFluent.ItemsNested<A> editItem(int index);
    public io.fabric8.openshift.api.model.OperatorHubListFluent.ItemsNested<A> editFirstItem();
    public io.fabric8.openshift.api.model.OperatorHubListFluent.ItemsNested<A> editLastItem();
    public io.fabric8.openshift.api.model.OperatorHubListFluent.ItemsNested<A> editMatchingItem(Predicate<OperatorHubBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OperatorHubFluent<io.fabric8.openshift.api.model.OperatorHubListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
