package io.fabric8.openshift.api.model;

import java.lang.String;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Deprecated;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;

public class ResourceAccessReviewFluentImpl<A extends ResourceAccessReviewFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ResourceAccessReviewFluent<A> {

    private String apiVersion;
    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?> content;
    private Boolean isNonResourceURL;
    private String kind;
    private String namespace;
    private String path;
    private String resource;
    private String resourceAPIGroup;
    private String resourceAPIVersion;
    private String resourceName;
    private String verb;

    public ResourceAccessReviewFluentImpl() {
    }

    public ResourceAccessReviewFluentImpl(ResourceAccessReview instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withContent(instance.getContent()); 
        this.withIsNonResourceURL(instance.getIsNonResourceURL()); 
        this.withKind(instance.getKind()); 
        this.withNamespace(instance.getNamespace()); 
        this.withPath(instance.getPath()); 
        this.withResource(instance.getResource()); 
        this.withResourceAPIGroup(instance.getResourceAPIGroup()); 
        this.withResourceAPIVersion(instance.getResourceAPIVersion()); 
        this.withResourceName(instance.getResourceName()); 
        this.withVerb(instance.getVerb()); 
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(int[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(char[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(byte[] arg1,int arg2) {
        return (A)withApiVersion(new String(arg1, arg2));
    }

    public A withNewApiVersion(byte[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(char[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withApiVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildContent instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getContent() {
        return this.content!=null?this.content.build():null;
    }

    public HasMetadata buildContent() {
        return this.content!=null?this.content.build():null;
    }

    public A withContent(HasMetadata content) {
        if (content instanceof ClusterVersion){ this.content= new ClusterVersionBuilder((ClusterVersion)content); _visitables.get("content").add(this.content);}
        if (content instanceof ImageStreamImport){ this.content= new ImageStreamImportBuilder((ImageStreamImport)content); _visitables.get("content").add(this.content);}
        if (content instanceof Proxy){ this.content= new ProxyBuilder((Proxy)content); _visitables.get("content").add(this.content);}
        if (content instanceof Project){ this.content= new ProjectBuilder((Project)content); _visitables.get("content").add(this.content);}
        if (content instanceof ClusterOperator){ this.content= new ClusterOperatorBuilder((ClusterOperator)content); _visitables.get("content").add(this.content);}
        if (content instanceof BuildConfig){ this.content= new BuildConfigBuilder((BuildConfig)content); _visitables.get("content").add(this.content);}
        if (content instanceof Infrastructure){ this.content= new InfrastructureBuilder((Infrastructure)content); _visitables.get("content").add(this.content);}
        if (content instanceof Scheduler){ this.content= new SchedulerBuilder((Scheduler)content); _visitables.get("content").add(this.content);}
        if (content instanceof RangeAllocation){ this.content= new RangeAllocationBuilder((RangeAllocation)content); _visitables.get("content").add(this.content);}
        if (content instanceof Route){ this.content= new RouteBuilder((Route)content); _visitables.get("content").add(this.content);}
        if (content instanceof ClusterNetwork){ this.content= new ClusterNetworkBuilder((ClusterNetwork)content); _visitables.get("content").add(this.content);}
        if (content instanceof OAuthAuthorizeToken){ this.content= new OAuthAuthorizeTokenBuilder((OAuthAuthorizeToken)content); _visitables.get("content").add(this.content);}
        if (content instanceof Ingress){ this.content= new IngressBuilder((Ingress)content); _visitables.get("content").add(this.content);}
        if (content instanceof OAuth){ this.content= new OAuthBuilder((OAuth)content); _visitables.get("content").add(this.content);}
        if (content instanceof OperatorHub){ this.content= new OperatorHubBuilder((OperatorHub)content); _visitables.get("content").add(this.content);}
        if (content instanceof ClusterRoleBinding){ this.content= new ClusterRoleBindingBuilder((ClusterRoleBinding)content); _visitables.get("content").add(this.content);}
        if (content instanceof ClusterResourceQuota){ this.content= new ClusterResourceQuotaBuilder((ClusterResourceQuota)content); _visitables.get("content").add(this.content);}
        if (content instanceof ProjectRequest){ this.content= new ProjectRequestBuilder((ProjectRequest)content); _visitables.get("content").add(this.content);}
        if (content instanceof Template){ this.content= new TemplateBuilder((Template)content); _visitables.get("content").add(this.content);}
        if (content instanceof OAuthClientAuthorization){ this.content= new OAuthClientAuthorizationBuilder((OAuthClientAuthorization)content); _visitables.get("content").add(this.content);}
        if (content instanceof ClusterRole){ this.content= new ClusterRoleBuilder((ClusterRole)content); _visitables.get("content").add(this.content);}
        if (content instanceof ImageTag){ this.content= new ImageTagBuilder((ImageTag)content); _visitables.get("content").add(this.content);}
        if (content instanceof DeploymentConfig){ this.content= new DeploymentConfigBuilder((DeploymentConfig)content); _visitables.get("content").add(this.content);}
        if (content instanceof OAuthAccessToken){ this.content= new OAuthAccessTokenBuilder((OAuthAccessToken)content); _visitables.get("content").add(this.content);}
        if (content instanceof RoleBinding){ this.content= new RoleBindingBuilder((RoleBinding)content); _visitables.get("content").add(this.content);}
        if (content instanceof Image){ this.content= new ImageBuilder((Image)content); _visitables.get("content").add(this.content);}
        if (content instanceof APIServer){ this.content= new APIServerBuilder((APIServer)content); _visitables.get("content").add(this.content);}
        if (content instanceof PersistentVolumeClaim){ this.content= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)content); _visitables.get("content").add(this.content);}
        if (content instanceof ImageStreamMapping){ this.content= new ImageStreamMappingBuilder((ImageStreamMapping)content); _visitables.get("content").add(this.content);}
        if (content instanceof Role){ this.content= new RoleBuilder((Role)content); _visitables.get("content").add(this.content);}
        if (content instanceof FeatureGate){ this.content= new FeatureGateBuilder((FeatureGate)content); _visitables.get("content").add(this.content);}
        if (content instanceof User){ this.content= new UserBuilder((User)content); _visitables.get("content").add(this.content);}
        if (content instanceof ImageStreamImage){ this.content= new ImageStreamImageBuilder((ImageStreamImage)content); _visitables.get("content").add(this.content);}
        if (content instanceof Build){ this.content= new BuildBuilder((Build)content); _visitables.get("content").add(this.content);}
        if (content instanceof RoleBindingRestriction){ this.content= new RoleBindingRestrictionBuilder((RoleBindingRestriction)content); _visitables.get("content").add(this.content);}
        if (content instanceof ImageStreamTag){ this.content= new ImageStreamTagBuilder((ImageStreamTag)content); _visitables.get("content").add(this.content);}
        if (content instanceof io.fabric8.openshift.api.model.Group){ this.content= new GroupBuilder((io.fabric8.openshift.api.model.Group)content); _visitables.get("content").add(this.content);}
        if (content instanceof ImageSignature){ this.content= new ImageSignatureBuilder((ImageSignature)content); _visitables.get("content").add(this.content);}
        if (content instanceof AppliedClusterResourceQuota){ this.content= new AppliedClusterResourceQuotaBuilder((AppliedClusterResourceQuota)content); _visitables.get("content").add(this.content);}
        if (content instanceof SecurityContextConstraints){ this.content= new SecurityContextConstraintsBuilder((SecurityContextConstraints)content); _visitables.get("content").add(this.content);}
        if (content instanceof BuildRequest){ this.content= new BuildRequestBuilder((BuildRequest)content); _visitables.get("content").add(this.content);}
        if (content instanceof EgressNetworkPolicy){ this.content= new EgressNetworkPolicyBuilder((EgressNetworkPolicy)content); _visitables.get("content").add(this.content);}
        if (content instanceof NetNamespace){ this.content= new NetNamespaceBuilder((NetNamespace)content); _visitables.get("content").add(this.content);}
        if (content instanceof ImageStream){ this.content= new ImageStreamBuilder((ImageStream)content); _visitables.get("content").add(this.content);}
        if (content instanceof OAuthClient){ this.content= new OAuthClientBuilder((OAuthClient)content); _visitables.get("content").add(this.content);}
        if (content instanceof Identity){ this.content= new IdentityBuilder((Identity)content); _visitables.get("content").add(this.content);}
        return (A) this;
    }

    public Boolean hasContent() {
        return this.content != null;
    }

    public A withClusterVersionContent(ClusterVersion clusterVersionContent) {
        _visitables.get("content").remove(this.content);
        if (clusterVersionContent!=null){ this.content= new ClusterVersionBuilder(clusterVersionContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ClusterVersionContentNested<A> withNewClusterVersionContent() {
        return new ClusterVersionContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ClusterVersionContentNested<A> withNewClusterVersionContentLike(ClusterVersion item) {
        return new ClusterVersionContentNestedImpl(item);
    }

    public A withImageStreamImportContent(ImageStreamImport imageStreamImportContent) {
        _visitables.get("content").remove(this.content);
        if (imageStreamImportContent!=null){ this.content= new ImageStreamImportBuilder(imageStreamImportContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageStreamImportContentNested<A> withNewImageStreamImportContent() {
        return new ImageStreamImportContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageStreamImportContentNested<A> withNewImageStreamImportContentLike(ImageStreamImport item) {
        return new ImageStreamImportContentNestedImpl(item);
    }

    public A withProxyContent(Proxy proxyContent) {
        _visitables.get("content").remove(this.content);
        if (proxyContent!=null){ this.content= new ProxyBuilder(proxyContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ProxyContentNested<A> withNewProxyContent() {
        return new ProxyContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ProxyContentNested<A> withNewProxyContentLike(Proxy item) {
        return new ProxyContentNestedImpl(item);
    }

    public A withProjectContent(Project projectContent) {
        _visitables.get("content").remove(this.content);
        if (projectContent!=null){ this.content= new ProjectBuilder(projectContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ProjectContentNested<A> withNewProjectContent() {
        return new ProjectContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ProjectContentNested<A> withNewProjectContentLike(Project item) {
        return new ProjectContentNestedImpl(item);
    }

    public A withClusterOperatorContent(ClusterOperator clusterOperatorContent) {
        _visitables.get("content").remove(this.content);
        if (clusterOperatorContent!=null){ this.content= new ClusterOperatorBuilder(clusterOperatorContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ClusterOperatorContentNested<A> withNewClusterOperatorContent() {
        return new ClusterOperatorContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ClusterOperatorContentNested<A> withNewClusterOperatorContentLike(ClusterOperator item) {
        return new ClusterOperatorContentNestedImpl(item);
    }

    public A withBuildConfigContent(BuildConfig buildConfigContent) {
        _visitables.get("content").remove(this.content);
        if (buildConfigContent!=null){ this.content= new BuildConfigBuilder(buildConfigContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.BuildConfigContentNested<A> withNewBuildConfigContent() {
        return new BuildConfigContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.BuildConfigContentNested<A> withNewBuildConfigContentLike(BuildConfig item) {
        return new BuildConfigContentNestedImpl(item);
    }

    public A withInfrastructureContent(Infrastructure infrastructureContent) {
        _visitables.get("content").remove(this.content);
        if (infrastructureContent!=null){ this.content= new InfrastructureBuilder(infrastructureContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.InfrastructureContentNested<A> withNewInfrastructureContent() {
        return new InfrastructureContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.InfrastructureContentNested<A> withNewInfrastructureContentLike(Infrastructure item) {
        return new InfrastructureContentNestedImpl(item);
    }

    public A withSchedulerContent(Scheduler schedulerContent) {
        _visitables.get("content").remove(this.content);
        if (schedulerContent!=null){ this.content= new SchedulerBuilder(schedulerContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.SchedulerContentNested<A> withNewSchedulerContent() {
        return new SchedulerContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.SchedulerContentNested<A> withNewSchedulerContentLike(Scheduler item) {
        return new SchedulerContentNestedImpl(item);
    }

    public A withRangeAllocationContent(RangeAllocation rangeAllocationContent) {
        _visitables.get("content").remove(this.content);
        if (rangeAllocationContent!=null){ this.content= new RangeAllocationBuilder(rangeAllocationContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.RangeAllocationContentNested<A> withNewRangeAllocationContent() {
        return new RangeAllocationContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.RangeAllocationContentNested<A> withNewRangeAllocationContentLike(RangeAllocation item) {
        return new RangeAllocationContentNestedImpl(item);
    }

    public A withRouteContent(Route routeContent) {
        _visitables.get("content").remove(this.content);
        if (routeContent!=null){ this.content= new RouteBuilder(routeContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.RouteContentNested<A> withNewRouteContent() {
        return new RouteContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.RouteContentNested<A> withNewRouteContentLike(Route item) {
        return new RouteContentNestedImpl(item);
    }

    public A withClusterNetworkContent(ClusterNetwork clusterNetworkContent) {
        _visitables.get("content").remove(this.content);
        if (clusterNetworkContent!=null){ this.content= new ClusterNetworkBuilder(clusterNetworkContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ClusterNetworkContentNested<A> withNewClusterNetworkContent() {
        return new ClusterNetworkContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ClusterNetworkContentNested<A> withNewClusterNetworkContentLike(ClusterNetwork item) {
        return new ClusterNetworkContentNestedImpl(item);
    }

    public A withOAuthAuthorizeTokenContent(OAuthAuthorizeToken oAuthAuthorizeTokenContent) {
        _visitables.get("content").remove(this.content);
        if (oAuthAuthorizeTokenContent!=null){ this.content= new OAuthAuthorizeTokenBuilder(oAuthAuthorizeTokenContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.OAuthAuthorizeTokenContentNested<A> withNewOAuthAuthorizeTokenContent() {
        return new OAuthAuthorizeTokenContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.OAuthAuthorizeTokenContentNested<A> withNewOAuthAuthorizeTokenContentLike(OAuthAuthorizeToken item) {
        return new OAuthAuthorizeTokenContentNestedImpl(item);
    }

    public A withIngressContent(Ingress ingressContent) {
        _visitables.get("content").remove(this.content);
        if (ingressContent!=null){ this.content= new IngressBuilder(ingressContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.IngressContentNested<A> withNewIngressContent() {
        return new IngressContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.IngressContentNested<A> withNewIngressContentLike(Ingress item) {
        return new IngressContentNestedImpl(item);
    }

    public A withOAuthContent(OAuth oAuthContent) {
        _visitables.get("content").remove(this.content);
        if (oAuthContent!=null){ this.content= new OAuthBuilder(oAuthContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.OAuthContentNested<A> withNewOAuthContent() {
        return new OAuthContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.OAuthContentNested<A> withNewOAuthContentLike(OAuth item) {
        return new OAuthContentNestedImpl(item);
    }

    public A withOperatorHubContent(OperatorHub operatorHubContent) {
        _visitables.get("content").remove(this.content);
        if (operatorHubContent!=null){ this.content= new OperatorHubBuilder(operatorHubContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.OperatorHubContentNested<A> withNewOperatorHubContent() {
        return new OperatorHubContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.OperatorHubContentNested<A> withNewOperatorHubContentLike(OperatorHub item) {
        return new OperatorHubContentNestedImpl(item);
    }

    public A withClusterRoleBindingContent(ClusterRoleBinding clusterRoleBindingContent) {
        _visitables.get("content").remove(this.content);
        if (clusterRoleBindingContent!=null){ this.content= new ClusterRoleBindingBuilder(clusterRoleBindingContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ClusterRoleBindingContentNested<A> withNewClusterRoleBindingContent() {
        return new ClusterRoleBindingContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ClusterRoleBindingContentNested<A> withNewClusterRoleBindingContentLike(ClusterRoleBinding item) {
        return new ClusterRoleBindingContentNestedImpl(item);
    }

    public A withClusterResourceQuotaContent(ClusterResourceQuota clusterResourceQuotaContent) {
        _visitables.get("content").remove(this.content);
        if (clusterResourceQuotaContent!=null){ this.content= new ClusterResourceQuotaBuilder(clusterResourceQuotaContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ClusterResourceQuotaContentNested<A> withNewClusterResourceQuotaContent() {
        return new ClusterResourceQuotaContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ClusterResourceQuotaContentNested<A> withNewClusterResourceQuotaContentLike(ClusterResourceQuota item) {
        return new ClusterResourceQuotaContentNestedImpl(item);
    }

    public A withProjectRequestContent(ProjectRequest projectRequestContent) {
        _visitables.get("content").remove(this.content);
        if (projectRequestContent!=null){ this.content= new ProjectRequestBuilder(projectRequestContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ProjectRequestContentNested<A> withNewProjectRequestContent() {
        return new ProjectRequestContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ProjectRequestContentNested<A> withNewProjectRequestContentLike(ProjectRequest item) {
        return new ProjectRequestContentNestedImpl(item);
    }

    public A withTemplateContent(Template templateContent) {
        _visitables.get("content").remove(this.content);
        if (templateContent!=null){ this.content= new TemplateBuilder(templateContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.TemplateContentNested<A> withNewTemplateContent() {
        return new TemplateContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.TemplateContentNested<A> withNewTemplateContentLike(Template item) {
        return new TemplateContentNestedImpl(item);
    }

    public A withOAuthClientAuthorizationContent(OAuthClientAuthorization oAuthClientAuthorizationContent) {
        _visitables.get("content").remove(this.content);
        if (oAuthClientAuthorizationContent!=null){ this.content= new OAuthClientAuthorizationBuilder(oAuthClientAuthorizationContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.OAuthClientAuthorizationContentNested<A> withNewOAuthClientAuthorizationContent() {
        return new OAuthClientAuthorizationContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.OAuthClientAuthorizationContentNested<A> withNewOAuthClientAuthorizationContentLike(OAuthClientAuthorization item) {
        return new OAuthClientAuthorizationContentNestedImpl(item);
    }

    public A withClusterRoleContent(ClusterRole clusterRoleContent) {
        _visitables.get("content").remove(this.content);
        if (clusterRoleContent!=null){ this.content= new ClusterRoleBuilder(clusterRoleContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ClusterRoleContentNested<A> withNewClusterRoleContent() {
        return new ClusterRoleContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ClusterRoleContentNested<A> withNewClusterRoleContentLike(ClusterRole item) {
        return new ClusterRoleContentNestedImpl(item);
    }

    public A withImageTagContent(ImageTag imageTagContent) {
        _visitables.get("content").remove(this.content);
        if (imageTagContent!=null){ this.content= new ImageTagBuilder(imageTagContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageTagContentNested<A> withNewImageTagContent() {
        return new ImageTagContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageTagContentNested<A> withNewImageTagContentLike(ImageTag item) {
        return new ImageTagContentNestedImpl(item);
    }

    public A withDeploymentConfigContent(DeploymentConfig deploymentConfigContent) {
        _visitables.get("content").remove(this.content);
        if (deploymentConfigContent!=null){ this.content= new DeploymentConfigBuilder(deploymentConfigContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.DeploymentConfigContentNested<A> withNewDeploymentConfigContent() {
        return new DeploymentConfigContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.DeploymentConfigContentNested<A> withNewDeploymentConfigContentLike(DeploymentConfig item) {
        return new DeploymentConfigContentNestedImpl(item);
    }

    public A withOAuthAccessTokenContent(OAuthAccessToken oAuthAccessTokenContent) {
        _visitables.get("content").remove(this.content);
        if (oAuthAccessTokenContent!=null){ this.content= new OAuthAccessTokenBuilder(oAuthAccessTokenContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.OAuthAccessTokenContentNested<A> withNewOAuthAccessTokenContent() {
        return new OAuthAccessTokenContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.OAuthAccessTokenContentNested<A> withNewOAuthAccessTokenContentLike(OAuthAccessToken item) {
        return new OAuthAccessTokenContentNestedImpl(item);
    }

    public A withRoleBindingContent(RoleBinding roleBindingContent) {
        _visitables.get("content").remove(this.content);
        if (roleBindingContent!=null){ this.content= new RoleBindingBuilder(roleBindingContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.RoleBindingContentNested<A> withNewRoleBindingContent() {
        return new RoleBindingContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.RoleBindingContentNested<A> withNewRoleBindingContentLike(RoleBinding item) {
        return new RoleBindingContentNestedImpl(item);
    }

    public A withImageContent(Image imageContent) {
        _visitables.get("content").remove(this.content);
        if (imageContent!=null){ this.content= new ImageBuilder(imageContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageContentNested<A> withNewImageContent() {
        return new ImageContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageContentNested<A> withNewImageContentLike(Image item) {
        return new ImageContentNestedImpl(item);
    }

    public A withAPIServerContent(APIServer aPIServerContent) {
        _visitables.get("content").remove(this.content);
        if (aPIServerContent!=null){ this.content= new APIServerBuilder(aPIServerContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.APIServerContentNested<A> withNewAPIServerContent() {
        return new APIServerContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.APIServerContentNested<A> withNewAPIServerContentLike(APIServer item) {
        return new APIServerContentNestedImpl(item);
    }

    public A withPersistentVolumeClaimContent(PersistentVolumeClaim persistentVolumeClaimContent) {
        _visitables.get("content").remove(this.content);
        if (persistentVolumeClaimContent!=null){ this.content= new PersistentVolumeClaimBuilder(persistentVolumeClaimContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.PersistentVolumeClaimContentNested<A> withNewPersistentVolumeClaimContent() {
        return new PersistentVolumeClaimContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.PersistentVolumeClaimContentNested<A> withNewPersistentVolumeClaimContentLike(PersistentVolumeClaim item) {
        return new PersistentVolumeClaimContentNestedImpl(item);
    }

    public A withImageStreamMappingContent(ImageStreamMapping imageStreamMappingContent) {
        _visitables.get("content").remove(this.content);
        if (imageStreamMappingContent!=null){ this.content= new ImageStreamMappingBuilder(imageStreamMappingContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageStreamMappingContentNested<A> withNewImageStreamMappingContent() {
        return new ImageStreamMappingContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageStreamMappingContentNested<A> withNewImageStreamMappingContentLike(ImageStreamMapping item) {
        return new ImageStreamMappingContentNestedImpl(item);
    }

    public A withRoleContent(Role roleContent) {
        _visitables.get("content").remove(this.content);
        if (roleContent!=null){ this.content= new RoleBuilder(roleContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.RoleContentNested<A> withNewRoleContent() {
        return new RoleContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.RoleContentNested<A> withNewRoleContentLike(Role item) {
        return new RoleContentNestedImpl(item);
    }

    public A withFeatureGateContent(FeatureGate featureGateContent) {
        _visitables.get("content").remove(this.content);
        if (featureGateContent!=null){ this.content= new FeatureGateBuilder(featureGateContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.FeatureGateContentNested<A> withNewFeatureGateContent() {
        return new FeatureGateContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.FeatureGateContentNested<A> withNewFeatureGateContentLike(FeatureGate item) {
        return new FeatureGateContentNestedImpl(item);
    }

    public A withUserContent(User userContent) {
        _visitables.get("content").remove(this.content);
        if (userContent!=null){ this.content= new UserBuilder(userContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.UserContentNested<A> withNewUserContent() {
        return new UserContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.UserContentNested<A> withNewUserContentLike(User item) {
        return new UserContentNestedImpl(item);
    }

    public A withImageStreamImageContent(ImageStreamImage imageStreamImageContent) {
        _visitables.get("content").remove(this.content);
        if (imageStreamImageContent!=null){ this.content= new ImageStreamImageBuilder(imageStreamImageContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageStreamImageContentNested<A> withNewImageStreamImageContent() {
        return new ImageStreamImageContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageStreamImageContentNested<A> withNewImageStreamImageContentLike(ImageStreamImage item) {
        return new ImageStreamImageContentNestedImpl(item);
    }

    public A withBuildContent(Build buildContent) {
        _visitables.get("content").remove(this.content);
        if (buildContent!=null){ this.content= new BuildBuilder(buildContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.BuildContentNested<A> withNewBuildContent() {
        return new BuildContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.BuildContentNested<A> withNewBuildContentLike(Build item) {
        return new BuildContentNestedImpl(item);
    }

    public A withRoleBindingRestrictionContent(RoleBindingRestriction roleBindingRestrictionContent) {
        _visitables.get("content").remove(this.content);
        if (roleBindingRestrictionContent!=null){ this.content= new RoleBindingRestrictionBuilder(roleBindingRestrictionContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.RoleBindingRestrictionContentNested<A> withNewRoleBindingRestrictionContent() {
        return new RoleBindingRestrictionContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.RoleBindingRestrictionContentNested<A> withNewRoleBindingRestrictionContentLike(RoleBindingRestriction item) {
        return new RoleBindingRestrictionContentNestedImpl(item);
    }

    public A withImageStreamTagContent(ImageStreamTag imageStreamTagContent) {
        _visitables.get("content").remove(this.content);
        if (imageStreamTagContent!=null){ this.content= new ImageStreamTagBuilder(imageStreamTagContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageStreamTagContentNested<A> withNewImageStreamTagContent() {
        return new ImageStreamTagContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageStreamTagContentNested<A> withNewImageStreamTagContentLike(ImageStreamTag item) {
        return new ImageStreamTagContentNestedImpl(item);
    }

    public A withGroupContent(io.fabric8.openshift.api.model.Group groupContent) {
        _visitables.get("content").remove(this.content);
        if (groupContent!=null){ this.content= new GroupBuilder(groupContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.GroupContentNested<A> withNewGroupContent() {
        return new GroupContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.GroupContentNested<A> withNewGroupContentLike(io.fabric8.openshift.api.model.Group item) {
        return new GroupContentNestedImpl(item);
    }

    public A withImageSignatureContent(ImageSignature imageSignatureContent) {
        _visitables.get("content").remove(this.content);
        if (imageSignatureContent!=null){ this.content= new ImageSignatureBuilder(imageSignatureContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageSignatureContentNested<A> withNewImageSignatureContent() {
        return new ImageSignatureContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageSignatureContentNested<A> withNewImageSignatureContentLike(ImageSignature item) {
        return new ImageSignatureContentNestedImpl(item);
    }

    public A withAppliedClusterResourceQuotaContent(AppliedClusterResourceQuota appliedClusterResourceQuotaContent) {
        _visitables.get("content").remove(this.content);
        if (appliedClusterResourceQuotaContent!=null){ this.content= new AppliedClusterResourceQuotaBuilder(appliedClusterResourceQuotaContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.AppliedClusterResourceQuotaContentNested<A> withNewAppliedClusterResourceQuotaContent() {
        return new AppliedClusterResourceQuotaContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.AppliedClusterResourceQuotaContentNested<A> withNewAppliedClusterResourceQuotaContentLike(AppliedClusterResourceQuota item) {
        return new AppliedClusterResourceQuotaContentNestedImpl(item);
    }

    public A withSecurityContextConstraintsContent(SecurityContextConstraints securityContextConstraintsContent) {
        _visitables.get("content").remove(this.content);
        if (securityContextConstraintsContent!=null){ this.content= new SecurityContextConstraintsBuilder(securityContextConstraintsContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.SecurityContextConstraintsContentNested<A> withNewSecurityContextConstraintsContent() {
        return new SecurityContextConstraintsContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.SecurityContextConstraintsContentNested<A> withNewSecurityContextConstraintsContentLike(SecurityContextConstraints item) {
        return new SecurityContextConstraintsContentNestedImpl(item);
    }

    public A withBuildRequestContent(BuildRequest buildRequestContent) {
        _visitables.get("content").remove(this.content);
        if (buildRequestContent!=null){ this.content= new BuildRequestBuilder(buildRequestContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.BuildRequestContentNested<A> withNewBuildRequestContent() {
        return new BuildRequestContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.BuildRequestContentNested<A> withNewBuildRequestContentLike(BuildRequest item) {
        return new BuildRequestContentNestedImpl(item);
    }

    public A withEgressNetworkPolicyContent(EgressNetworkPolicy egressNetworkPolicyContent) {
        _visitables.get("content").remove(this.content);
        if (egressNetworkPolicyContent!=null){ this.content= new EgressNetworkPolicyBuilder(egressNetworkPolicyContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.EgressNetworkPolicyContentNested<A> withNewEgressNetworkPolicyContent() {
        return new EgressNetworkPolicyContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.EgressNetworkPolicyContentNested<A> withNewEgressNetworkPolicyContentLike(EgressNetworkPolicy item) {
        return new EgressNetworkPolicyContentNestedImpl(item);
    }

    public A withNetNamespaceContent(NetNamespace netNamespaceContent) {
        _visitables.get("content").remove(this.content);
        if (netNamespaceContent!=null){ this.content= new NetNamespaceBuilder(netNamespaceContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.NetNamespaceContentNested<A> withNewNetNamespaceContent() {
        return new NetNamespaceContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.NetNamespaceContentNested<A> withNewNetNamespaceContentLike(NetNamespace item) {
        return new NetNamespaceContentNestedImpl(item);
    }

    public A withImageStreamContent(ImageStream imageStreamContent) {
        _visitables.get("content").remove(this.content);
        if (imageStreamContent!=null){ this.content= new ImageStreamBuilder(imageStreamContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageStreamContentNested<A> withNewImageStreamContent() {
        return new ImageStreamContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageStreamContentNested<A> withNewImageStreamContentLike(ImageStream item) {
        return new ImageStreamContentNestedImpl(item);
    }

    public A withOAuthClientContent(OAuthClient oAuthClientContent) {
        _visitables.get("content").remove(this.content);
        if (oAuthClientContent!=null){ this.content= new OAuthClientBuilder(oAuthClientContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.OAuthClientContentNested<A> withNewOAuthClientContent() {
        return new OAuthClientContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.OAuthClientContentNested<A> withNewOAuthClientContentLike(OAuthClient item) {
        return new OAuthClientContentNestedImpl(item);
    }

    public A withIdentityContent(Identity identityContent) {
        _visitables.get("content").remove(this.content);
        if (identityContent!=null){ this.content= new IdentityBuilder(identityContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.IdentityContentNested<A> withNewIdentityContent() {
        return new IdentityContentNestedImpl();
    }

    public io.fabric8.openshift.api.model.ResourceAccessReviewFluent.IdentityContentNested<A> withNewIdentityContentLike(Identity item) {
        return new IdentityContentNestedImpl(item);
    }

    public Boolean getIsNonResourceURL() {
        return this.isNonResourceURL;
    }

    public A withIsNonResourceURL(Boolean isNonResourceURL) {
        this.isNonResourceURL=isNonResourceURL; return (A) this;
    }

    public Boolean hasIsNonResourceURL() {
        return this.isNonResourceURL != null;
    }

    public A withNewIsNonResourceURL(String arg1) {
        return (A)withIsNonResourceURL(new Boolean(arg1));
    }

    public A withNewIsNonResourceURL(boolean arg1) {
        return (A)withIsNonResourceURL(new Boolean(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(int[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(char[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(byte[] arg1,int arg2) {
        return (A)withKind(new String(arg1, arg2));
    }

    public A withNewKind(byte[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(char[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withKind(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace=namespace; return (A) this;
    }

    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    public A withNewNamespace(StringBuilder arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(int[] arg1,int arg2,int arg3) {
        return (A)withNamespace(new String(arg1, arg2, arg3));
    }

    public A withNewNamespace(char[] arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuffer arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(byte[] arg1,int arg2) {
        return (A)withNamespace(new String(arg1, arg2));
    }

    public A withNewNamespace(byte[] arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(char[] arg1,int arg2,int arg3) {
        return (A)withNamespace(new String(arg1, arg2, arg3));
    }

    public A withNewNamespace(byte[] arg1,int arg2,int arg3) {
        return (A)withNamespace(new String(arg1, arg2, arg3));
    }

    public A withNewNamespace(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withNamespace(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewNamespace(String arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path=path; return (A) this;
    }

    public Boolean hasPath() {
        return this.path != null;
    }

    public A withNewPath(StringBuilder arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(int[] arg1,int arg2,int arg3) {
        return (A)withPath(new String(arg1, arg2, arg3));
    }

    public A withNewPath(char[] arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuffer arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(byte[] arg1,int arg2) {
        return (A)withPath(new String(arg1, arg2));
    }

    public A withNewPath(byte[] arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(char[] arg1,int arg2,int arg3) {
        return (A)withPath(new String(arg1, arg2, arg3));
    }

    public A withNewPath(byte[] arg1,int arg2,int arg3) {
        return (A)withPath(new String(arg1, arg2, arg3));
    }

    public A withNewPath(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPath(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPath(String arg1) {
        return (A)withPath(new String(arg1));
    }

    public String getResource() {
        return this.resource;
    }

    public A withResource(String resource) {
        this.resource=resource; return (A) this;
    }

    public Boolean hasResource() {
        return this.resource != null;
    }

    public A withNewResource(StringBuilder arg1) {
        return (A)withResource(new String(arg1));
    }

    public A withNewResource(int[] arg1,int arg2,int arg3) {
        return (A)withResource(new String(arg1, arg2, arg3));
    }

    public A withNewResource(char[] arg1) {
        return (A)withResource(new String(arg1));
    }

    public A withNewResource(StringBuffer arg1) {
        return (A)withResource(new String(arg1));
    }

    public A withNewResource(byte[] arg1,int arg2) {
        return (A)withResource(new String(arg1, arg2));
    }

    public A withNewResource(byte[] arg1) {
        return (A)withResource(new String(arg1));
    }

    public A withNewResource(char[] arg1,int arg2,int arg3) {
        return (A)withResource(new String(arg1, arg2, arg3));
    }

    public A withNewResource(byte[] arg1,int arg2,int arg3) {
        return (A)withResource(new String(arg1, arg2, arg3));
    }

    public A withNewResource(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withResource(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewResource(String arg1) {
        return (A)withResource(new String(arg1));
    }

    public String getResourceAPIGroup() {
        return this.resourceAPIGroup;
    }

    public A withResourceAPIGroup(String resourceAPIGroup) {
        this.resourceAPIGroup=resourceAPIGroup; return (A) this;
    }

    public Boolean hasResourceAPIGroup() {
        return this.resourceAPIGroup != null;
    }

    public A withNewResourceAPIGroup(StringBuilder arg1) {
        return (A)withResourceAPIGroup(new String(arg1));
    }

    public A withNewResourceAPIGroup(int[] arg1,int arg2,int arg3) {
        return (A)withResourceAPIGroup(new String(arg1, arg2, arg3));
    }

    public A withNewResourceAPIGroup(char[] arg1) {
        return (A)withResourceAPIGroup(new String(arg1));
    }

    public A withNewResourceAPIGroup(StringBuffer arg1) {
        return (A)withResourceAPIGroup(new String(arg1));
    }

    public A withNewResourceAPIGroup(byte[] arg1,int arg2) {
        return (A)withResourceAPIGroup(new String(arg1, arg2));
    }

    public A withNewResourceAPIGroup(byte[] arg1) {
        return (A)withResourceAPIGroup(new String(arg1));
    }

    public A withNewResourceAPIGroup(char[] arg1,int arg2,int arg3) {
        return (A)withResourceAPIGroup(new String(arg1, arg2, arg3));
    }

    public A withNewResourceAPIGroup(byte[] arg1,int arg2,int arg3) {
        return (A)withResourceAPIGroup(new String(arg1, arg2, arg3));
    }

    public A withNewResourceAPIGroup(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withResourceAPIGroup(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewResourceAPIGroup(String arg1) {
        return (A)withResourceAPIGroup(new String(arg1));
    }

    public String getResourceAPIVersion() {
        return this.resourceAPIVersion;
    }

    public A withResourceAPIVersion(String resourceAPIVersion) {
        this.resourceAPIVersion=resourceAPIVersion; return (A) this;
    }

    public Boolean hasResourceAPIVersion() {
        return this.resourceAPIVersion != null;
    }

    public A withNewResourceAPIVersion(StringBuilder arg1) {
        return (A)withResourceAPIVersion(new String(arg1));
    }

    public A withNewResourceAPIVersion(int[] arg1,int arg2,int arg3) {
        return (A)withResourceAPIVersion(new String(arg1, arg2, arg3));
    }

    public A withNewResourceAPIVersion(char[] arg1) {
        return (A)withResourceAPIVersion(new String(arg1));
    }

    public A withNewResourceAPIVersion(StringBuffer arg1) {
        return (A)withResourceAPIVersion(new String(arg1));
    }

    public A withNewResourceAPIVersion(byte[] arg1,int arg2) {
        return (A)withResourceAPIVersion(new String(arg1, arg2));
    }

    public A withNewResourceAPIVersion(byte[] arg1) {
        return (A)withResourceAPIVersion(new String(arg1));
    }

    public A withNewResourceAPIVersion(char[] arg1,int arg2,int arg3) {
        return (A)withResourceAPIVersion(new String(arg1, arg2, arg3));
    }

    public A withNewResourceAPIVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withResourceAPIVersion(new String(arg1, arg2, arg3));
    }

    public A withNewResourceAPIVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withResourceAPIVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewResourceAPIVersion(String arg1) {
        return (A)withResourceAPIVersion(new String(arg1));
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public A withResourceName(String resourceName) {
        this.resourceName=resourceName; return (A) this;
    }

    public Boolean hasResourceName() {
        return this.resourceName != null;
    }

    public A withNewResourceName(StringBuilder arg1) {
        return (A)withResourceName(new String(arg1));
    }

    public A withNewResourceName(int[] arg1,int arg2,int arg3) {
        return (A)withResourceName(new String(arg1, arg2, arg3));
    }

    public A withNewResourceName(char[] arg1) {
        return (A)withResourceName(new String(arg1));
    }

    public A withNewResourceName(StringBuffer arg1) {
        return (A)withResourceName(new String(arg1));
    }

    public A withNewResourceName(byte[] arg1,int arg2) {
        return (A)withResourceName(new String(arg1, arg2));
    }

    public A withNewResourceName(byte[] arg1) {
        return (A)withResourceName(new String(arg1));
    }

    public A withNewResourceName(char[] arg1,int arg2,int arg3) {
        return (A)withResourceName(new String(arg1, arg2, arg3));
    }

    public A withNewResourceName(byte[] arg1,int arg2,int arg3) {
        return (A)withResourceName(new String(arg1, arg2, arg3));
    }

    public A withNewResourceName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withResourceName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewResourceName(String arg1) {
        return (A)withResourceName(new String(arg1));
    }

    public String getVerb() {
        return this.verb;
    }

    public A withVerb(String verb) {
        this.verb=verb; return (A) this;
    }

    public Boolean hasVerb() {
        return this.verb != null;
    }

    public A withNewVerb(StringBuilder arg1) {
        return (A)withVerb(new String(arg1));
    }

    public A withNewVerb(int[] arg1,int arg2,int arg3) {
        return (A)withVerb(new String(arg1, arg2, arg3));
    }

    public A withNewVerb(char[] arg1) {
        return (A)withVerb(new String(arg1));
    }

    public A withNewVerb(StringBuffer arg1) {
        return (A)withVerb(new String(arg1));
    }

    public A withNewVerb(byte[] arg1,int arg2) {
        return (A)withVerb(new String(arg1, arg2));
    }

    public A withNewVerb(byte[] arg1) {
        return (A)withVerb(new String(arg1));
    }

    public A withNewVerb(char[] arg1,int arg2,int arg3) {
        return (A)withVerb(new String(arg1, arg2, arg3));
    }

    public A withNewVerb(byte[] arg1,int arg2,int arg3) {
        return (A)withVerb(new String(arg1, arg2, arg3));
    }

    public A withNewVerb(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withVerb(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewVerb(String arg1) {
        return (A)withVerb(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ResourceAccessReviewFluentImpl that = (ResourceAccessReviewFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (content != null ? !content.equals(that.content) :that.content != null) return false;
        if (isNonResourceURL != null ? !isNonResourceURL.equals(that.isNonResourceURL) :that.isNonResourceURL != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
        if (path != null ? !path.equals(that.path) :that.path != null) return false;
        if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
        if (resourceAPIGroup != null ? !resourceAPIGroup.equals(that.resourceAPIGroup) :that.resourceAPIGroup != null) return false;
        if (resourceAPIVersion != null ? !resourceAPIVersion.equals(that.resourceAPIVersion) :that.resourceAPIVersion != null) return false;
        if (resourceName != null ? !resourceName.equals(that.resourceName) :that.resourceName != null) return false;
        if (verb != null ? !verb.equals(that.verb) :that.verb != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  content,  isNonResourceURL,  kind,  namespace,  path,  resource,  resourceAPIGroup,  resourceAPIVersion,  resourceName,  verb,  super.hashCode());
    }

    public class ClusterVersionContentNestedImpl<N> extends ClusterVersionFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ClusterVersionContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ClusterVersionContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ClusterVersionBuilder builder;

            ClusterVersionContentNestedImpl(ClusterVersion item) {
                this.builder = new ClusterVersionBuilder(this, item);
                        
            }

            ClusterVersionContentNestedImpl() {
                this.builder = new ClusterVersionBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endClusterVersionContent() {
                return and();
            }
    }


    public class ImageStreamImportContentNestedImpl<N> extends ImageStreamImportFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageStreamImportContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageStreamImportContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ImageStreamImportBuilder builder;

            ImageStreamImportContentNestedImpl(ImageStreamImport item) {
                this.builder = new ImageStreamImportBuilder(this, item);
                        
            }

            ImageStreamImportContentNestedImpl() {
                this.builder = new ImageStreamImportBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endImageStreamImportContent() {
                return and();
            }
    }


    public class ProxyContentNestedImpl<N> extends ProxyFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ProxyContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ProxyContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ProxyBuilder builder;

            ProxyContentNestedImpl(Proxy item) {
                this.builder = new ProxyBuilder(this, item);
                        
            }

            ProxyContentNestedImpl() {
                this.builder = new ProxyBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endProxyContent() {
                return and();
            }
    }


    public class ProjectContentNestedImpl<N> extends ProjectFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ProjectContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ProjectContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ProjectBuilder builder;

            ProjectContentNestedImpl(Project item) {
                this.builder = new ProjectBuilder(this, item);
                        
            }

            ProjectContentNestedImpl() {
                this.builder = new ProjectBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endProjectContent() {
                return and();
            }
    }


    public class ClusterOperatorContentNestedImpl<N> extends ClusterOperatorFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ClusterOperatorContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ClusterOperatorContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ClusterOperatorBuilder builder;

            ClusterOperatorContentNestedImpl(ClusterOperator item) {
                this.builder = new ClusterOperatorBuilder(this, item);
                        
            }

            ClusterOperatorContentNestedImpl() {
                this.builder = new ClusterOperatorBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endClusterOperatorContent() {
                return and();
            }
    }


    public class BuildConfigContentNestedImpl<N> extends BuildConfigFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.BuildConfigContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.BuildConfigContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BuildConfigBuilder builder;

            BuildConfigContentNestedImpl(BuildConfig item) {
                this.builder = new BuildConfigBuilder(this, item);
                        
            }

            BuildConfigContentNestedImpl() {
                this.builder = new BuildConfigBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endBuildConfigContent() {
                return and();
            }
    }


    public class InfrastructureContentNestedImpl<N> extends InfrastructureFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.InfrastructureContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.InfrastructureContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final InfrastructureBuilder builder;

            InfrastructureContentNestedImpl(Infrastructure item) {
                this.builder = new InfrastructureBuilder(this, item);
                        
            }

            InfrastructureContentNestedImpl() {
                this.builder = new InfrastructureBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endInfrastructureContent() {
                return and();
            }
    }


    public class SchedulerContentNestedImpl<N> extends SchedulerFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.SchedulerContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.SchedulerContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SchedulerBuilder builder;

            SchedulerContentNestedImpl(Scheduler item) {
                this.builder = new SchedulerBuilder(this, item);
                        
            }

            SchedulerContentNestedImpl() {
                this.builder = new SchedulerBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endSchedulerContent() {
                return and();
            }
    }


    public class RangeAllocationContentNestedImpl<N> extends RangeAllocationFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.RangeAllocationContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.RangeAllocationContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RangeAllocationBuilder builder;

            RangeAllocationContentNestedImpl(RangeAllocation item) {
                this.builder = new RangeAllocationBuilder(this, item);
                        
            }

            RangeAllocationContentNestedImpl() {
                this.builder = new RangeAllocationBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endRangeAllocationContent() {
                return and();
            }
    }


    public class RouteContentNestedImpl<N> extends RouteFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.RouteContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.RouteContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RouteBuilder builder;

            RouteContentNestedImpl(Route item) {
                this.builder = new RouteBuilder(this, item);
                        
            }

            RouteContentNestedImpl() {
                this.builder = new RouteBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endRouteContent() {
                return and();
            }
    }


    public class ClusterNetworkContentNestedImpl<N> extends ClusterNetworkFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ClusterNetworkContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ClusterNetworkContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ClusterNetworkBuilder builder;

            ClusterNetworkContentNestedImpl(ClusterNetwork item) {
                this.builder = new ClusterNetworkBuilder(this, item);
                        
            }

            ClusterNetworkContentNestedImpl() {
                this.builder = new ClusterNetworkBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endClusterNetworkContent() {
                return and();
            }
    }


    public class OAuthAuthorizeTokenContentNestedImpl<N> extends OAuthAuthorizeTokenFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.OAuthAuthorizeTokenContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.OAuthAuthorizeTokenContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OAuthAuthorizeTokenBuilder builder;

            OAuthAuthorizeTokenContentNestedImpl(OAuthAuthorizeToken item) {
                this.builder = new OAuthAuthorizeTokenBuilder(this, item);
                        
            }

            OAuthAuthorizeTokenContentNestedImpl() {
                this.builder = new OAuthAuthorizeTokenBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endOAuthAuthorizeTokenContent() {
                return and();
            }
    }


    public class IngressContentNestedImpl<N> extends IngressFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.IngressContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.IngressContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IngressBuilder builder;

            IngressContentNestedImpl(Ingress item) {
                this.builder = new IngressBuilder(this, item);
                        
            }

            IngressContentNestedImpl() {
                this.builder = new IngressBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endIngressContent() {
                return and();
            }
    }


    public class OAuthContentNestedImpl<N> extends OAuthFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.OAuthContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.OAuthContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OAuthBuilder builder;

            OAuthContentNestedImpl(OAuth item) {
                this.builder = new OAuthBuilder(this, item);
                        
            }

            OAuthContentNestedImpl() {
                this.builder = new OAuthBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endOAuthContent() {
                return and();
            }
    }


    public class OperatorHubContentNestedImpl<N> extends OperatorHubFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.OperatorHubContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.OperatorHubContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OperatorHubBuilder builder;

            OperatorHubContentNestedImpl(OperatorHub item) {
                this.builder = new OperatorHubBuilder(this, item);
                        
            }

            OperatorHubContentNestedImpl() {
                this.builder = new OperatorHubBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endOperatorHubContent() {
                return and();
            }
    }


    public class ClusterRoleBindingContentNestedImpl<N> extends ClusterRoleBindingFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ClusterRoleBindingContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ClusterRoleBindingContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ClusterRoleBindingBuilder builder;

            ClusterRoleBindingContentNestedImpl(ClusterRoleBinding item) {
                this.builder = new ClusterRoleBindingBuilder(this, item);
                        
            }

            ClusterRoleBindingContentNestedImpl() {
                this.builder = new ClusterRoleBindingBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endClusterRoleBindingContent() {
                return and();
            }
    }


    public class ClusterResourceQuotaContentNestedImpl<N> extends ClusterResourceQuotaFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ClusterResourceQuotaContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ClusterResourceQuotaContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ClusterResourceQuotaBuilder builder;

            ClusterResourceQuotaContentNestedImpl(ClusterResourceQuota item) {
                this.builder = new ClusterResourceQuotaBuilder(this, item);
                        
            }

            ClusterResourceQuotaContentNestedImpl() {
                this.builder = new ClusterResourceQuotaBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endClusterResourceQuotaContent() {
                return and();
            }
    }


    public class ProjectRequestContentNestedImpl<N> extends ProjectRequestFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ProjectRequestContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ProjectRequestContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ProjectRequestBuilder builder;

            ProjectRequestContentNestedImpl(ProjectRequest item) {
                this.builder = new ProjectRequestBuilder(this, item);
                        
            }

            ProjectRequestContentNestedImpl() {
                this.builder = new ProjectRequestBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endProjectRequestContent() {
                return and();
            }
    }


    public class TemplateContentNestedImpl<N> extends TemplateFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.TemplateContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.TemplateContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TemplateBuilder builder;

            TemplateContentNestedImpl(Template item) {
                this.builder = new TemplateBuilder(this, item);
                        
            }

            TemplateContentNestedImpl() {
                this.builder = new TemplateBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endTemplateContent() {
                return and();
            }
    }


    public class OAuthClientAuthorizationContentNestedImpl<N> extends OAuthClientAuthorizationFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.OAuthClientAuthorizationContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.OAuthClientAuthorizationContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OAuthClientAuthorizationBuilder builder;

            OAuthClientAuthorizationContentNestedImpl(OAuthClientAuthorization item) {
                this.builder = new OAuthClientAuthorizationBuilder(this, item);
                        
            }

            OAuthClientAuthorizationContentNestedImpl() {
                this.builder = new OAuthClientAuthorizationBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endOAuthClientAuthorizationContent() {
                return and();
            }
    }


    public class ClusterRoleContentNestedImpl<N> extends ClusterRoleFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ClusterRoleContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ClusterRoleContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ClusterRoleBuilder builder;

            ClusterRoleContentNestedImpl(ClusterRole item) {
                this.builder = new ClusterRoleBuilder(this, item);
                        
            }

            ClusterRoleContentNestedImpl() {
                this.builder = new ClusterRoleBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endClusterRoleContent() {
                return and();
            }
    }


    public class ImageTagContentNestedImpl<N> extends ImageTagFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageTagContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageTagContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ImageTagBuilder builder;

            ImageTagContentNestedImpl(ImageTag item) {
                this.builder = new ImageTagBuilder(this, item);
                        
            }

            ImageTagContentNestedImpl() {
                this.builder = new ImageTagBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endImageTagContent() {
                return and();
            }
    }


    public class DeploymentConfigContentNestedImpl<N> extends DeploymentConfigFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.DeploymentConfigContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.DeploymentConfigContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DeploymentConfigBuilder builder;

            DeploymentConfigContentNestedImpl(DeploymentConfig item) {
                this.builder = new DeploymentConfigBuilder(this, item);
                        
            }

            DeploymentConfigContentNestedImpl() {
                this.builder = new DeploymentConfigBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endDeploymentConfigContent() {
                return and();
            }
    }


    public class OAuthAccessTokenContentNestedImpl<N> extends OAuthAccessTokenFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.OAuthAccessTokenContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.OAuthAccessTokenContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OAuthAccessTokenBuilder builder;

            OAuthAccessTokenContentNestedImpl(OAuthAccessToken item) {
                this.builder = new OAuthAccessTokenBuilder(this, item);
                        
            }

            OAuthAccessTokenContentNestedImpl() {
                this.builder = new OAuthAccessTokenBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endOAuthAccessTokenContent() {
                return and();
            }
    }


    public class RoleBindingContentNestedImpl<N> extends RoleBindingFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.RoleBindingContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.RoleBindingContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RoleBindingBuilder builder;

            RoleBindingContentNestedImpl(RoleBinding item) {
                this.builder = new RoleBindingBuilder(this, item);
                        
            }

            RoleBindingContentNestedImpl() {
                this.builder = new RoleBindingBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endRoleBindingContent() {
                return and();
            }
    }


    public class ImageContentNestedImpl<N> extends ImageFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ImageBuilder builder;

            ImageContentNestedImpl(Image item) {
                this.builder = new ImageBuilder(this, item);
                        
            }

            ImageContentNestedImpl() {
                this.builder = new ImageBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endImageContent() {
                return and();
            }
    }


    public class APIServerContentNestedImpl<N> extends APIServerFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.APIServerContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.APIServerContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIServerBuilder builder;

            APIServerContentNestedImpl(APIServer item) {
                this.builder = new APIServerBuilder(this, item);
                        
            }

            APIServerContentNestedImpl() {
                this.builder = new APIServerBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endAPIServerContent() {
                return and();
            }
    }


    public class PersistentVolumeClaimContentNestedImpl<N> extends PersistentVolumeClaimFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.PersistentVolumeClaimContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.PersistentVolumeClaimContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentVolumeClaimBuilder builder;

            PersistentVolumeClaimContentNestedImpl(PersistentVolumeClaim item) {
                this.builder = new PersistentVolumeClaimBuilder(this, item);
                        
            }

            PersistentVolumeClaimContentNestedImpl() {
                this.builder = new PersistentVolumeClaimBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endPersistentVolumeClaimContent() {
                return and();
            }
    }


    public class ImageStreamMappingContentNestedImpl<N> extends ImageStreamMappingFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageStreamMappingContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageStreamMappingContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ImageStreamMappingBuilder builder;

            ImageStreamMappingContentNestedImpl(ImageStreamMapping item) {
                this.builder = new ImageStreamMappingBuilder(this, item);
                        
            }

            ImageStreamMappingContentNestedImpl() {
                this.builder = new ImageStreamMappingBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endImageStreamMappingContent() {
                return and();
            }
    }


    public class RoleContentNestedImpl<N> extends RoleFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.RoleContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.RoleContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RoleBuilder builder;

            RoleContentNestedImpl(Role item) {
                this.builder = new RoleBuilder(this, item);
                        
            }

            RoleContentNestedImpl() {
                this.builder = new RoleBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endRoleContent() {
                return and();
            }
    }


    public class FeatureGateContentNestedImpl<N> extends FeatureGateFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.FeatureGateContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.FeatureGateContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final FeatureGateBuilder builder;

            FeatureGateContentNestedImpl(FeatureGate item) {
                this.builder = new FeatureGateBuilder(this, item);
                        
            }

            FeatureGateContentNestedImpl() {
                this.builder = new FeatureGateBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endFeatureGateContent() {
                return and();
            }
    }


    public class UserContentNestedImpl<N> extends UserFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.UserContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.UserContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final UserBuilder builder;

            UserContentNestedImpl(User item) {
                this.builder = new UserBuilder(this, item);
                        
            }

            UserContentNestedImpl() {
                this.builder = new UserBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endUserContent() {
                return and();
            }
    }


    public class ImageStreamImageContentNestedImpl<N> extends ImageStreamImageFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageStreamImageContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageStreamImageContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ImageStreamImageBuilder builder;

            ImageStreamImageContentNestedImpl(ImageStreamImage item) {
                this.builder = new ImageStreamImageBuilder(this, item);
                        
            }

            ImageStreamImageContentNestedImpl() {
                this.builder = new ImageStreamImageBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endImageStreamImageContent() {
                return and();
            }
    }


    public class BuildContentNestedImpl<N> extends BuildFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.BuildContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.BuildContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BuildBuilder builder;

            BuildContentNestedImpl(Build item) {
                this.builder = new BuildBuilder(this, item);
                        
            }

            BuildContentNestedImpl() {
                this.builder = new BuildBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endBuildContent() {
                return and();
            }
    }


    public class RoleBindingRestrictionContentNestedImpl<N> extends RoleBindingRestrictionFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.RoleBindingRestrictionContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.RoleBindingRestrictionContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RoleBindingRestrictionBuilder builder;

            RoleBindingRestrictionContentNestedImpl(RoleBindingRestriction item) {
                this.builder = new RoleBindingRestrictionBuilder(this, item);
                        
            }

            RoleBindingRestrictionContentNestedImpl() {
                this.builder = new RoleBindingRestrictionBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endRoleBindingRestrictionContent() {
                return and();
            }
    }


    public class ImageStreamTagContentNestedImpl<N> extends ImageStreamTagFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageStreamTagContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageStreamTagContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ImageStreamTagBuilder builder;

            ImageStreamTagContentNestedImpl(ImageStreamTag item) {
                this.builder = new ImageStreamTagBuilder(this, item);
                        
            }

            ImageStreamTagContentNestedImpl() {
                this.builder = new ImageStreamTagBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endImageStreamTagContent() {
                return and();
            }
    }


    public class GroupContentNestedImpl<N> extends GroupFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.GroupContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.GroupContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GroupBuilder builder;

            GroupContentNestedImpl(io.fabric8.openshift.api.model.Group item) {
                this.builder = new GroupBuilder(this, item);
                        
            }

            GroupContentNestedImpl() {
                this.builder = new GroupBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endGroupContent() {
                return and();
            }
    }


    public class ImageSignatureContentNestedImpl<N> extends ImageSignatureFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageSignatureContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageSignatureContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ImageSignatureBuilder builder;

            ImageSignatureContentNestedImpl(ImageSignature item) {
                this.builder = new ImageSignatureBuilder(this, item);
                        
            }

            ImageSignatureContentNestedImpl() {
                this.builder = new ImageSignatureBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endImageSignatureContent() {
                return and();
            }
    }


    public class AppliedClusterResourceQuotaContentNestedImpl<N> extends AppliedClusterResourceQuotaFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.AppliedClusterResourceQuotaContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.AppliedClusterResourceQuotaContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AppliedClusterResourceQuotaBuilder builder;

            AppliedClusterResourceQuotaContentNestedImpl(AppliedClusterResourceQuota item) {
                this.builder = new AppliedClusterResourceQuotaBuilder(this, item);
                        
            }

            AppliedClusterResourceQuotaContentNestedImpl() {
                this.builder = new AppliedClusterResourceQuotaBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endAppliedClusterResourceQuotaContent() {
                return and();
            }
    }


    public class SecurityContextConstraintsContentNestedImpl<N> extends SecurityContextConstraintsFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.SecurityContextConstraintsContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.SecurityContextConstraintsContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecurityContextConstraintsBuilder builder;

            SecurityContextConstraintsContentNestedImpl(SecurityContextConstraints item) {
                this.builder = new SecurityContextConstraintsBuilder(this, item);
                        
            }

            SecurityContextConstraintsContentNestedImpl() {
                this.builder = new SecurityContextConstraintsBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endSecurityContextConstraintsContent() {
                return and();
            }
    }


    public class BuildRequestContentNestedImpl<N> extends BuildRequestFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.BuildRequestContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.BuildRequestContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BuildRequestBuilder builder;

            BuildRequestContentNestedImpl(BuildRequest item) {
                this.builder = new BuildRequestBuilder(this, item);
                        
            }

            BuildRequestContentNestedImpl() {
                this.builder = new BuildRequestBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endBuildRequestContent() {
                return and();
            }
    }


    public class EgressNetworkPolicyContentNestedImpl<N> extends EgressNetworkPolicyFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.EgressNetworkPolicyContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.EgressNetworkPolicyContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EgressNetworkPolicyBuilder builder;

            EgressNetworkPolicyContentNestedImpl(EgressNetworkPolicy item) {
                this.builder = new EgressNetworkPolicyBuilder(this, item);
                        
            }

            EgressNetworkPolicyContentNestedImpl() {
                this.builder = new EgressNetworkPolicyBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endEgressNetworkPolicyContent() {
                return and();
            }
    }


    public class NetNamespaceContentNestedImpl<N> extends NetNamespaceFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.NetNamespaceContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.NetNamespaceContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NetNamespaceBuilder builder;

            NetNamespaceContentNestedImpl(NetNamespace item) {
                this.builder = new NetNamespaceBuilder(this, item);
                        
            }

            NetNamespaceContentNestedImpl() {
                this.builder = new NetNamespaceBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endNetNamespaceContent() {
                return and();
            }
    }


    public class ImageStreamContentNestedImpl<N> extends ImageStreamFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageStreamContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.ImageStreamContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ImageStreamBuilder builder;

            ImageStreamContentNestedImpl(ImageStream item) {
                this.builder = new ImageStreamBuilder(this, item);
                        
            }

            ImageStreamContentNestedImpl() {
                this.builder = new ImageStreamBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endImageStreamContent() {
                return and();
            }
    }


    public class OAuthClientContentNestedImpl<N> extends OAuthClientFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.OAuthClientContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.OAuthClientContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OAuthClientBuilder builder;

            OAuthClientContentNestedImpl(OAuthClient item) {
                this.builder = new OAuthClientBuilder(this, item);
                        
            }

            OAuthClientContentNestedImpl() {
                this.builder = new OAuthClientBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endOAuthClientContent() {
                return and();
            }
    }


    public class IdentityContentNestedImpl<N> extends IdentityFluentImpl<io.fabric8.openshift.api.model.ResourceAccessReviewFluent.IdentityContentNested<N>> implements io.fabric8.openshift.api.model.ResourceAccessReviewFluent.IdentityContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IdentityBuilder builder;

            IdentityContentNestedImpl(Identity item) {
                this.builder = new IdentityBuilder(this, item);
                        
            }

            IdentityContentNestedImpl() {
                this.builder = new IdentityBuilder(this);
                        
            }

            public N and() {
                return (N) ResourceAccessReviewFluentImpl.this.withContent(builder.build());
            }

            public N endIdentityContent() {
                return and();
            }
    }


}
