package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.lang.StringBuffer;
import java.util.function.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.StringBuilder;
import java.util.Iterator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import io.fabric8.kubernetes.api.builder.Nested;

public interface TemplateFluent<A extends TemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    public A addToLabels(String key,String value);
    public A addToLabels(java.util.Map<String,String> map);
    public A removeFromLabels(String key);
    public A removeFromLabels(java.util.Map<String,String> map);
    public java.util.Map<String,String> getLabels();
    public <K extends Object,V extends Object>A withLabels(java.util.Map<String,String> labels);
    public Boolean hasLabels();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public io.fabric8.openshift.api.model.TemplateFluent.MetadataNested<A> withNewMetadata();
    public io.fabric8.openshift.api.model.TemplateFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public io.fabric8.openshift.api.model.TemplateFluent.MetadataNested<A> editMetadata();
    public io.fabric8.openshift.api.model.TemplateFluent.MetadataNested<A> editOrNewMetadata();
    public io.fabric8.openshift.api.model.TemplateFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public A addToObjects(io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?> builder);
    public A addToObjects(int index,io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?> builder);
    public A addToObjects(int index,HasMetadata item);
    public A setToObjects(int index,HasMetadata item);
    public A addToObjects(HasMetadata... items);
    public A addAllToObjects(Collection<HasMetadata> items);
    public A removeFromObjects(io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?> builder);
    public A removeFromObjects(HasMetadata... items);
    public A removeAllFromObjects(Collection<HasMetadata> items);
    
/**
 * This method has been deprecated, please use method buildObjects instead.
 * @return The buildable object.
 */
@Deprecated public List<HasMetadata> getObjects();
    public List<HasMetadata> buildObjects();
    public HasMetadata buildObject(int index);
    public HasMetadata buildFirstObject();
    public HasMetadata buildLastObject();
    public HasMetadata buildMatchingObject(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public Boolean hasMatchingObject(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public A withObjects(List<HasMetadata> objects);
    public A withObjects(HasMetadata... objects);
    public Boolean hasObjects();
    public A addToClusterVersionObjects(int index,ClusterVersion item);
    public A setToClusterVersionObjects(int index,ClusterVersion item);
    public A addToClusterVersionObjects(ClusterVersion... items);
    public A addAllToClusterVersionObjects(Collection<ClusterVersion> items);
    public A removeFromClusterVersionObjects(ClusterVersion... items);
    public A removeAllFromClusterVersionObjects(Collection<ClusterVersion> items);
    public A removeMatchingFromClusterVersionObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.ClusterVersionObjectsNested<A> setNewClusterVersionObjectLike(int index,ClusterVersion item);
    public io.fabric8.openshift.api.model.TemplateFluent.ClusterVersionObjectsNested<A> addNewClusterVersionObject();
    public io.fabric8.openshift.api.model.TemplateFluent.ClusterVersionObjectsNested<A> addNewClusterVersionObjectLike(ClusterVersion item);
    public A addToImageStreamImportObjects(int index,ImageStreamImport item);
    public A setToImageStreamImportObjects(int index,ImageStreamImport item);
    public A addToImageStreamImportObjects(ImageStreamImport... items);
    public A addAllToImageStreamImportObjects(Collection<ImageStreamImport> items);
    public A removeFromImageStreamImportObjects(ImageStreamImport... items);
    public A removeAllFromImageStreamImportObjects(Collection<ImageStreamImport> items);
    public A removeMatchingFromImageStreamImportObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamImportObjectsNested<A> setNewImageStreamImportObjectLike(int index,ImageStreamImport item);
    public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamImportObjectsNested<A> addNewImageStreamImportObject();
    public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamImportObjectsNested<A> addNewImageStreamImportObjectLike(ImageStreamImport item);
    public A addToProxyObjects(int index,Proxy item);
    public A setToProxyObjects(int index,Proxy item);
    public A addToProxyObjects(Proxy... items);
    public A addAllToProxyObjects(Collection<Proxy> items);
    public A removeFromProxyObjects(Proxy... items);
    public A removeAllFromProxyObjects(Collection<Proxy> items);
    public A removeMatchingFromProxyObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.ProxyObjectsNested<A> setNewProxyObjectLike(int index,Proxy item);
    public io.fabric8.openshift.api.model.TemplateFluent.ProxyObjectsNested<A> addNewProxyObject();
    public io.fabric8.openshift.api.model.TemplateFluent.ProxyObjectsNested<A> addNewProxyObjectLike(Proxy item);
    public A addToProjectObjects(int index,Project item);
    public A setToProjectObjects(int index,Project item);
    public A addToProjectObjects(Project... items);
    public A addAllToProjectObjects(Collection<Project> items);
    public A removeFromProjectObjects(Project... items);
    public A removeAllFromProjectObjects(Collection<Project> items);
    public A removeMatchingFromProjectObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.ProjectObjectsNested<A> setNewProjectObjectLike(int index,Project item);
    public io.fabric8.openshift.api.model.TemplateFluent.ProjectObjectsNested<A> addNewProjectObject();
    public io.fabric8.openshift.api.model.TemplateFluent.ProjectObjectsNested<A> addNewProjectObjectLike(Project item);
    public A addToClusterOperatorObjects(int index,ClusterOperator item);
    public A setToClusterOperatorObjects(int index,ClusterOperator item);
    public A addToClusterOperatorObjects(ClusterOperator... items);
    public A addAllToClusterOperatorObjects(Collection<ClusterOperator> items);
    public A removeFromClusterOperatorObjects(ClusterOperator... items);
    public A removeAllFromClusterOperatorObjects(Collection<ClusterOperator> items);
    public A removeMatchingFromClusterOperatorObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.ClusterOperatorObjectsNested<A> setNewClusterOperatorObjectLike(int index,ClusterOperator item);
    public io.fabric8.openshift.api.model.TemplateFluent.ClusterOperatorObjectsNested<A> addNewClusterOperatorObject();
    public io.fabric8.openshift.api.model.TemplateFluent.ClusterOperatorObjectsNested<A> addNewClusterOperatorObjectLike(ClusterOperator item);
    public A addToBuildConfigObjects(int index,BuildConfig item);
    public A setToBuildConfigObjects(int index,BuildConfig item);
    public A addToBuildConfigObjects(BuildConfig... items);
    public A addAllToBuildConfigObjects(Collection<BuildConfig> items);
    public A removeFromBuildConfigObjects(BuildConfig... items);
    public A removeAllFromBuildConfigObjects(Collection<BuildConfig> items);
    public A removeMatchingFromBuildConfigObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.BuildConfigObjectsNested<A> setNewBuildConfigObjectLike(int index,BuildConfig item);
    public io.fabric8.openshift.api.model.TemplateFluent.BuildConfigObjectsNested<A> addNewBuildConfigObject();
    public io.fabric8.openshift.api.model.TemplateFluent.BuildConfigObjectsNested<A> addNewBuildConfigObjectLike(BuildConfig item);
    public A addToInfrastructureObjects(int index,Infrastructure item);
    public A setToInfrastructureObjects(int index,Infrastructure item);
    public A addToInfrastructureObjects(Infrastructure... items);
    public A addAllToInfrastructureObjects(Collection<Infrastructure> items);
    public A removeFromInfrastructureObjects(Infrastructure... items);
    public A removeAllFromInfrastructureObjects(Collection<Infrastructure> items);
    public A removeMatchingFromInfrastructureObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.InfrastructureObjectsNested<A> setNewInfrastructureObjectLike(int index,Infrastructure item);
    public io.fabric8.openshift.api.model.TemplateFluent.InfrastructureObjectsNested<A> addNewInfrastructureObject();
    public io.fabric8.openshift.api.model.TemplateFluent.InfrastructureObjectsNested<A> addNewInfrastructureObjectLike(Infrastructure item);
    public A addToSchedulerObjects(int index,Scheduler item);
    public A setToSchedulerObjects(int index,Scheduler item);
    public A addToSchedulerObjects(Scheduler... items);
    public A addAllToSchedulerObjects(Collection<Scheduler> items);
    public A removeFromSchedulerObjects(Scheduler... items);
    public A removeAllFromSchedulerObjects(Collection<Scheduler> items);
    public A removeMatchingFromSchedulerObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.SchedulerObjectsNested<A> setNewSchedulerObjectLike(int index,Scheduler item);
    public io.fabric8.openshift.api.model.TemplateFluent.SchedulerObjectsNested<A> addNewSchedulerObject();
    public io.fabric8.openshift.api.model.TemplateFluent.SchedulerObjectsNested<A> addNewSchedulerObjectLike(Scheduler item);
    public A addToRangeAllocationObjects(int index,RangeAllocation item);
    public A setToRangeAllocationObjects(int index,RangeAllocation item);
    public A addToRangeAllocationObjects(RangeAllocation... items);
    public A addAllToRangeAllocationObjects(Collection<RangeAllocation> items);
    public A removeFromRangeAllocationObjects(RangeAllocation... items);
    public A removeAllFromRangeAllocationObjects(Collection<RangeAllocation> items);
    public A removeMatchingFromRangeAllocationObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.RangeAllocationObjectsNested<A> setNewRangeAllocationObjectLike(int index,RangeAllocation item);
    public io.fabric8.openshift.api.model.TemplateFluent.RangeAllocationObjectsNested<A> addNewRangeAllocationObject();
    public io.fabric8.openshift.api.model.TemplateFluent.RangeAllocationObjectsNested<A> addNewRangeAllocationObjectLike(RangeAllocation item);
    public A addToRouteObjects(int index,Route item);
    public A setToRouteObjects(int index,Route item);
    public A addToRouteObjects(Route... items);
    public A addAllToRouteObjects(Collection<Route> items);
    public A removeFromRouteObjects(Route... items);
    public A removeAllFromRouteObjects(Collection<Route> items);
    public A removeMatchingFromRouteObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.RouteObjectsNested<A> setNewRouteObjectLike(int index,Route item);
    public io.fabric8.openshift.api.model.TemplateFluent.RouteObjectsNested<A> addNewRouteObject();
    public io.fabric8.openshift.api.model.TemplateFluent.RouteObjectsNested<A> addNewRouteObjectLike(Route item);
    public A addToClusterNetworkObjects(int index,ClusterNetwork item);
    public A setToClusterNetworkObjects(int index,ClusterNetwork item);
    public A addToClusterNetworkObjects(ClusterNetwork... items);
    public A addAllToClusterNetworkObjects(Collection<ClusterNetwork> items);
    public A removeFromClusterNetworkObjects(ClusterNetwork... items);
    public A removeAllFromClusterNetworkObjects(Collection<ClusterNetwork> items);
    public A removeMatchingFromClusterNetworkObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.ClusterNetworkObjectsNested<A> setNewClusterNetworkObjectLike(int index,ClusterNetwork item);
    public io.fabric8.openshift.api.model.TemplateFluent.ClusterNetworkObjectsNested<A> addNewClusterNetworkObject();
    public io.fabric8.openshift.api.model.TemplateFluent.ClusterNetworkObjectsNested<A> addNewClusterNetworkObjectLike(ClusterNetwork item);
    public A addToOAuthAuthorizeTokenObjects(int index,OAuthAuthorizeToken item);
    public A setToOAuthAuthorizeTokenObjects(int index,OAuthAuthorizeToken item);
    public A addToOAuthAuthorizeTokenObjects(OAuthAuthorizeToken... items);
    public A addAllToOAuthAuthorizeTokenObjects(Collection<OAuthAuthorizeToken> items);
    public A removeFromOAuthAuthorizeTokenObjects(OAuthAuthorizeToken... items);
    public A removeAllFromOAuthAuthorizeTokenObjects(Collection<OAuthAuthorizeToken> items);
    public A removeMatchingFromOAuthAuthorizeTokenObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.OAuthAuthorizeTokenObjectsNested<A> setNewOAuthAuthorizeTokenObjectLike(int index,OAuthAuthorizeToken item);
    public io.fabric8.openshift.api.model.TemplateFluent.OAuthAuthorizeTokenObjectsNested<A> addNewOAuthAuthorizeTokenObject();
    public io.fabric8.openshift.api.model.TemplateFluent.OAuthAuthorizeTokenObjectsNested<A> addNewOAuthAuthorizeTokenObjectLike(OAuthAuthorizeToken item);
    public A addToIngressObjects(int index,Ingress item);
    public A setToIngressObjects(int index,Ingress item);
    public A addToIngressObjects(Ingress... items);
    public A addAllToIngressObjects(Collection<Ingress> items);
    public A removeFromIngressObjects(Ingress... items);
    public A removeAllFromIngressObjects(Collection<Ingress> items);
    public A removeMatchingFromIngressObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.IngressObjectsNested<A> setNewIngressObjectLike(int index,Ingress item);
    public io.fabric8.openshift.api.model.TemplateFluent.IngressObjectsNested<A> addNewIngressObject();
    public io.fabric8.openshift.api.model.TemplateFluent.IngressObjectsNested<A> addNewIngressObjectLike(Ingress item);
    public A addToOAuthObjects(int index,OAuth item);
    public A setToOAuthObjects(int index,OAuth item);
    public A addToOAuthObjects(OAuth... items);
    public A addAllToOAuthObjects(Collection<OAuth> items);
    public A removeFromOAuthObjects(OAuth... items);
    public A removeAllFromOAuthObjects(Collection<OAuth> items);
    public A removeMatchingFromOAuthObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.OAuthObjectsNested<A> setNewOAuthObjectLike(int index,OAuth item);
    public io.fabric8.openshift.api.model.TemplateFluent.OAuthObjectsNested<A> addNewOAuthObject();
    public io.fabric8.openshift.api.model.TemplateFluent.OAuthObjectsNested<A> addNewOAuthObjectLike(OAuth item);
    public A addToOperatorHubObjects(int index,OperatorHub item);
    public A setToOperatorHubObjects(int index,OperatorHub item);
    public A addToOperatorHubObjects(OperatorHub... items);
    public A addAllToOperatorHubObjects(Collection<OperatorHub> items);
    public A removeFromOperatorHubObjects(OperatorHub... items);
    public A removeAllFromOperatorHubObjects(Collection<OperatorHub> items);
    public A removeMatchingFromOperatorHubObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.OperatorHubObjectsNested<A> setNewOperatorHubObjectLike(int index,OperatorHub item);
    public io.fabric8.openshift.api.model.TemplateFluent.OperatorHubObjectsNested<A> addNewOperatorHubObject();
    public io.fabric8.openshift.api.model.TemplateFluent.OperatorHubObjectsNested<A> addNewOperatorHubObjectLike(OperatorHub item);
    public A addToClusterRoleBindingObjects(int index,ClusterRoleBinding item);
    public A setToClusterRoleBindingObjects(int index,ClusterRoleBinding item);
    public A addToClusterRoleBindingObjects(ClusterRoleBinding... items);
    public A addAllToClusterRoleBindingObjects(Collection<ClusterRoleBinding> items);
    public A removeFromClusterRoleBindingObjects(ClusterRoleBinding... items);
    public A removeAllFromClusterRoleBindingObjects(Collection<ClusterRoleBinding> items);
    public A removeMatchingFromClusterRoleBindingObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.ClusterRoleBindingObjectsNested<A> setNewClusterRoleBindingObjectLike(int index,ClusterRoleBinding item);
    public io.fabric8.openshift.api.model.TemplateFluent.ClusterRoleBindingObjectsNested<A> addNewClusterRoleBindingObject();
    public io.fabric8.openshift.api.model.TemplateFluent.ClusterRoleBindingObjectsNested<A> addNewClusterRoleBindingObjectLike(ClusterRoleBinding item);
    public A addToClusterResourceQuotaObjects(int index,ClusterResourceQuota item);
    public A setToClusterResourceQuotaObjects(int index,ClusterResourceQuota item);
    public A addToClusterResourceQuotaObjects(ClusterResourceQuota... items);
    public A addAllToClusterResourceQuotaObjects(Collection<ClusterResourceQuota> items);
    public A removeFromClusterResourceQuotaObjects(ClusterResourceQuota... items);
    public A removeAllFromClusterResourceQuotaObjects(Collection<ClusterResourceQuota> items);
    public A removeMatchingFromClusterResourceQuotaObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.ClusterResourceQuotaObjectsNested<A> setNewClusterResourceQuotaObjectLike(int index,ClusterResourceQuota item);
    public io.fabric8.openshift.api.model.TemplateFluent.ClusterResourceQuotaObjectsNested<A> addNewClusterResourceQuotaObject();
    public io.fabric8.openshift.api.model.TemplateFluent.ClusterResourceQuotaObjectsNested<A> addNewClusterResourceQuotaObjectLike(ClusterResourceQuota item);
    public A addToProjectRequestObjects(int index,ProjectRequest item);
    public A setToProjectRequestObjects(int index,ProjectRequest item);
    public A addToProjectRequestObjects(ProjectRequest... items);
    public A addAllToProjectRequestObjects(Collection<ProjectRequest> items);
    public A removeFromProjectRequestObjects(ProjectRequest... items);
    public A removeAllFromProjectRequestObjects(Collection<ProjectRequest> items);
    public A removeMatchingFromProjectRequestObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.ProjectRequestObjectsNested<A> setNewProjectRequestObjectLike(int index,ProjectRequest item);
    public io.fabric8.openshift.api.model.TemplateFluent.ProjectRequestObjectsNested<A> addNewProjectRequestObject();
    public io.fabric8.openshift.api.model.TemplateFluent.ProjectRequestObjectsNested<A> addNewProjectRequestObjectLike(ProjectRequest item);
    public A addToTemplateObjects(int index,Template item);
    public A setToTemplateObjects(int index,Template item);
    public A addToTemplateObjects(Template... items);
    public A addAllToTemplateObjects(Collection<Template> items);
    public A removeFromTemplateObjects(Template... items);
    public A removeAllFromTemplateObjects(Collection<Template> items);
    public A removeMatchingFromTemplateObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.TemplateObjectsNested<A> setNewTemplateObjectLike(int index,Template item);
    public io.fabric8.openshift.api.model.TemplateFluent.TemplateObjectsNested<A> addNewTemplateObject();
    public io.fabric8.openshift.api.model.TemplateFluent.TemplateObjectsNested<A> addNewTemplateObjectLike(Template item);
    public A addToOAuthClientAuthorizationObjects(int index,OAuthClientAuthorization item);
    public A setToOAuthClientAuthorizationObjects(int index,OAuthClientAuthorization item);
    public A addToOAuthClientAuthorizationObjects(OAuthClientAuthorization... items);
    public A addAllToOAuthClientAuthorizationObjects(Collection<OAuthClientAuthorization> items);
    public A removeFromOAuthClientAuthorizationObjects(OAuthClientAuthorization... items);
    public A removeAllFromOAuthClientAuthorizationObjects(Collection<OAuthClientAuthorization> items);
    public A removeMatchingFromOAuthClientAuthorizationObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.OAuthClientAuthorizationObjectsNested<A> setNewOAuthClientAuthorizationObjectLike(int index,OAuthClientAuthorization item);
    public io.fabric8.openshift.api.model.TemplateFluent.OAuthClientAuthorizationObjectsNested<A> addNewOAuthClientAuthorizationObject();
    public io.fabric8.openshift.api.model.TemplateFluent.OAuthClientAuthorizationObjectsNested<A> addNewOAuthClientAuthorizationObjectLike(OAuthClientAuthorization item);
    public A addToClusterRoleObjects(int index,ClusterRole item);
    public A setToClusterRoleObjects(int index,ClusterRole item);
    public A addToClusterRoleObjects(ClusterRole... items);
    public A addAllToClusterRoleObjects(Collection<ClusterRole> items);
    public A removeFromClusterRoleObjects(ClusterRole... items);
    public A removeAllFromClusterRoleObjects(Collection<ClusterRole> items);
    public A removeMatchingFromClusterRoleObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.ClusterRoleObjectsNested<A> setNewClusterRoleObjectLike(int index,ClusterRole item);
    public io.fabric8.openshift.api.model.TemplateFluent.ClusterRoleObjectsNested<A> addNewClusterRoleObject();
    public io.fabric8.openshift.api.model.TemplateFluent.ClusterRoleObjectsNested<A> addNewClusterRoleObjectLike(ClusterRole item);
    public A addToImageTagObjects(int index,ImageTag item);
    public A setToImageTagObjects(int index,ImageTag item);
    public A addToImageTagObjects(ImageTag... items);
    public A addAllToImageTagObjects(Collection<ImageTag> items);
    public A removeFromImageTagObjects(ImageTag... items);
    public A removeAllFromImageTagObjects(Collection<ImageTag> items);
    public A removeMatchingFromImageTagObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.ImageTagObjectsNested<A> setNewImageTagObjectLike(int index,ImageTag item);
    public io.fabric8.openshift.api.model.TemplateFluent.ImageTagObjectsNested<A> addNewImageTagObject();
    public io.fabric8.openshift.api.model.TemplateFluent.ImageTagObjectsNested<A> addNewImageTagObjectLike(ImageTag item);
    public A addToDeploymentConfigObjects(int index,DeploymentConfig item);
    public A setToDeploymentConfigObjects(int index,DeploymentConfig item);
    public A addToDeploymentConfigObjects(DeploymentConfig... items);
    public A addAllToDeploymentConfigObjects(Collection<DeploymentConfig> items);
    public A removeFromDeploymentConfigObjects(DeploymentConfig... items);
    public A removeAllFromDeploymentConfigObjects(Collection<DeploymentConfig> items);
    public A removeMatchingFromDeploymentConfigObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.DeploymentConfigObjectsNested<A> setNewDeploymentConfigObjectLike(int index,DeploymentConfig item);
    public io.fabric8.openshift.api.model.TemplateFluent.DeploymentConfigObjectsNested<A> addNewDeploymentConfigObject();
    public io.fabric8.openshift.api.model.TemplateFluent.DeploymentConfigObjectsNested<A> addNewDeploymentConfigObjectLike(DeploymentConfig item);
    public A addToOAuthAccessTokenObjects(int index,OAuthAccessToken item);
    public A setToOAuthAccessTokenObjects(int index,OAuthAccessToken item);
    public A addToOAuthAccessTokenObjects(OAuthAccessToken... items);
    public A addAllToOAuthAccessTokenObjects(Collection<OAuthAccessToken> items);
    public A removeFromOAuthAccessTokenObjects(OAuthAccessToken... items);
    public A removeAllFromOAuthAccessTokenObjects(Collection<OAuthAccessToken> items);
    public A removeMatchingFromOAuthAccessTokenObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.OAuthAccessTokenObjectsNested<A> setNewOAuthAccessTokenObjectLike(int index,OAuthAccessToken item);
    public io.fabric8.openshift.api.model.TemplateFluent.OAuthAccessTokenObjectsNested<A> addNewOAuthAccessTokenObject();
    public io.fabric8.openshift.api.model.TemplateFluent.OAuthAccessTokenObjectsNested<A> addNewOAuthAccessTokenObjectLike(OAuthAccessToken item);
    public A addToRoleBindingObjects(int index,RoleBinding item);
    public A setToRoleBindingObjects(int index,RoleBinding item);
    public A addToRoleBindingObjects(RoleBinding... items);
    public A addAllToRoleBindingObjects(Collection<RoleBinding> items);
    public A removeFromRoleBindingObjects(RoleBinding... items);
    public A removeAllFromRoleBindingObjects(Collection<RoleBinding> items);
    public A removeMatchingFromRoleBindingObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.RoleBindingObjectsNested<A> setNewRoleBindingObjectLike(int index,RoleBinding item);
    public io.fabric8.openshift.api.model.TemplateFluent.RoleBindingObjectsNested<A> addNewRoleBindingObject();
    public io.fabric8.openshift.api.model.TemplateFluent.RoleBindingObjectsNested<A> addNewRoleBindingObjectLike(RoleBinding item);
    public A addToImageObjects(int index,Image item);
    public A setToImageObjects(int index,Image item);
    public A addToImageObjects(Image... items);
    public A addAllToImageObjects(Collection<Image> items);
    public A removeFromImageObjects(Image... items);
    public A removeAllFromImageObjects(Collection<Image> items);
    public A removeMatchingFromImageObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.ImageObjectsNested<A> setNewImageObjectLike(int index,Image item);
    public io.fabric8.openshift.api.model.TemplateFluent.ImageObjectsNested<A> addNewImageObject();
    public io.fabric8.openshift.api.model.TemplateFluent.ImageObjectsNested<A> addNewImageObjectLike(Image item);
    public A addToAPIServerObjects(int index,APIServer item);
    public A setToAPIServerObjects(int index,APIServer item);
    public A addToAPIServerObjects(APIServer... items);
    public A addAllToAPIServerObjects(Collection<APIServer> items);
    public A removeFromAPIServerObjects(APIServer... items);
    public A removeAllFromAPIServerObjects(Collection<APIServer> items);
    public A removeMatchingFromAPIServerObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.APIServerObjectsNested<A> setNewAPIServerObjectLike(int index,APIServer item);
    public io.fabric8.openshift.api.model.TemplateFluent.APIServerObjectsNested<A> addNewAPIServerObject();
    public io.fabric8.openshift.api.model.TemplateFluent.APIServerObjectsNested<A> addNewAPIServerObjectLike(APIServer item);
    public A addToPersistentVolumeClaimObjects(int index,PersistentVolumeClaim item);
    public A setToPersistentVolumeClaimObjects(int index,PersistentVolumeClaim item);
    public A addToPersistentVolumeClaimObjects(PersistentVolumeClaim... items);
    public A addAllToPersistentVolumeClaimObjects(Collection<PersistentVolumeClaim> items);
    public A removeFromPersistentVolumeClaimObjects(PersistentVolumeClaim... items);
    public A removeAllFromPersistentVolumeClaimObjects(Collection<PersistentVolumeClaim> items);
    public A removeMatchingFromPersistentVolumeClaimObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.PersistentVolumeClaimObjectsNested<A> setNewPersistentVolumeClaimObjectLike(int index,PersistentVolumeClaim item);
    public io.fabric8.openshift.api.model.TemplateFluent.PersistentVolumeClaimObjectsNested<A> addNewPersistentVolumeClaimObject();
    public io.fabric8.openshift.api.model.TemplateFluent.PersistentVolumeClaimObjectsNested<A> addNewPersistentVolumeClaimObjectLike(PersistentVolumeClaim item);
    public A addToImageStreamMappingObjects(int index,ImageStreamMapping item);
    public A setToImageStreamMappingObjects(int index,ImageStreamMapping item);
    public A addToImageStreamMappingObjects(ImageStreamMapping... items);
    public A addAllToImageStreamMappingObjects(Collection<ImageStreamMapping> items);
    public A removeFromImageStreamMappingObjects(ImageStreamMapping... items);
    public A removeAllFromImageStreamMappingObjects(Collection<ImageStreamMapping> items);
    public A removeMatchingFromImageStreamMappingObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamMappingObjectsNested<A> setNewImageStreamMappingObjectLike(int index,ImageStreamMapping item);
    public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamMappingObjectsNested<A> addNewImageStreamMappingObject();
    public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamMappingObjectsNested<A> addNewImageStreamMappingObjectLike(ImageStreamMapping item);
    public A addToRoleObjects(int index,Role item);
    public A setToRoleObjects(int index,Role item);
    public A addToRoleObjects(Role... items);
    public A addAllToRoleObjects(Collection<Role> items);
    public A removeFromRoleObjects(Role... items);
    public A removeAllFromRoleObjects(Collection<Role> items);
    public A removeMatchingFromRoleObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.RoleObjectsNested<A> setNewRoleObjectLike(int index,Role item);
    public io.fabric8.openshift.api.model.TemplateFluent.RoleObjectsNested<A> addNewRoleObject();
    public io.fabric8.openshift.api.model.TemplateFluent.RoleObjectsNested<A> addNewRoleObjectLike(Role item);
    public A addToFeatureGateObjects(int index,FeatureGate item);
    public A setToFeatureGateObjects(int index,FeatureGate item);
    public A addToFeatureGateObjects(FeatureGate... items);
    public A addAllToFeatureGateObjects(Collection<FeatureGate> items);
    public A removeFromFeatureGateObjects(FeatureGate... items);
    public A removeAllFromFeatureGateObjects(Collection<FeatureGate> items);
    public A removeMatchingFromFeatureGateObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.FeatureGateObjectsNested<A> setNewFeatureGateObjectLike(int index,FeatureGate item);
    public io.fabric8.openshift.api.model.TemplateFluent.FeatureGateObjectsNested<A> addNewFeatureGateObject();
    public io.fabric8.openshift.api.model.TemplateFluent.FeatureGateObjectsNested<A> addNewFeatureGateObjectLike(FeatureGate item);
    public A addToUserObjects(int index,User item);
    public A setToUserObjects(int index,User item);
    public A addToUserObjects(User... items);
    public A addAllToUserObjects(Collection<User> items);
    public A removeFromUserObjects(User... items);
    public A removeAllFromUserObjects(Collection<User> items);
    public A removeMatchingFromUserObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.UserObjectsNested<A> setNewUserObjectLike(int index,User item);
    public io.fabric8.openshift.api.model.TemplateFluent.UserObjectsNested<A> addNewUserObject();
    public io.fabric8.openshift.api.model.TemplateFluent.UserObjectsNested<A> addNewUserObjectLike(User item);
    public A addToImageStreamImageObjects(int index,ImageStreamImage item);
    public A setToImageStreamImageObjects(int index,ImageStreamImage item);
    public A addToImageStreamImageObjects(ImageStreamImage... items);
    public A addAllToImageStreamImageObjects(Collection<ImageStreamImage> items);
    public A removeFromImageStreamImageObjects(ImageStreamImage... items);
    public A removeAllFromImageStreamImageObjects(Collection<ImageStreamImage> items);
    public A removeMatchingFromImageStreamImageObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamImageObjectsNested<A> setNewImageStreamImageObjectLike(int index,ImageStreamImage item);
    public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamImageObjectsNested<A> addNewImageStreamImageObject();
    public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamImageObjectsNested<A> addNewImageStreamImageObjectLike(ImageStreamImage item);
    public A addToBuildObjects(int index,Build item);
    public A setToBuildObjects(int index,Build item);
    public A addToBuildObjects(Build... items);
    public A addAllToBuildObjects(Collection<Build> items);
    public A removeFromBuildObjects(Build... items);
    public A removeAllFromBuildObjects(Collection<Build> items);
    public A removeMatchingFromBuildObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.BuildObjectsNested<A> setNewBuildObjectLike(int index,Build item);
    public io.fabric8.openshift.api.model.TemplateFluent.BuildObjectsNested<A> addNewBuildObject();
    public io.fabric8.openshift.api.model.TemplateFluent.BuildObjectsNested<A> addNewBuildObjectLike(Build item);
    public A addToRoleBindingRestrictionObjects(int index,RoleBindingRestriction item);
    public A setToRoleBindingRestrictionObjects(int index,RoleBindingRestriction item);
    public A addToRoleBindingRestrictionObjects(RoleBindingRestriction... items);
    public A addAllToRoleBindingRestrictionObjects(Collection<RoleBindingRestriction> items);
    public A removeFromRoleBindingRestrictionObjects(RoleBindingRestriction... items);
    public A removeAllFromRoleBindingRestrictionObjects(Collection<RoleBindingRestriction> items);
    public A removeMatchingFromRoleBindingRestrictionObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.RoleBindingRestrictionObjectsNested<A> setNewRoleBindingRestrictionObjectLike(int index,RoleBindingRestriction item);
    public io.fabric8.openshift.api.model.TemplateFluent.RoleBindingRestrictionObjectsNested<A> addNewRoleBindingRestrictionObject();
    public io.fabric8.openshift.api.model.TemplateFluent.RoleBindingRestrictionObjectsNested<A> addNewRoleBindingRestrictionObjectLike(RoleBindingRestriction item);
    public A addToImageStreamTagObjects(int index,ImageStreamTag item);
    public A setToImageStreamTagObjects(int index,ImageStreamTag item);
    public A addToImageStreamTagObjects(ImageStreamTag... items);
    public A addAllToImageStreamTagObjects(Collection<ImageStreamTag> items);
    public A removeFromImageStreamTagObjects(ImageStreamTag... items);
    public A removeAllFromImageStreamTagObjects(Collection<ImageStreamTag> items);
    public A removeMatchingFromImageStreamTagObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamTagObjectsNested<A> setNewImageStreamTagObjectLike(int index,ImageStreamTag item);
    public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamTagObjectsNested<A> addNewImageStreamTagObject();
    public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamTagObjectsNested<A> addNewImageStreamTagObjectLike(ImageStreamTag item);
    public A addToGroupObjects(int index,io.fabric8.openshift.api.model.Group item);
    public A setToGroupObjects(int index,io.fabric8.openshift.api.model.Group item);
    public A addToGroupObjects(io.fabric8.openshift.api.model.Group... items);
    public A addAllToGroupObjects(Collection<io.fabric8.openshift.api.model.Group> items);
    public A removeFromGroupObjects(io.fabric8.openshift.api.model.Group... items);
    public A removeAllFromGroupObjects(Collection<io.fabric8.openshift.api.model.Group> items);
    public A removeMatchingFromGroupObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.GroupObjectsNested<A> setNewGroupObjectLike(int index,io.fabric8.openshift.api.model.Group item);
    public io.fabric8.openshift.api.model.TemplateFluent.GroupObjectsNested<A> addNewGroupObject();
    public io.fabric8.openshift.api.model.TemplateFluent.GroupObjectsNested<A> addNewGroupObjectLike(io.fabric8.openshift.api.model.Group item);
    public A addToImageSignatureObjects(int index,ImageSignature item);
    public A setToImageSignatureObjects(int index,ImageSignature item);
    public A addToImageSignatureObjects(ImageSignature... items);
    public A addAllToImageSignatureObjects(Collection<ImageSignature> items);
    public A removeFromImageSignatureObjects(ImageSignature... items);
    public A removeAllFromImageSignatureObjects(Collection<ImageSignature> items);
    public A removeMatchingFromImageSignatureObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.ImageSignatureObjectsNested<A> setNewImageSignatureObjectLike(int index,ImageSignature item);
    public io.fabric8.openshift.api.model.TemplateFluent.ImageSignatureObjectsNested<A> addNewImageSignatureObject();
    public io.fabric8.openshift.api.model.TemplateFluent.ImageSignatureObjectsNested<A> addNewImageSignatureObjectLike(ImageSignature item);
    public A addToAppliedClusterResourceQuotaObjects(int index,AppliedClusterResourceQuota item);
    public A setToAppliedClusterResourceQuotaObjects(int index,AppliedClusterResourceQuota item);
    public A addToAppliedClusterResourceQuotaObjects(AppliedClusterResourceQuota... items);
    public A addAllToAppliedClusterResourceQuotaObjects(Collection<AppliedClusterResourceQuota> items);
    public A removeFromAppliedClusterResourceQuotaObjects(AppliedClusterResourceQuota... items);
    public A removeAllFromAppliedClusterResourceQuotaObjects(Collection<AppliedClusterResourceQuota> items);
    public A removeMatchingFromAppliedClusterResourceQuotaObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.AppliedClusterResourceQuotaObjectsNested<A> setNewAppliedClusterResourceQuotaObjectLike(int index,AppliedClusterResourceQuota item);
    public io.fabric8.openshift.api.model.TemplateFluent.AppliedClusterResourceQuotaObjectsNested<A> addNewAppliedClusterResourceQuotaObject();
    public io.fabric8.openshift.api.model.TemplateFluent.AppliedClusterResourceQuotaObjectsNested<A> addNewAppliedClusterResourceQuotaObjectLike(AppliedClusterResourceQuota item);
    public A addToSecurityContextConstraintsObjects(int index,SecurityContextConstraints item);
    public A setToSecurityContextConstraintsObjects(int index,SecurityContextConstraints item);
    public A addToSecurityContextConstraintsObjects(SecurityContextConstraints... items);
    public A addAllToSecurityContextConstraintsObjects(Collection<SecurityContextConstraints> items);
    public A removeFromSecurityContextConstraintsObjects(SecurityContextConstraints... items);
    public A removeAllFromSecurityContextConstraintsObjects(Collection<SecurityContextConstraints> items);
    public A removeMatchingFromSecurityContextConstraintsObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.SecurityContextConstraintsObjectsNested<A> setNewSecurityContextConstraintsObjectLike(int index,SecurityContextConstraints item);
    public io.fabric8.openshift.api.model.TemplateFluent.SecurityContextConstraintsObjectsNested<A> addNewSecurityContextConstraintsObject();
    public io.fabric8.openshift.api.model.TemplateFluent.SecurityContextConstraintsObjectsNested<A> addNewSecurityContextConstraintsObjectLike(SecurityContextConstraints item);
    public A addToBuildRequestObjects(int index,BuildRequest item);
    public A setToBuildRequestObjects(int index,BuildRequest item);
    public A addToBuildRequestObjects(BuildRequest... items);
    public A addAllToBuildRequestObjects(Collection<BuildRequest> items);
    public A removeFromBuildRequestObjects(BuildRequest... items);
    public A removeAllFromBuildRequestObjects(Collection<BuildRequest> items);
    public A removeMatchingFromBuildRequestObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.BuildRequestObjectsNested<A> setNewBuildRequestObjectLike(int index,BuildRequest item);
    public io.fabric8.openshift.api.model.TemplateFluent.BuildRequestObjectsNested<A> addNewBuildRequestObject();
    public io.fabric8.openshift.api.model.TemplateFluent.BuildRequestObjectsNested<A> addNewBuildRequestObjectLike(BuildRequest item);
    public A addToEgressNetworkPolicyObjects(int index,EgressNetworkPolicy item);
    public A setToEgressNetworkPolicyObjects(int index,EgressNetworkPolicy item);
    public A addToEgressNetworkPolicyObjects(EgressNetworkPolicy... items);
    public A addAllToEgressNetworkPolicyObjects(Collection<EgressNetworkPolicy> items);
    public A removeFromEgressNetworkPolicyObjects(EgressNetworkPolicy... items);
    public A removeAllFromEgressNetworkPolicyObjects(Collection<EgressNetworkPolicy> items);
    public A removeMatchingFromEgressNetworkPolicyObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.EgressNetworkPolicyObjectsNested<A> setNewEgressNetworkPolicyObjectLike(int index,EgressNetworkPolicy item);
    public io.fabric8.openshift.api.model.TemplateFluent.EgressNetworkPolicyObjectsNested<A> addNewEgressNetworkPolicyObject();
    public io.fabric8.openshift.api.model.TemplateFluent.EgressNetworkPolicyObjectsNested<A> addNewEgressNetworkPolicyObjectLike(EgressNetworkPolicy item);
    public A addToNetNamespaceObjects(int index,NetNamespace item);
    public A setToNetNamespaceObjects(int index,NetNamespace item);
    public A addToNetNamespaceObjects(NetNamespace... items);
    public A addAllToNetNamespaceObjects(Collection<NetNamespace> items);
    public A removeFromNetNamespaceObjects(NetNamespace... items);
    public A removeAllFromNetNamespaceObjects(Collection<NetNamespace> items);
    public A removeMatchingFromNetNamespaceObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.NetNamespaceObjectsNested<A> setNewNetNamespaceObjectLike(int index,NetNamespace item);
    public io.fabric8.openshift.api.model.TemplateFluent.NetNamespaceObjectsNested<A> addNewNetNamespaceObject();
    public io.fabric8.openshift.api.model.TemplateFluent.NetNamespaceObjectsNested<A> addNewNetNamespaceObjectLike(NetNamespace item);
    public A addToImageStreamObjects(int index,ImageStream item);
    public A setToImageStreamObjects(int index,ImageStream item);
    public A addToImageStreamObjects(ImageStream... items);
    public A addAllToImageStreamObjects(Collection<ImageStream> items);
    public A removeFromImageStreamObjects(ImageStream... items);
    public A removeAllFromImageStreamObjects(Collection<ImageStream> items);
    public A removeMatchingFromImageStreamObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamObjectsNested<A> setNewImageStreamObjectLike(int index,ImageStream item);
    public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamObjectsNested<A> addNewImageStreamObject();
    public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamObjectsNested<A> addNewImageStreamObjectLike(ImageStream item);
    public A addToOAuthClientObjects(int index,OAuthClient item);
    public A setToOAuthClientObjects(int index,OAuthClient item);
    public A addToOAuthClientObjects(OAuthClient... items);
    public A addAllToOAuthClientObjects(Collection<OAuthClient> items);
    public A removeFromOAuthClientObjects(OAuthClient... items);
    public A removeAllFromOAuthClientObjects(Collection<OAuthClient> items);
    public A removeMatchingFromOAuthClientObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.OAuthClientObjectsNested<A> setNewOAuthClientObjectLike(int index,OAuthClient item);
    public io.fabric8.openshift.api.model.TemplateFluent.OAuthClientObjectsNested<A> addNewOAuthClientObject();
    public io.fabric8.openshift.api.model.TemplateFluent.OAuthClientObjectsNested<A> addNewOAuthClientObjectLike(OAuthClient item);
    public A addToIdentityObjects(int index,Identity item);
    public A setToIdentityObjects(int index,Identity item);
    public A addToIdentityObjects(Identity... items);
    public A addAllToIdentityObjects(Collection<Identity> items);
    public A removeFromIdentityObjects(Identity... items);
    public A removeAllFromIdentityObjects(Collection<Identity> items);
    public A removeMatchingFromIdentityObjects(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?>> predicate);
    public io.fabric8.openshift.api.model.TemplateFluent.IdentityObjectsNested<A> setNewIdentityObjectLike(int index,Identity item);
    public io.fabric8.openshift.api.model.TemplateFluent.IdentityObjectsNested<A> addNewIdentityObject();
    public io.fabric8.openshift.api.model.TemplateFluent.IdentityObjectsNested<A> addNewIdentityObjectLike(Identity item);
    public A addToParameters(int index,Parameter item);
    public A setToParameters(int index,Parameter item);
    public A addToParameters(Parameter... items);
    public A addAllToParameters(Collection<Parameter> items);
    public A removeFromParameters(Parameter... items);
    public A removeAllFromParameters(Collection<Parameter> items);
    public A removeMatchingFromParameters(Predicate<ParameterBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildParameters instead.
 * @return The buildable object.
 */
@Deprecated public List<Parameter> getParameters();
    public List<Parameter> buildParameters();
    public Parameter buildParameter(int index);
    public Parameter buildFirstParameter();
    public Parameter buildLastParameter();
    public Parameter buildMatchingParameter(Predicate<ParameterBuilder> predicate);
    public Boolean hasMatchingParameter(Predicate<ParameterBuilder> predicate);
    public A withParameters(List<Parameter> parameters);
    public A withParameters(Parameter... parameters);
    public Boolean hasParameters();
    public io.fabric8.openshift.api.model.TemplateFluent.ParametersNested<A> addNewParameter();
    public io.fabric8.openshift.api.model.TemplateFluent.ParametersNested<A> addNewParameterLike(Parameter item);
    public io.fabric8.openshift.api.model.TemplateFluent.ParametersNested<A> setNewParameterLike(int index,Parameter item);
    public io.fabric8.openshift.api.model.TemplateFluent.ParametersNested<A> editParameter(int index);
    public io.fabric8.openshift.api.model.TemplateFluent.ParametersNested<A> editFirstParameter();
    public io.fabric8.openshift.api.model.TemplateFluent.ParametersNested<A> editLastParameter();
    public io.fabric8.openshift.api.model.TemplateFluent.ParametersNested<A> editMatchingParameter(Predicate<ParameterBuilder> predicate);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<io.fabric8.openshift.api.model.TemplateFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


    public interface ClusterVersionObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterVersionFluent<io.fabric8.openshift.api.model.TemplateFluent.ClusterVersionObjectsNested<N>> {

            public N and();
            public N endClusterVersionObject();    }


    public interface ImageStreamImportObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamImportFluent<io.fabric8.openshift.api.model.TemplateFluent.ImageStreamImportObjectsNested<N>> {

            public N and();
            public N endImageStreamImportObject();    }


    public interface ProxyObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProxyFluent<io.fabric8.openshift.api.model.TemplateFluent.ProxyObjectsNested<N>> {

            public N and();
            public N endProxyObject();    }


    public interface ProjectObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProjectFluent<io.fabric8.openshift.api.model.TemplateFluent.ProjectObjectsNested<N>> {

            public N and();
            public N endProjectObject();    }


    public interface ClusterOperatorObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterOperatorFluent<io.fabric8.openshift.api.model.TemplateFluent.ClusterOperatorObjectsNested<N>> {

            public N and();
            public N endClusterOperatorObject();    }


    public interface BuildConfigObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildConfigFluent<io.fabric8.openshift.api.model.TemplateFluent.BuildConfigObjectsNested<N>> {

            public N and();
            public N endBuildConfigObject();    }


    public interface InfrastructureObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,InfrastructureFluent<io.fabric8.openshift.api.model.TemplateFluent.InfrastructureObjectsNested<N>> {

            public N and();
            public N endInfrastructureObject();    }


    public interface SchedulerObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SchedulerFluent<io.fabric8.openshift.api.model.TemplateFluent.SchedulerObjectsNested<N>> {

            public N and();
            public N endSchedulerObject();    }


    public interface RangeAllocationObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RangeAllocationFluent<io.fabric8.openshift.api.model.TemplateFluent.RangeAllocationObjectsNested<N>> {

            public N and();
            public N endRangeAllocationObject();    }


    public interface RouteObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RouteFluent<io.fabric8.openshift.api.model.TemplateFluent.RouteObjectsNested<N>> {

            public N and();
            public N endRouteObject();    }


    public interface ClusterNetworkObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterNetworkFluent<io.fabric8.openshift.api.model.TemplateFluent.ClusterNetworkObjectsNested<N>> {

            public N and();
            public N endClusterNetworkObject();    }


    public interface OAuthAuthorizeTokenObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthAuthorizeTokenFluent<io.fabric8.openshift.api.model.TemplateFluent.OAuthAuthorizeTokenObjectsNested<N>> {

            public N and();
            public N endOAuthAuthorizeTokenObject();    }


    public interface IngressObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IngressFluent<io.fabric8.openshift.api.model.TemplateFluent.IngressObjectsNested<N>> {

            public N and();
            public N endIngressObject();    }


    public interface OAuthObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthFluent<io.fabric8.openshift.api.model.TemplateFluent.OAuthObjectsNested<N>> {

            public N and();
            public N endOAuthObject();    }


    public interface OperatorHubObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OperatorHubFluent<io.fabric8.openshift.api.model.TemplateFluent.OperatorHubObjectsNested<N>> {

            public N and();
            public N endOperatorHubObject();    }


    public interface ClusterRoleBindingObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterRoleBindingFluent<io.fabric8.openshift.api.model.TemplateFluent.ClusterRoleBindingObjectsNested<N>> {

            public N and();
            public N endClusterRoleBindingObject();    }


    public interface ClusterResourceQuotaObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterResourceQuotaFluent<io.fabric8.openshift.api.model.TemplateFluent.ClusterResourceQuotaObjectsNested<N>> {

            public N and();
            public N endClusterResourceQuotaObject();    }


    public interface ProjectRequestObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProjectRequestFluent<io.fabric8.openshift.api.model.TemplateFluent.ProjectRequestObjectsNested<N>> {

            public N and();
            public N endProjectRequestObject();    }


    public interface TemplateObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TemplateFluent<io.fabric8.openshift.api.model.TemplateFluent.TemplateObjectsNested<N>> {

            public N and();
            public N endTemplateObject();    }


    public interface OAuthClientAuthorizationObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthClientAuthorizationFluent<io.fabric8.openshift.api.model.TemplateFluent.OAuthClientAuthorizationObjectsNested<N>> {

            public N and();
            public N endOAuthClientAuthorizationObject();    }


    public interface ClusterRoleObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterRoleFluent<io.fabric8.openshift.api.model.TemplateFluent.ClusterRoleObjectsNested<N>> {

            public N and();
            public N endClusterRoleObject();    }


    public interface ImageTagObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageTagFluent<io.fabric8.openshift.api.model.TemplateFluent.ImageTagObjectsNested<N>> {

            public N and();
            public N endImageTagObject();    }


    public interface DeploymentConfigObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeploymentConfigFluent<io.fabric8.openshift.api.model.TemplateFluent.DeploymentConfigObjectsNested<N>> {

            public N and();
            public N endDeploymentConfigObject();    }


    public interface OAuthAccessTokenObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthAccessTokenFluent<io.fabric8.openshift.api.model.TemplateFluent.OAuthAccessTokenObjectsNested<N>> {

            public N and();
            public N endOAuthAccessTokenObject();    }


    public interface RoleBindingObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleBindingFluent<io.fabric8.openshift.api.model.TemplateFluent.RoleBindingObjectsNested<N>> {

            public N and();
            public N endRoleBindingObject();    }


    public interface ImageObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageFluent<io.fabric8.openshift.api.model.TemplateFluent.ImageObjectsNested<N>> {

            public N and();
            public N endImageObject();    }


    public interface APIServerObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,APIServerFluent<io.fabric8.openshift.api.model.TemplateFluent.APIServerObjectsNested<N>> {

            public N and();
            public N endAPIServerObject();    }


    public interface PersistentVolumeClaimObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimFluent<io.fabric8.openshift.api.model.TemplateFluent.PersistentVolumeClaimObjectsNested<N>> {

            public N and();
            public N endPersistentVolumeClaimObject();    }


    public interface ImageStreamMappingObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamMappingFluent<io.fabric8.openshift.api.model.TemplateFluent.ImageStreamMappingObjectsNested<N>> {

            public N and();
            public N endImageStreamMappingObject();    }


    public interface RoleObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleFluent<io.fabric8.openshift.api.model.TemplateFluent.RoleObjectsNested<N>> {

            public N and();
            public N endRoleObject();    }


    public interface FeatureGateObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,FeatureGateFluent<io.fabric8.openshift.api.model.TemplateFluent.FeatureGateObjectsNested<N>> {

            public N and();
            public N endFeatureGateObject();    }


    public interface UserObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,UserFluent<io.fabric8.openshift.api.model.TemplateFluent.UserObjectsNested<N>> {

            public N and();
            public N endUserObject();    }


    public interface ImageStreamImageObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamImageFluent<io.fabric8.openshift.api.model.TemplateFluent.ImageStreamImageObjectsNested<N>> {

            public N and();
            public N endImageStreamImageObject();    }


    public interface BuildObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildFluent<io.fabric8.openshift.api.model.TemplateFluent.BuildObjectsNested<N>> {

            public N and();
            public N endBuildObject();    }


    public interface RoleBindingRestrictionObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleBindingRestrictionFluent<io.fabric8.openshift.api.model.TemplateFluent.RoleBindingRestrictionObjectsNested<N>> {

            public N and();
            public N endRoleBindingRestrictionObject();    }


    public interface ImageStreamTagObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamTagFluent<io.fabric8.openshift.api.model.TemplateFluent.ImageStreamTagObjectsNested<N>> {

            public N and();
            public N endImageStreamTagObject();    }


    public interface GroupObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GroupFluent<io.fabric8.openshift.api.model.TemplateFluent.GroupObjectsNested<N>> {

            public N and();
            public N endGroupObject();    }


    public interface ImageSignatureObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageSignatureFluent<io.fabric8.openshift.api.model.TemplateFluent.ImageSignatureObjectsNested<N>> {

            public N and();
            public N endImageSignatureObject();    }


    public interface AppliedClusterResourceQuotaObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AppliedClusterResourceQuotaFluent<io.fabric8.openshift.api.model.TemplateFluent.AppliedClusterResourceQuotaObjectsNested<N>> {

            public N and();
            public N endAppliedClusterResourceQuotaObject();    }


    public interface SecurityContextConstraintsObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SecurityContextConstraintsFluent<io.fabric8.openshift.api.model.TemplateFluent.SecurityContextConstraintsObjectsNested<N>> {

            public N and();
            public N endSecurityContextConstraintsObject();    }


    public interface BuildRequestObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildRequestFluent<io.fabric8.openshift.api.model.TemplateFluent.BuildRequestObjectsNested<N>> {

            public N and();
            public N endBuildRequestObject();    }


    public interface EgressNetworkPolicyObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EgressNetworkPolicyFluent<io.fabric8.openshift.api.model.TemplateFluent.EgressNetworkPolicyObjectsNested<N>> {

            public N and();
            public N endEgressNetworkPolicyObject();    }


    public interface NetNamespaceObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetNamespaceFluent<io.fabric8.openshift.api.model.TemplateFluent.NetNamespaceObjectsNested<N>> {

            public N and();
            public N endNetNamespaceObject();    }


    public interface ImageStreamObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamFluent<io.fabric8.openshift.api.model.TemplateFluent.ImageStreamObjectsNested<N>> {

            public N and();
            public N endImageStreamObject();    }


    public interface OAuthClientObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthClientFluent<io.fabric8.openshift.api.model.TemplateFluent.OAuthClientObjectsNested<N>> {

            public N and();
            public N endOAuthClientObject();    }


    public interface IdentityObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IdentityFluent<io.fabric8.openshift.api.model.TemplateFluent.IdentityObjectsNested<N>> {

            public N and();
            public N endIdentityObject();    }


    public interface ParametersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ParameterFluent<io.fabric8.openshift.api.model.TemplateFluent.ParametersNested<N>> {

            public N and();
            public N endParameter();    }


}
