package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BuildBuilder extends io.fabric8.openshift.api.model.BuildFluentImpl<io.fabric8.openshift.api.model.BuildBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.Build,io.fabric8.openshift.api.model.BuildBuilder> {

    io.fabric8.openshift.api.model.BuildFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public BuildBuilder() {
        this(true);
    }

    public BuildBuilder(java.lang.Boolean validationEnabled) {
        this(new Build(), validationEnabled);
    }

    public BuildBuilder(io.fabric8.openshift.api.model.BuildFluent<?> fluent) {
        this(fluent, true);
    }

    public BuildBuilder(io.fabric8.openshift.api.model.BuildFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new Build(), validationEnabled);
    }

    public BuildBuilder(io.fabric8.openshift.api.model.BuildFluent<?> fluent,io.fabric8.openshift.api.model.Build instance) {
        this(fluent, instance, true);
    }

    public BuildBuilder(io.fabric8.openshift.api.model.BuildFluent<?> fluent,io.fabric8.openshift.api.model.Build instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public BuildBuilder(io.fabric8.openshift.api.model.Build instance) {
        this(instance,true);
    }

    public BuildBuilder(io.fabric8.openshift.api.model.Build instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.Build build() {
        Build buildable = new Build(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BuildBuilder that = (BuildBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
