package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class WebHookTriggerBuilder extends io.fabric8.openshift.api.model.WebHookTriggerFluentImpl<io.fabric8.openshift.api.model.WebHookTriggerBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.WebHookTrigger,io.fabric8.openshift.api.model.WebHookTriggerBuilder> {

    io.fabric8.openshift.api.model.WebHookTriggerFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public WebHookTriggerBuilder() {
        this(true);
    }

    public WebHookTriggerBuilder(java.lang.Boolean validationEnabled) {
        this(new WebHookTrigger(), validationEnabled);
    }

    public WebHookTriggerBuilder(io.fabric8.openshift.api.model.WebHookTriggerFluent<?> fluent) {
        this(fluent, true);
    }

    public WebHookTriggerBuilder(io.fabric8.openshift.api.model.WebHookTriggerFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new WebHookTrigger(), validationEnabled);
    }

    public WebHookTriggerBuilder(io.fabric8.openshift.api.model.WebHookTriggerFluent<?> fluent,io.fabric8.openshift.api.model.WebHookTrigger instance) {
        this(fluent, instance, true);
    }

    public WebHookTriggerBuilder(io.fabric8.openshift.api.model.WebHookTriggerFluent<?> fluent,io.fabric8.openshift.api.model.WebHookTrigger instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAllowEnv(instance.getAllowEnv()); 
        fluent.withSecret(instance.getSecret()); 
        fluent.withSecretReference(instance.getSecretReference()); 
        this.validationEnabled = validationEnabled; 
    }

    public WebHookTriggerBuilder(io.fabric8.openshift.api.model.WebHookTrigger instance) {
        this(instance,true);
    }

    public WebHookTriggerBuilder(io.fabric8.openshift.api.model.WebHookTrigger instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAllowEnv(instance.getAllowEnv()); 
        this.withSecret(instance.getSecret()); 
        this.withSecretReference(instance.getSecretReference()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.WebHookTrigger build() {
        WebHookTrigger buildable = new WebHookTrigger(fluent.getAllowEnv(),fluent.getSecret(),fluent.getSecretReference());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        WebHookTriggerBuilder that = (WebHookTriggerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
