package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RouteTargetReferenceBuilder extends io.fabric8.openshift.api.model.RouteTargetReferenceFluentImpl<io.fabric8.openshift.api.model.RouteTargetReferenceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.RouteTargetReference,io.fabric8.openshift.api.model.RouteTargetReferenceBuilder> {

    io.fabric8.openshift.api.model.RouteTargetReferenceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public RouteTargetReferenceBuilder() {
        this(true);
    }

    public RouteTargetReferenceBuilder(java.lang.Boolean validationEnabled) {
        this(new RouteTargetReference(), validationEnabled);
    }

    public RouteTargetReferenceBuilder(io.fabric8.openshift.api.model.RouteTargetReferenceFluent<?> fluent) {
        this(fluent, true);
    }

    public RouteTargetReferenceBuilder(io.fabric8.openshift.api.model.RouteTargetReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new RouteTargetReference(), validationEnabled);
    }

    public RouteTargetReferenceBuilder(io.fabric8.openshift.api.model.RouteTargetReferenceFluent<?> fluent,io.fabric8.openshift.api.model.RouteTargetReference instance) {
        this(fluent, instance, true);
    }

    public RouteTargetReferenceBuilder(io.fabric8.openshift.api.model.RouteTargetReferenceFluent<?> fluent,io.fabric8.openshift.api.model.RouteTargetReference instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withKind(instance.getKind()); 
        fluent.withName(instance.getName()); 
        fluent.withWeight(instance.getWeight()); 
        this.validationEnabled = validationEnabled; 
    }

    public RouteTargetReferenceBuilder(io.fabric8.openshift.api.model.RouteTargetReference instance) {
        this(instance,true);
    }

    public RouteTargetReferenceBuilder(io.fabric8.openshift.api.model.RouteTargetReference instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withKind(instance.getKind()); 
        this.withName(instance.getName()); 
        this.withWeight(instance.getWeight()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.RouteTargetReference build() {
        RouteTargetReference buildable = new RouteTargetReference(fluent.getKind(),fluent.getName(),fluent.getWeight());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RouteTargetReferenceBuilder that = (RouteTargetReferenceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
