package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TagEventBuilder extends io.fabric8.openshift.api.model.TagEventFluentImpl<io.fabric8.openshift.api.model.TagEventBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.TagEvent,io.fabric8.openshift.api.model.TagEventBuilder> {

    io.fabric8.openshift.api.model.TagEventFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public TagEventBuilder() {
        this(true);
    }

    public TagEventBuilder(java.lang.Boolean validationEnabled) {
        this(new TagEvent(), validationEnabled);
    }

    public TagEventBuilder(io.fabric8.openshift.api.model.TagEventFluent<?> fluent) {
        this(fluent, true);
    }

    public TagEventBuilder(io.fabric8.openshift.api.model.TagEventFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new TagEvent(), validationEnabled);
    }

    public TagEventBuilder(io.fabric8.openshift.api.model.TagEventFluent<?> fluent,io.fabric8.openshift.api.model.TagEvent instance) {
        this(fluent, instance, true);
    }

    public TagEventBuilder(io.fabric8.openshift.api.model.TagEventFluent<?> fluent,io.fabric8.openshift.api.model.TagEvent instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCreated(instance.getCreated()); 
        fluent.withDockerImageReference(instance.getDockerImageReference()); 
        fluent.withGeneration(instance.getGeneration()); 
        fluent.withImage(instance.getImage()); 
        this.validationEnabled = validationEnabled; 
    }

    public TagEventBuilder(io.fabric8.openshift.api.model.TagEvent instance) {
        this(instance,true);
    }

    public TagEventBuilder(io.fabric8.openshift.api.model.TagEvent instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withCreated(instance.getCreated()); 
        this.withDockerImageReference(instance.getDockerImageReference()); 
        this.withGeneration(instance.getGeneration()); 
        this.withImage(instance.getImage()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.TagEvent build() {
        TagEvent buildable = new TagEvent(fluent.getCreated(),fluent.getDockerImageReference(),fluent.getGeneration(),fluent.getImage());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TagEventBuilder that = (TagEventBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
