package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;

public class CustomBuildStrategyFluentImpl<A extends io.fabric8.openshift.api.model.CustomBuildStrategyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.CustomBuildStrategyFluent<A> {

    private java.lang.String buildAPIVersion;
    private java.util.List<io.fabric8.kubernetes.api.model.EnvVar> env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();
    private java.lang.Boolean exposeDockerSocket;
    private java.lang.Boolean forcePull;
    private io.fabric8.kubernetes.api.model.ObjectReferenceBuilder from;
    private io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder pullSecret;
    private java.util.List<io.fabric8.openshift.api.model.SecretSpecBuilder> secrets =  new java.util.ArrayList<io.fabric8.openshift.api.model.SecretSpecBuilder>();

    public CustomBuildStrategyFluentImpl() {
    }

    public CustomBuildStrategyFluentImpl(io.fabric8.openshift.api.model.CustomBuildStrategy instance) {
        this.withBuildAPIVersion(instance.getBuildAPIVersion()); 
        this.withEnv(instance.getEnv()); 
        this.withExposeDockerSocket(instance.getExposeDockerSocket()); 
        this.withForcePull(instance.getForcePull()); 
        this.withFrom(instance.getFrom()); 
        this.withPullSecret(instance.getPullSecret()); 
        this.withSecrets(instance.getSecrets()); 
    }

    public java.lang.String getBuildAPIVersion() {
        return this.buildAPIVersion;
    }

    public A withBuildAPIVersion(java.lang.String buildAPIVersion) {
        this.buildAPIVersion=buildAPIVersion; return (A) this;
    }

    public java.lang.Boolean hasBuildAPIVersion() {
        return this.buildAPIVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withBuildAPIVersion instead.
     */
        public A withNewBuildAPIVersion(java.lang.String arg0) {
        return (A)withBuildAPIVersion(new String(arg0));
    }

    public A addToEnv(int index,io.fabric8.kubernetes.api.model.EnvVar item) {
        if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
        this.env.add(index, item);
        return (A)this;
    }

    public A setToEnv(int index,io.fabric8.kubernetes.api.model.EnvVar item) {
        if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
        this.env.set(index, item); return (A)this;
    }

    public A addToEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
        if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
        for (io.fabric8.kubernetes.api.model.EnvVar item : items) {this.env.add(item);} return (A)this;
    }

    public A addAllToEnv(java.util.Collection<io.fabric8.kubernetes.api.model.EnvVar> items) {
        if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
        for (io.fabric8.kubernetes.api.model.EnvVar item : items) {this.env.add(item);} return (A)this;
    }

    public A removeFromEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
        for (io.fabric8.kubernetes.api.model.EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
    }

    public A removeAllFromEnv(java.util.Collection<io.fabric8.kubernetes.api.model.EnvVar> items) {
        for (io.fabric8.kubernetes.api.model.EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
    }

    public java.util.List<io.fabric8.kubernetes.api.model.EnvVar> getEnv() {
        return this.env;
    }

    public io.fabric8.kubernetes.api.model.EnvVar getEnv(int index) {
        return this.env.get(index);
    }

    public io.fabric8.kubernetes.api.model.EnvVar getFirstEnv() {
        return this.env.get(0);
    }

    public io.fabric8.kubernetes.api.model.EnvVar getLastEnv() {
        return this.env.get(env.size() - 1);
    }

    public io.fabric8.kubernetes.api.model.EnvVar getMatchingEnv(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvVar> predicate) {
        for (io.fabric8.kubernetes.api.model.EnvVar item: env) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingEnv(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvVar> predicate) {
        for (io.fabric8.kubernetes.api.model.EnvVar item: env) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withEnv(java.util.List<io.fabric8.kubernetes.api.model.EnvVar> env) {
        if (this.env != null) { _visitables.get("env").removeAll(this.env);}
        if (env != null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>(); for (io.fabric8.kubernetes.api.model.EnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
    }

    public A withEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
        if (this.env != null) {this.env.clear();}
        if (env != null) {for (io.fabric8.kubernetes.api.model.EnvVar item :env){ this.addToEnv(item);}} return (A) this;
    }

    public java.lang.Boolean hasEnv() {
        return env != null && !env.isEmpty();
    }

    public java.lang.Boolean getExposeDockerSocket() {
        return this.exposeDockerSocket;
    }

    public A withExposeDockerSocket(java.lang.Boolean exposeDockerSocket) {
        this.exposeDockerSocket=exposeDockerSocket; return (A) this;
    }

    public java.lang.Boolean hasExposeDockerSocket() {
        return this.exposeDockerSocket != null;
    }

    public java.lang.Boolean getForcePull() {
        return this.forcePull;
    }

    public A withForcePull(java.lang.Boolean forcePull) {
        this.forcePull=forcePull; return (A) this;
    }

    public java.lang.Boolean hasForcePull() {
        return this.forcePull != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildFrom instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectReference getFrom() {
        return this.from!=null?this.from.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectReference buildFrom() {
        return this.from!=null?this.from.build():null;
    }

    public A withFrom(io.fabric8.kubernetes.api.model.ObjectReference from) {
        _visitables.get("from").remove(this.from);
        if (from!=null){ this.from= new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(from); _visitables.get("from").add(this.from);} return (A) this;
    }

    public java.lang.Boolean hasFrom() {
        return this.from != null;
    }

    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.FromNested<A> withNewFrom() {
        return new io.fabric8.openshift.api.model.CustomBuildStrategyFluentImpl.FromNestedImpl();
    }

    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.FromNested<A> withNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return new io.fabric8.openshift.api.model.CustomBuildStrategyFluentImpl.FromNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.FromNested<A> editFrom() {
        return withNewFromLike(getFrom());
    }

    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.FromNested<A> editOrNewFrom() {
        return withNewFromLike(getFrom() != null ? getFrom(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.FromNested<A> editOrNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return withNewFromLike(getFrom() != null ? getFrom(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPullSecret instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.LocalObjectReference getPullSecret() {
        return this.pullSecret!=null?this.pullSecret.build():null;
    }

    public io.fabric8.kubernetes.api.model.LocalObjectReference buildPullSecret() {
        return this.pullSecret!=null?this.pullSecret.build():null;
    }

    public A withPullSecret(io.fabric8.kubernetes.api.model.LocalObjectReference pullSecret) {
        _visitables.get("pullSecret").remove(this.pullSecret);
        if (pullSecret!=null){ this.pullSecret= new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(pullSecret); _visitables.get("pullSecret").add(this.pullSecret);} return (A) this;
    }

    public java.lang.Boolean hasPullSecret() {
        return this.pullSecret != null;
    }

    public A withNewPullSecret(java.lang.String name) {
        return (A)withPullSecret(new LocalObjectReference(name));
    }

    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.PullSecretNested<A> withNewPullSecret() {
        return new io.fabric8.openshift.api.model.CustomBuildStrategyFluentImpl.PullSecretNestedImpl();
    }

    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
        return new io.fabric8.openshift.api.model.CustomBuildStrategyFluentImpl.PullSecretNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.PullSecretNested<A> editPullSecret() {
        return withNewPullSecretLike(getPullSecret());
    }

    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecret() {
        return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecretLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
        return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): item);
    }

    public A addToSecrets(int index,io.fabric8.openshift.api.model.SecretSpec item) {
        if (this.secrets == null) {this.secrets = new java.util.ArrayList<io.fabric8.openshift.api.model.SecretSpecBuilder>();}
        io.fabric8.openshift.api.model.SecretSpecBuilder builder = new io.fabric8.openshift.api.model.SecretSpecBuilder(item);_visitables.get("secrets").add(index >= 0 ? index : _visitables.get("secrets").size(), builder);this.secrets.add(index >= 0 ? index : secrets.size(), builder); return (A)this;
    }

    public A setToSecrets(int index,io.fabric8.openshift.api.model.SecretSpec item) {
        if (this.secrets == null) {this.secrets = new java.util.ArrayList<io.fabric8.openshift.api.model.SecretSpecBuilder>();}
        io.fabric8.openshift.api.model.SecretSpecBuilder builder = new io.fabric8.openshift.api.model.SecretSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("secrets").size()) { _visitables.get("secrets").add(builder); } else { _visitables.get("secrets").set(index, builder);}
        if (index < 0 || index >= secrets.size()) { secrets.add(builder); } else { secrets.set(index, builder);}
         return (A)this;
    }

    public A addToSecrets(io.fabric8.openshift.api.model.SecretSpec... items) {
        if (this.secrets == null) {this.secrets = new java.util.ArrayList<io.fabric8.openshift.api.model.SecretSpecBuilder>();}
        for (io.fabric8.openshift.api.model.SecretSpec item : items) {io.fabric8.openshift.api.model.SecretSpecBuilder builder = new io.fabric8.openshift.api.model.SecretSpecBuilder(item);_visitables.get("secrets").add(builder);this.secrets.add(builder);} return (A)this;
    }

    public A addAllToSecrets(java.util.Collection<io.fabric8.openshift.api.model.SecretSpec> items) {
        if (this.secrets == null) {this.secrets = new java.util.ArrayList<io.fabric8.openshift.api.model.SecretSpecBuilder>();}
        for (io.fabric8.openshift.api.model.SecretSpec item : items) {io.fabric8.openshift.api.model.SecretSpecBuilder builder = new io.fabric8.openshift.api.model.SecretSpecBuilder(item);_visitables.get("secrets").add(builder);this.secrets.add(builder);} return (A)this;
    }

    public A removeFromSecrets(io.fabric8.openshift.api.model.SecretSpec... items) {
        for (io.fabric8.openshift.api.model.SecretSpec item : items) {io.fabric8.openshift.api.model.SecretSpecBuilder builder = new io.fabric8.openshift.api.model.SecretSpecBuilder(item);_visitables.get("secrets").remove(builder);if (this.secrets != null) {this.secrets.remove(builder);}} return (A)this;
    }

    public A removeAllFromSecrets(java.util.Collection<io.fabric8.openshift.api.model.SecretSpec> items) {
        for (io.fabric8.openshift.api.model.SecretSpec item : items) {io.fabric8.openshift.api.model.SecretSpecBuilder builder = new io.fabric8.openshift.api.model.SecretSpecBuilder(item);_visitables.get("secrets").remove(builder);if (this.secrets != null) {this.secrets.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSecrets(java.util.function.Predicate<io.fabric8.openshift.api.model.SecretSpecBuilder> predicate) {
        if (secrets == null) return (A) this;
        final Iterator<io.fabric8.openshift.api.model.SecretSpecBuilder> each = secrets.iterator();
        final List visitables = _visitables.get("secrets");
        while (each.hasNext()) {
          io.fabric8.openshift.api.model.SecretSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSecrets instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.openshift.api.model.SecretSpec> getSecrets() {
        return build(secrets);
    }

    public java.util.List<io.fabric8.openshift.api.model.SecretSpec> buildSecrets() {
        return build(secrets);
    }

    public io.fabric8.openshift.api.model.SecretSpec buildSecret(int index) {
        return this.secrets.get(index).build();
    }

    public io.fabric8.openshift.api.model.SecretSpec buildFirstSecret() {
        return this.secrets.get(0).build();
    }

    public io.fabric8.openshift.api.model.SecretSpec buildLastSecret() {
        return this.secrets.get(secrets.size() - 1).build();
    }

    public io.fabric8.openshift.api.model.SecretSpec buildMatchingSecret(java.util.function.Predicate<io.fabric8.openshift.api.model.SecretSpecBuilder> predicate) {
        for (io.fabric8.openshift.api.model.SecretSpecBuilder item: secrets) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingSecret(java.util.function.Predicate<io.fabric8.openshift.api.model.SecretSpecBuilder> predicate) {
        for (io.fabric8.openshift.api.model.SecretSpecBuilder item: secrets) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSecrets(java.util.List<io.fabric8.openshift.api.model.SecretSpec> secrets) {
        if (this.secrets != null) { _visitables.get("secrets").removeAll(this.secrets);}
        if (secrets != null) {this.secrets = new java.util.ArrayList<io.fabric8.openshift.api.model.SecretSpecBuilder>(); for (io.fabric8.openshift.api.model.SecretSpec item : secrets){this.addToSecrets(item);}} else { this.secrets = null;} return (A) this;
    }

    public A withSecrets(io.fabric8.openshift.api.model.SecretSpec... secrets) {
        if (this.secrets != null) {this.secrets.clear();}
        if (secrets != null) {for (io.fabric8.openshift.api.model.SecretSpec item :secrets){ this.addToSecrets(item);}} return (A) this;
    }

    public java.lang.Boolean hasSecrets() {
        return secrets != null && !secrets.isEmpty();
    }

    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.SecretsNested<A> addNewSecret() {
        return new io.fabric8.openshift.api.model.CustomBuildStrategyFluentImpl.SecretsNestedImpl();
    }

    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.SecretsNested<A> addNewSecretLike(io.fabric8.openshift.api.model.SecretSpec item) {
        return new io.fabric8.openshift.api.model.CustomBuildStrategyFluentImpl.SecretsNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.SecretsNested<A> setNewSecretLike(int index,io.fabric8.openshift.api.model.SecretSpec item) {
        return new io.fabric8.openshift.api.model.CustomBuildStrategyFluentImpl.SecretsNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.SecretsNested<A> editSecret(int index) {
        if (secrets.size() <= index) throw new RuntimeException("Can't edit secrets. Index exceeds size.");
        return setNewSecretLike(index, buildSecret(index));
    }

    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.SecretsNested<A> editFirstSecret() {
        if (secrets.size() == 0) throw new RuntimeException("Can't edit first secrets. The list is empty.");
        return setNewSecretLike(0, buildSecret(0));
    }

    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.SecretsNested<A> editLastSecret() {
        int index = secrets.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last secrets. The list is empty.");
        return setNewSecretLike(index, buildSecret(index));
    }

    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.SecretsNested<A> editMatchingSecret(java.util.function.Predicate<io.fabric8.openshift.api.model.SecretSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<secrets.size();i++) { 
        if (predicate.test(secrets.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching secrets. No match found.");
        return setNewSecretLike(index, buildSecret(index));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CustomBuildStrategyFluentImpl that = (CustomBuildStrategyFluentImpl) o;
        if (buildAPIVersion != null ? !buildAPIVersion.equals(that.buildAPIVersion) :that.buildAPIVersion != null) return false;
        if (env != null ? !env.equals(that.env) :that.env != null) return false;
        if (exposeDockerSocket != null ? !exposeDockerSocket.equals(that.exposeDockerSocket) :that.exposeDockerSocket != null) return false;
        if (forcePull != null ? !forcePull.equals(that.forcePull) :that.forcePull != null) return false;
        if (from != null ? !from.equals(that.from) :that.from != null) return false;
        if (pullSecret != null ? !pullSecret.equals(that.pullSecret) :that.pullSecret != null) return false;
        if (secrets != null ? !secrets.equals(that.secrets) :that.secrets != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(buildAPIVersion,  env,  exposeDockerSocket,  forcePull,  from,  pullSecret,  secrets,  super.hashCode());
    }

    public class FromNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<io.fabric8.openshift.api.model.CustomBuildStrategyFluent.FromNested<N>> implements io.fabric8.openshift.api.model.CustomBuildStrategyFluent.FromNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;

            FromNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
                        
            }

            FromNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) CustomBuildStrategyFluentImpl.this.withFrom(builder.build());
            }

            public N endFrom() {
                return and();
            }
    }


    public class PullSecretNestedImpl<N> extends io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl<io.fabric8.openshift.api.model.CustomBuildStrategyFluent.PullSecretNested<N>> implements io.fabric8.openshift.api.model.CustomBuildStrategyFluent.PullSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder;

            PullSecretNestedImpl(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
                this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this, item);
                        
            }

            PullSecretNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) CustomBuildStrategyFluentImpl.this.withPullSecret(builder.build());
            }

            public N endPullSecret() {
                return and();
            }
    }


    public class SecretsNestedImpl<N> extends io.fabric8.openshift.api.model.SecretSpecFluentImpl<io.fabric8.openshift.api.model.CustomBuildStrategyFluent.SecretsNested<N>> implements io.fabric8.openshift.api.model.CustomBuildStrategyFluent.SecretsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.SecretSpecBuilder builder;
        private final int index;

            SecretsNestedImpl(int index,io.fabric8.openshift.api.model.SecretSpec item) {
                this.index = index;
                this.builder = new io.fabric8.openshift.api.model.SecretSpecBuilder(this, item);
                        
            }

            SecretsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.openshift.api.model.SecretSpecBuilder(this);
                        
            }

            public N and() {
                return (N) CustomBuildStrategyFluentImpl.this.setToSecrets(index,builder.build());
            }

            public N endSecret() {
                return and();
            }
    }


}
