package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DockerBuildStrategyBuilder extends io.fabric8.openshift.api.model.DockerBuildStrategyFluentImpl<io.fabric8.openshift.api.model.DockerBuildStrategyBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.DockerBuildStrategy,io.fabric8.openshift.api.model.DockerBuildStrategyBuilder> {

    io.fabric8.openshift.api.model.DockerBuildStrategyFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public DockerBuildStrategyBuilder() {
        this(true);
    }

    public DockerBuildStrategyBuilder(java.lang.Boolean validationEnabled) {
        this(new DockerBuildStrategy(), validationEnabled);
    }

    public DockerBuildStrategyBuilder(io.fabric8.openshift.api.model.DockerBuildStrategyFluent<?> fluent) {
        this(fluent, true);
    }

    public DockerBuildStrategyBuilder(io.fabric8.openshift.api.model.DockerBuildStrategyFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new DockerBuildStrategy(), validationEnabled);
    }

    public DockerBuildStrategyBuilder(io.fabric8.openshift.api.model.DockerBuildStrategyFluent<?> fluent,io.fabric8.openshift.api.model.DockerBuildStrategy instance) {
        this(fluent, instance, true);
    }

    public DockerBuildStrategyBuilder(io.fabric8.openshift.api.model.DockerBuildStrategyFluent<?> fluent,io.fabric8.openshift.api.model.DockerBuildStrategy instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBuildArgs(instance.getBuildArgs()); 
        fluent.withDockerfilePath(instance.getDockerfilePath()); 
        fluent.withEnv(instance.getEnv()); 
        fluent.withForcePull(instance.getForcePull()); 
        fluent.withFrom(instance.getFrom()); 
        fluent.withImageOptimizationPolicy(instance.getImageOptimizationPolicy()); 
        fluent.withNoCache(instance.getNoCache()); 
        fluent.withPullSecret(instance.getPullSecret()); 
        this.validationEnabled = validationEnabled; 
    }

    public DockerBuildStrategyBuilder(io.fabric8.openshift.api.model.DockerBuildStrategy instance) {
        this(instance,true);
    }

    public DockerBuildStrategyBuilder(io.fabric8.openshift.api.model.DockerBuildStrategy instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withBuildArgs(instance.getBuildArgs()); 
        this.withDockerfilePath(instance.getDockerfilePath()); 
        this.withEnv(instance.getEnv()); 
        this.withForcePull(instance.getForcePull()); 
        this.withFrom(instance.getFrom()); 
        this.withImageOptimizationPolicy(instance.getImageOptimizationPolicy()); 
        this.withNoCache(instance.getNoCache()); 
        this.withPullSecret(instance.getPullSecret()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.DockerBuildStrategy build() {
        DockerBuildStrategy buildable = new DockerBuildStrategy(fluent.getBuildArgs(),fluent.getDockerfilePath(),fluent.getEnv(),fluent.getForcePull(),fluent.getFrom(),fluent.getImageOptimizationPolicy(),fluent.getNoCache(),fluent.getPullSecret());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DockerBuildStrategyBuilder that = (DockerBuildStrategyBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
