package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressListBuilder extends io.fabric8.openshift.api.model.IngressListFluentImpl<io.fabric8.openshift.api.model.IngressListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.IngressList,io.fabric8.openshift.api.model.IngressListBuilder> {

    io.fabric8.openshift.api.model.IngressListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public IngressListBuilder() {
        this(true);
    }

    public IngressListBuilder(java.lang.Boolean validationEnabled) {
        this(new IngressList(), validationEnabled);
    }

    public IngressListBuilder(io.fabric8.openshift.api.model.IngressListFluent<?> fluent) {
        this(fluent, true);
    }

    public IngressListBuilder(io.fabric8.openshift.api.model.IngressListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new IngressList(), validationEnabled);
    }

    public IngressListBuilder(io.fabric8.openshift.api.model.IngressListFluent<?> fluent,io.fabric8.openshift.api.model.IngressList instance) {
        this(fluent, instance, true);
    }

    public IngressListBuilder(io.fabric8.openshift.api.model.IngressListFluent<?> fluent,io.fabric8.openshift.api.model.IngressList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressListBuilder(io.fabric8.openshift.api.model.IngressList instance) {
        this(instance,true);
    }

    public IngressListBuilder(io.fabric8.openshift.api.model.IngressList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.IngressList build() {
        IngressList buildable = new IngressList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IngressListBuilder that = (IngressListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
