package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class LDAPIdentityProviderFluentImpl<A extends io.fabric8.openshift.api.model.LDAPIdentityProviderFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.LDAPIdentityProviderFluent<A> {

    private io.fabric8.openshift.api.model.LDAPAttributeMappingBuilder attributes;
    private java.lang.String bindDN;
    private io.fabric8.openshift.api.model.SecretNameReferenceBuilder bindPassword;
    private io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder ca;
    private java.lang.Boolean insecure;
    private java.lang.String url;

    public LDAPIdentityProviderFluentImpl() {
    }

    public LDAPIdentityProviderFluentImpl(io.fabric8.openshift.api.model.LDAPIdentityProvider instance) {
        this.withAttributes(instance.getAttributes()); 
        this.withBindDN(instance.getBindDN()); 
        this.withBindPassword(instance.getBindPassword()); 
        this.withCa(instance.getCa()); 
        this.withInsecure(instance.getInsecure()); 
        this.withUrl(instance.getUrl()); 
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAttributes instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.LDAPAttributeMapping getAttributes() {
        return this.attributes!=null?this.attributes.build():null;
    }

    public io.fabric8.openshift.api.model.LDAPAttributeMapping buildAttributes() {
        return this.attributes!=null?this.attributes.build():null;
    }

    public A withAttributes(io.fabric8.openshift.api.model.LDAPAttributeMapping attributes) {
        _visitables.get("attributes").remove(this.attributes);
        if (attributes!=null){ this.attributes= new io.fabric8.openshift.api.model.LDAPAttributeMappingBuilder(attributes); _visitables.get("attributes").add(this.attributes);} return (A) this;
    }

    public java.lang.Boolean hasAttributes() {
        return this.attributes != null;
    }

    public io.fabric8.openshift.api.model.LDAPIdentityProviderFluent.AttributesNested<A> withNewAttributes() {
        return new io.fabric8.openshift.api.model.LDAPIdentityProviderFluentImpl.AttributesNestedImpl();
    }

    public io.fabric8.openshift.api.model.LDAPIdentityProviderFluent.AttributesNested<A> withNewAttributesLike(io.fabric8.openshift.api.model.LDAPAttributeMapping item) {
        return new io.fabric8.openshift.api.model.LDAPIdentityProviderFluentImpl.AttributesNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.LDAPIdentityProviderFluent.AttributesNested<A> editAttributes() {
        return withNewAttributesLike(getAttributes());
    }

    public io.fabric8.openshift.api.model.LDAPIdentityProviderFluent.AttributesNested<A> editOrNewAttributes() {
        return withNewAttributesLike(getAttributes() != null ? getAttributes(): new io.fabric8.openshift.api.model.LDAPAttributeMappingBuilder().build());
    }

    public io.fabric8.openshift.api.model.LDAPIdentityProviderFluent.AttributesNested<A> editOrNewAttributesLike(io.fabric8.openshift.api.model.LDAPAttributeMapping item) {
        return withNewAttributesLike(getAttributes() != null ? getAttributes(): item);
    }

    public java.lang.String getBindDN() {
        return this.bindDN;
    }

    public A withBindDN(java.lang.String bindDN) {
        this.bindDN=bindDN; return (A) this;
    }

    public java.lang.Boolean hasBindDN() {
        return this.bindDN != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withBindDN instead.
     */
        public A withNewBindDN(java.lang.String arg0) {
        return (A)withBindDN(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildBindPassword instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.SecretNameReference getBindPassword() {
        return this.bindPassword!=null?this.bindPassword.build():null;
    }

    public io.fabric8.openshift.api.model.SecretNameReference buildBindPassword() {
        return this.bindPassword!=null?this.bindPassword.build():null;
    }

    public A withBindPassword(io.fabric8.openshift.api.model.SecretNameReference bindPassword) {
        _visitables.get("bindPassword").remove(this.bindPassword);
        if (bindPassword!=null){ this.bindPassword= new io.fabric8.openshift.api.model.SecretNameReferenceBuilder(bindPassword); _visitables.get("bindPassword").add(this.bindPassword);} return (A) this;
    }

    public java.lang.Boolean hasBindPassword() {
        return this.bindPassword != null;
    }

    public A withNewBindPassword(java.lang.String name) {
        return (A)withBindPassword(new SecretNameReference(name));
    }

    public io.fabric8.openshift.api.model.LDAPIdentityProviderFluent.BindPasswordNested<A> withNewBindPassword() {
        return new io.fabric8.openshift.api.model.LDAPIdentityProviderFluentImpl.BindPasswordNestedImpl();
    }

    public io.fabric8.openshift.api.model.LDAPIdentityProviderFluent.BindPasswordNested<A> withNewBindPasswordLike(io.fabric8.openshift.api.model.SecretNameReference item) {
        return new io.fabric8.openshift.api.model.LDAPIdentityProviderFluentImpl.BindPasswordNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.LDAPIdentityProviderFluent.BindPasswordNested<A> editBindPassword() {
        return withNewBindPasswordLike(getBindPassword());
    }

    public io.fabric8.openshift.api.model.LDAPIdentityProviderFluent.BindPasswordNested<A> editOrNewBindPassword() {
        return withNewBindPasswordLike(getBindPassword() != null ? getBindPassword(): new io.fabric8.openshift.api.model.SecretNameReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.LDAPIdentityProviderFluent.BindPasswordNested<A> editOrNewBindPasswordLike(io.fabric8.openshift.api.model.SecretNameReference item) {
        return withNewBindPasswordLike(getBindPassword() != null ? getBindPassword(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildCa instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.ConfigMapNameReference getCa() {
        return this.ca!=null?this.ca.build():null;
    }

    public io.fabric8.openshift.api.model.ConfigMapNameReference buildCa() {
        return this.ca!=null?this.ca.build():null;
    }

    public A withCa(io.fabric8.openshift.api.model.ConfigMapNameReference ca) {
        _visitables.get("ca").remove(this.ca);
        if (ca!=null){ this.ca= new io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder(ca); _visitables.get("ca").add(this.ca);} return (A) this;
    }

    public java.lang.Boolean hasCa() {
        return this.ca != null;
    }

    public A withNewCa(java.lang.String name) {
        return (A)withCa(new ConfigMapNameReference(name));
    }

    public io.fabric8.openshift.api.model.LDAPIdentityProviderFluent.CaNested<A> withNewCa() {
        return new io.fabric8.openshift.api.model.LDAPIdentityProviderFluentImpl.CaNestedImpl();
    }

    public io.fabric8.openshift.api.model.LDAPIdentityProviderFluent.CaNested<A> withNewCaLike(io.fabric8.openshift.api.model.ConfigMapNameReference item) {
        return new io.fabric8.openshift.api.model.LDAPIdentityProviderFluentImpl.CaNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.LDAPIdentityProviderFluent.CaNested<A> editCa() {
        return withNewCaLike(getCa());
    }

    public io.fabric8.openshift.api.model.LDAPIdentityProviderFluent.CaNested<A> editOrNewCa() {
        return withNewCaLike(getCa() != null ? getCa(): new io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.LDAPIdentityProviderFluent.CaNested<A> editOrNewCaLike(io.fabric8.openshift.api.model.ConfigMapNameReference item) {
        return withNewCaLike(getCa() != null ? getCa(): item);
    }

    public java.lang.Boolean getInsecure() {
        return this.insecure;
    }

    public A withInsecure(java.lang.Boolean insecure) {
        this.insecure=insecure; return (A) this;
    }

    public java.lang.Boolean hasInsecure() {
        return this.insecure != null;
    }

    public java.lang.String getUrl() {
        return this.url;
    }

    public A withUrl(java.lang.String url) {
        this.url=url; return (A) this;
    }

    public java.lang.Boolean hasUrl() {
        return this.url != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withUrl instead.
     */
        public A withNewUrl(java.lang.String arg0) {
        return (A)withUrl(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LDAPIdentityProviderFluentImpl that = (LDAPIdentityProviderFluentImpl) o;
        if (attributes != null ? !attributes.equals(that.attributes) :that.attributes != null) return false;
        if (bindDN != null ? !bindDN.equals(that.bindDN) :that.bindDN != null) return false;
        if (bindPassword != null ? !bindPassword.equals(that.bindPassword) :that.bindPassword != null) return false;
        if (ca != null ? !ca.equals(that.ca) :that.ca != null) return false;
        if (insecure != null ? !insecure.equals(that.insecure) :that.insecure != null) return false;
        if (url != null ? !url.equals(that.url) :that.url != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(attributes,  bindDN,  bindPassword,  ca,  insecure,  url,  super.hashCode());
    }

    public class AttributesNestedImpl<N> extends io.fabric8.openshift.api.model.LDAPAttributeMappingFluentImpl<io.fabric8.openshift.api.model.LDAPIdentityProviderFluent.AttributesNested<N>> implements io.fabric8.openshift.api.model.LDAPIdentityProviderFluent.AttributesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.LDAPAttributeMappingBuilder builder;

            AttributesNestedImpl(io.fabric8.openshift.api.model.LDAPAttributeMapping item) {
                this.builder = new io.fabric8.openshift.api.model.LDAPAttributeMappingBuilder(this, item);
                        
            }

            AttributesNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.LDAPAttributeMappingBuilder(this);
                        
            }

            public N and() {
                return (N) LDAPIdentityProviderFluentImpl.this.withAttributes(builder.build());
            }

            public N endAttributes() {
                return and();
            }
    }


    public class BindPasswordNestedImpl<N> extends io.fabric8.openshift.api.model.SecretNameReferenceFluentImpl<io.fabric8.openshift.api.model.LDAPIdentityProviderFluent.BindPasswordNested<N>> implements io.fabric8.openshift.api.model.LDAPIdentityProviderFluent.BindPasswordNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.SecretNameReferenceBuilder builder;

            BindPasswordNestedImpl(io.fabric8.openshift.api.model.SecretNameReference item) {
                this.builder = new io.fabric8.openshift.api.model.SecretNameReferenceBuilder(this, item);
                        
            }

            BindPasswordNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.SecretNameReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) LDAPIdentityProviderFluentImpl.this.withBindPassword(builder.build());
            }

            public N endBindPassword() {
                return and();
            }
    }


    public class CaNestedImpl<N> extends io.fabric8.openshift.api.model.ConfigMapNameReferenceFluentImpl<io.fabric8.openshift.api.model.LDAPIdentityProviderFluent.CaNested<N>> implements io.fabric8.openshift.api.model.LDAPIdentityProviderFluent.CaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder builder;

            CaNestedImpl(io.fabric8.openshift.api.model.ConfigMapNameReference item) {
                this.builder = new io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder(this, item);
                        
            }

            CaNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) LDAPIdentityProviderFluentImpl.this.withCa(builder.build());
            }

            public N endCa() {
                return and();
            }
    }


}
