package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

public class NetworkSpecFluentImpl<A extends io.fabric8.openshift.api.model.NetworkSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.NetworkSpecFluent<A> {

    private java.util.List<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder> clusterNetwork =  new java.util.ArrayList<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder>();
    private io.fabric8.openshift.api.model.ExternalIPConfigBuilder externalIP;
    private java.lang.String networkType;
    private java.util.List<java.lang.String> serviceNetwork = new java.util.ArrayList<java.lang.String>();
    private java.lang.String serviceNodePortRange;

    public NetworkSpecFluentImpl() {
    }

    public NetworkSpecFluentImpl(io.fabric8.openshift.api.model.NetworkSpec instance) {
        this.withClusterNetwork(instance.getClusterNetwork()); 
        this.withExternalIP(instance.getExternalIP()); 
        this.withNetworkType(instance.getNetworkType()); 
        this.withServiceNetwork(instance.getServiceNetwork()); 
        this.withServiceNodePortRange(instance.getServiceNodePortRange()); 
    }

    public A addToClusterNetwork(int index,io.fabric8.openshift.api.model.ClusterNetworkEntry item) {
        if (this.clusterNetwork == null) {this.clusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder>();}
        io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(index >= 0 ? index : _visitables.get("clusterNetwork").size(), builder);this.clusterNetwork.add(index >= 0 ? index : clusterNetwork.size(), builder); return (A)this;
    }

    public A setToClusterNetwork(int index,io.fabric8.openshift.api.model.ClusterNetworkEntry item) {
        if (this.clusterNetwork == null) {this.clusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder>();}
        io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= _visitables.get("clusterNetwork").size()) { _visitables.get("clusterNetwork").add(builder); } else { _visitables.get("clusterNetwork").set(index, builder);}
        if (index < 0 || index >= clusterNetwork.size()) { clusterNetwork.add(builder); } else { clusterNetwork.set(index, builder);}
         return (A)this;
    }

    public A addToClusterNetwork(io.fabric8.openshift.api.model.ClusterNetworkEntry... items) {
        if (this.clusterNetwork == null) {this.clusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder>();}
        for (io.fabric8.openshift.api.model.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
    }

    public A addAllToClusterNetwork(java.util.Collection<io.fabric8.openshift.api.model.ClusterNetworkEntry> items) {
        if (this.clusterNetwork == null) {this.clusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder>();}
        for (io.fabric8.openshift.api.model.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
    }

    public A removeFromClusterNetwork(io.fabric8.openshift.api.model.ClusterNetworkEntry... items) {
        for (io.fabric8.openshift.api.model.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder);if (this.clusterNetwork != null) {this.clusterNetwork.remove(builder);}} return (A)this;
    }

    public A removeAllFromClusterNetwork(java.util.Collection<io.fabric8.openshift.api.model.ClusterNetworkEntry> items) {
        for (io.fabric8.openshift.api.model.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder);if (this.clusterNetwork != null) {this.clusterNetwork.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder> predicate) {
        if (clusterNetwork == null) return (A) this;
        final Iterator<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder> each = clusterNetwork.iterator();
        final List visitables = _visitables.get("clusterNetwork");
        while (each.hasNext()) {
          io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildClusterNetwork instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.openshift.api.model.ClusterNetworkEntry> getClusterNetwork() {
        return build(clusterNetwork);
    }

    public java.util.List<io.fabric8.openshift.api.model.ClusterNetworkEntry> buildClusterNetwork() {
        return build(clusterNetwork);
    }

    public io.fabric8.openshift.api.model.ClusterNetworkEntry buildClusterNetwork(int index) {
        return this.clusterNetwork.get(index).build();
    }

    public io.fabric8.openshift.api.model.ClusterNetworkEntry buildFirstClusterNetwork() {
        return this.clusterNetwork.get(0).build();
    }

    public io.fabric8.openshift.api.model.ClusterNetworkEntry buildLastClusterNetwork() {
        return this.clusterNetwork.get(clusterNetwork.size() - 1).build();
    }

    public io.fabric8.openshift.api.model.ClusterNetworkEntry buildMatchingClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder> predicate) {
        for (io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder item: clusterNetwork) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder> predicate) {
        for (io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder item: clusterNetwork) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withClusterNetwork(java.util.List<io.fabric8.openshift.api.model.ClusterNetworkEntry> clusterNetwork) {
        if (this.clusterNetwork != null) { _visitables.get("clusterNetwork").removeAll(this.clusterNetwork);}
        if (clusterNetwork != null) {this.clusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder>(); for (io.fabric8.openshift.api.model.ClusterNetworkEntry item : clusterNetwork){this.addToClusterNetwork(item);}} else { this.clusterNetwork = null;} return (A) this;
    }

    public A withClusterNetwork(io.fabric8.openshift.api.model.ClusterNetworkEntry... clusterNetwork) {
        if (this.clusterNetwork != null) {this.clusterNetwork.clear();}
        if (clusterNetwork != null) {for (io.fabric8.openshift.api.model.ClusterNetworkEntry item :clusterNetwork){ this.addToClusterNetwork(item);}} return (A) this;
    }

    public java.lang.Boolean hasClusterNetwork() {
        return clusterNetwork != null && !clusterNetwork.isEmpty();
    }

    public A addNewClusterNetwork(java.lang.String cidr,java.lang.Integer hostSubnetLength) {
        return (A)addToClusterNetwork(new ClusterNetworkEntry(cidr, hostSubnetLength));
    }

    public io.fabric8.openshift.api.model.NetworkSpecFluent.ClusterNetworkNested<A> addNewClusterNetwork() {
        return new io.fabric8.openshift.api.model.NetworkSpecFluentImpl.ClusterNetworkNestedImpl();
    }

    public io.fabric8.openshift.api.model.NetworkSpecFluent.ClusterNetworkNested<A> addNewClusterNetworkLike(io.fabric8.openshift.api.model.ClusterNetworkEntry item) {
        return new io.fabric8.openshift.api.model.NetworkSpecFluentImpl.ClusterNetworkNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.NetworkSpecFluent.ClusterNetworkNested<A> setNewClusterNetworkLike(int index,io.fabric8.openshift.api.model.ClusterNetworkEntry item) {
        return new io.fabric8.openshift.api.model.NetworkSpecFluentImpl.ClusterNetworkNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.NetworkSpecFluent.ClusterNetworkNested<A> editClusterNetwork(int index) {
        if (clusterNetwork.size() <= index) throw new RuntimeException("Can't edit clusterNetwork. Index exceeds size.");
        return setNewClusterNetworkLike(index, buildClusterNetwork(index));
    }

    public io.fabric8.openshift.api.model.NetworkSpecFluent.ClusterNetworkNested<A> editFirstClusterNetwork() {
        if (clusterNetwork.size() == 0) throw new RuntimeException("Can't edit first clusterNetwork. The list is empty.");
        return setNewClusterNetworkLike(0, buildClusterNetwork(0));
    }

    public io.fabric8.openshift.api.model.NetworkSpecFluent.ClusterNetworkNested<A> editLastClusterNetwork() {
        int index = clusterNetwork.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last clusterNetwork. The list is empty.");
        return setNewClusterNetworkLike(index, buildClusterNetwork(index));
    }

    public io.fabric8.openshift.api.model.NetworkSpecFluent.ClusterNetworkNested<A> editMatchingClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder> predicate) {
        int index = -1;
        for (int i=0;i<clusterNetwork.size();i++) { 
        if (predicate.test(clusterNetwork.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching clusterNetwork. No match found.");
        return setNewClusterNetworkLike(index, buildClusterNetwork(index));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildExternalIP instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.ExternalIPConfig getExternalIP() {
        return this.externalIP!=null?this.externalIP.build():null;
    }

    public io.fabric8.openshift.api.model.ExternalIPConfig buildExternalIP() {
        return this.externalIP!=null?this.externalIP.build():null;
    }

    public A withExternalIP(io.fabric8.openshift.api.model.ExternalIPConfig externalIP) {
        _visitables.get("externalIP").remove(this.externalIP);
        if (externalIP!=null){ this.externalIP= new io.fabric8.openshift.api.model.ExternalIPConfigBuilder(externalIP); _visitables.get("externalIP").add(this.externalIP);} return (A) this;
    }

    public java.lang.Boolean hasExternalIP() {
        return this.externalIP != null;
    }

    public io.fabric8.openshift.api.model.NetworkSpecFluent.ExternalIPNested<A> withNewExternalIP() {
        return new io.fabric8.openshift.api.model.NetworkSpecFluentImpl.ExternalIPNestedImpl();
    }

    public io.fabric8.openshift.api.model.NetworkSpecFluent.ExternalIPNested<A> withNewExternalIPLike(io.fabric8.openshift.api.model.ExternalIPConfig item) {
        return new io.fabric8.openshift.api.model.NetworkSpecFluentImpl.ExternalIPNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.NetworkSpecFluent.ExternalIPNested<A> editExternalIP() {
        return withNewExternalIPLike(getExternalIP());
    }

    public io.fabric8.openshift.api.model.NetworkSpecFluent.ExternalIPNested<A> editOrNewExternalIP() {
        return withNewExternalIPLike(getExternalIP() != null ? getExternalIP(): new io.fabric8.openshift.api.model.ExternalIPConfigBuilder().build());
    }

    public io.fabric8.openshift.api.model.NetworkSpecFluent.ExternalIPNested<A> editOrNewExternalIPLike(io.fabric8.openshift.api.model.ExternalIPConfig item) {
        return withNewExternalIPLike(getExternalIP() != null ? getExternalIP(): item);
    }

    public java.lang.String getNetworkType() {
        return this.networkType;
    }

    public A withNetworkType(java.lang.String networkType) {
        this.networkType=networkType; return (A) this;
    }

    public java.lang.Boolean hasNetworkType() {
        return this.networkType != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withNetworkType instead.
     */
        public A withNewNetworkType(java.lang.String arg0) {
        return (A)withNetworkType(new String(arg0));
    }

    public A addToServiceNetwork(int index,java.lang.String item) {
        if (this.serviceNetwork == null) {this.serviceNetwork = new java.util.ArrayList<java.lang.String>();}
        this.serviceNetwork.add(index, item);
        return (A)this;
    }

    public A setToServiceNetwork(int index,java.lang.String item) {
        if (this.serviceNetwork == null) {this.serviceNetwork = new java.util.ArrayList<java.lang.String>();}
        this.serviceNetwork.set(index, item); return (A)this;
    }

    public A addToServiceNetwork(java.lang.String... items) {
        if (this.serviceNetwork == null) {this.serviceNetwork = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.serviceNetwork.add(item);} return (A)this;
    }

    public A addAllToServiceNetwork(java.util.Collection<java.lang.String> items) {
        if (this.serviceNetwork == null) {this.serviceNetwork = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.serviceNetwork.add(item);} return (A)this;
    }

    public A removeFromServiceNetwork(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.serviceNetwork!= null){ this.serviceNetwork.remove(item);}} return (A)this;
    }

    public A removeAllFromServiceNetwork(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.serviceNetwork!= null){ this.serviceNetwork.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getServiceNetwork() {
        return this.serviceNetwork;
    }

    public java.lang.String getServiceNetwork(int index) {
        return this.serviceNetwork.get(index);
    }

    public java.lang.String getFirstServiceNetwork() {
        return this.serviceNetwork.get(0);
    }

    public java.lang.String getLastServiceNetwork() {
        return this.serviceNetwork.get(serviceNetwork.size() - 1);
    }

    public java.lang.String getMatchingServiceNetwork(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: serviceNetwork) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingServiceNetwork(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: serviceNetwork) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withServiceNetwork(java.util.List<java.lang.String> serviceNetwork) {
        if (this.serviceNetwork != null) { _visitables.get("serviceNetwork").removeAll(this.serviceNetwork);}
        if (serviceNetwork != null) {this.serviceNetwork = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : serviceNetwork){this.addToServiceNetwork(item);}} else { this.serviceNetwork = null;} return (A) this;
    }

    public A withServiceNetwork(java.lang.String... serviceNetwork) {
        if (this.serviceNetwork != null) {this.serviceNetwork.clear();}
        if (serviceNetwork != null) {for (java.lang.String item :serviceNetwork){ this.addToServiceNetwork(item);}} return (A) this;
    }

    public java.lang.Boolean hasServiceNetwork() {
        return serviceNetwork != null && !serviceNetwork.isEmpty();
    }

    public A addNewServiceNetwork(java.lang.String arg0) {
        return (A)addToServiceNetwork(new String(arg0));
    }

    public java.lang.String getServiceNodePortRange() {
        return this.serviceNodePortRange;
    }

    public A withServiceNodePortRange(java.lang.String serviceNodePortRange) {
        this.serviceNodePortRange=serviceNodePortRange; return (A) this;
    }

    public java.lang.Boolean hasServiceNodePortRange() {
        return this.serviceNodePortRange != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withServiceNodePortRange instead.
     */
        public A withNewServiceNodePortRange(java.lang.String arg0) {
        return (A)withServiceNodePortRange(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NetworkSpecFluentImpl that = (NetworkSpecFluentImpl) o;
        if (clusterNetwork != null ? !clusterNetwork.equals(that.clusterNetwork) :that.clusterNetwork != null) return false;
        if (externalIP != null ? !externalIP.equals(that.externalIP) :that.externalIP != null) return false;
        if (networkType != null ? !networkType.equals(that.networkType) :that.networkType != null) return false;
        if (serviceNetwork != null ? !serviceNetwork.equals(that.serviceNetwork) :that.serviceNetwork != null) return false;
        if (serviceNodePortRange != null ? !serviceNodePortRange.equals(that.serviceNodePortRange) :that.serviceNodePortRange != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(clusterNetwork,  externalIP,  networkType,  serviceNetwork,  serviceNodePortRange,  super.hashCode());
    }

    public class ClusterNetworkNestedImpl<N> extends io.fabric8.openshift.api.model.ClusterNetworkEntryFluentImpl<io.fabric8.openshift.api.model.NetworkSpecFluent.ClusterNetworkNested<N>> implements io.fabric8.openshift.api.model.NetworkSpecFluent.ClusterNetworkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder builder;
        private final int index;

            ClusterNetworkNestedImpl(int index,io.fabric8.openshift.api.model.ClusterNetworkEntry item) {
                this.index = index;
                this.builder = new io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder(this, item);
                        
            }

            ClusterNetworkNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder(this);
                        
            }

            public N and() {
                return (N) NetworkSpecFluentImpl.this.setToClusterNetwork(index,builder.build());
            }

            public N endClusterNetwork() {
                return and();
            }
    }


    public class ExternalIPNestedImpl<N> extends io.fabric8.openshift.api.model.ExternalIPConfigFluentImpl<io.fabric8.openshift.api.model.NetworkSpecFluent.ExternalIPNested<N>> implements io.fabric8.openshift.api.model.NetworkSpecFluent.ExternalIPNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.ExternalIPConfigBuilder builder;

            ExternalIPNestedImpl(io.fabric8.openshift.api.model.ExternalIPConfig item) {
                this.builder = new io.fabric8.openshift.api.model.ExternalIPConfigBuilder(this, item);
                        
            }

            ExternalIPNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.ExternalIPConfigBuilder(this);
                        
            }

            public N and() {
                return (N) NetworkSpecFluentImpl.this.withExternalIP(builder.build());
            }

            public N endExternalIP() {
                return and();
            }
    }


}
