package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;

public class RollingDeploymentStrategyParamsFluentImpl<A extends io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent<A> {

    private java.lang.Long intervalSeconds;
    private io.fabric8.kubernetes.api.model.IntOrStringBuilder maxSurge;
    private io.fabric8.kubernetes.api.model.IntOrStringBuilder maxUnavailable;
    private io.fabric8.openshift.api.model.LifecycleHookBuilder post;
    private io.fabric8.openshift.api.model.LifecycleHookBuilder pre;
    private java.lang.Long timeoutSeconds;
    private java.lang.Long updatePeriodSeconds;

    public RollingDeploymentStrategyParamsFluentImpl() {
    }

    public RollingDeploymentStrategyParamsFluentImpl(io.fabric8.openshift.api.model.RollingDeploymentStrategyParams instance) {
        this.withIntervalSeconds(instance.getIntervalSeconds()); 
        this.withMaxSurge(instance.getMaxSurge()); 
        this.withMaxUnavailable(instance.getMaxUnavailable()); 
        this.withPost(instance.getPost()); 
        this.withPre(instance.getPre()); 
        this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
        this.withUpdatePeriodSeconds(instance.getUpdatePeriodSeconds()); 
    }

    public java.lang.Long getIntervalSeconds() {
        return this.intervalSeconds;
    }

    public A withIntervalSeconds(java.lang.Long intervalSeconds) {
        this.intervalSeconds=intervalSeconds; return (A) this;
    }

    public java.lang.Boolean hasIntervalSeconds() {
        return this.intervalSeconds != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMaxSurge instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.IntOrString getMaxSurge() {
        return this.maxSurge!=null?this.maxSurge.build():null;
    }

    public io.fabric8.kubernetes.api.model.IntOrString buildMaxSurge() {
        return this.maxSurge!=null?this.maxSurge.build():null;
    }

    public A withMaxSurge(io.fabric8.kubernetes.api.model.IntOrString maxSurge) {
        _visitables.get("maxSurge").remove(this.maxSurge);
        if (maxSurge!=null){ this.maxSurge= new io.fabric8.kubernetes.api.model.IntOrStringBuilder(maxSurge); _visitables.get("maxSurge").add(this.maxSurge);} return (A) this;
    }

    public java.lang.Boolean hasMaxSurge() {
        return this.maxSurge != null;
    }

    public A withNewMaxSurge(java.lang.Integer intVal) {
        return (A)withMaxSurge(new IntOrString(intVal));
    }

    public A withNewMaxSurge(java.lang.String strVal) {
        return (A)withMaxSurge(new IntOrString(strVal));
    }

    public io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.MaxSurgeNested<A> withNewMaxSurge() {
        return new io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluentImpl.MaxSurgeNestedImpl();
    }

    public io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.MaxSurgeNested<A> withNewMaxSurgeLike(io.fabric8.kubernetes.api.model.IntOrString item) {
        return new io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluentImpl.MaxSurgeNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.MaxSurgeNested<A> editMaxSurge() {
        return withNewMaxSurgeLike(getMaxSurge());
    }

    public io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.MaxSurgeNested<A> editOrNewMaxSurge() {
        return withNewMaxSurgeLike(getMaxSurge() != null ? getMaxSurge(): new io.fabric8.kubernetes.api.model.IntOrStringBuilder().build());
    }

    public io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.MaxSurgeNested<A> editOrNewMaxSurgeLike(io.fabric8.kubernetes.api.model.IntOrString item) {
        return withNewMaxSurgeLike(getMaxSurge() != null ? getMaxSurge(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMaxUnavailable instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.IntOrString getMaxUnavailable() {
        return this.maxUnavailable!=null?this.maxUnavailable.build():null;
    }

    public io.fabric8.kubernetes.api.model.IntOrString buildMaxUnavailable() {
        return this.maxUnavailable!=null?this.maxUnavailable.build():null;
    }

    public A withMaxUnavailable(io.fabric8.kubernetes.api.model.IntOrString maxUnavailable) {
        _visitables.get("maxUnavailable").remove(this.maxUnavailable);
        if (maxUnavailable!=null){ this.maxUnavailable= new io.fabric8.kubernetes.api.model.IntOrStringBuilder(maxUnavailable); _visitables.get("maxUnavailable").add(this.maxUnavailable);} return (A) this;
    }

    public java.lang.Boolean hasMaxUnavailable() {
        return this.maxUnavailable != null;
    }

    public A withNewMaxUnavailable(java.lang.Integer intVal) {
        return (A)withMaxUnavailable(new IntOrString(intVal));
    }

    public A withNewMaxUnavailable(java.lang.String strVal) {
        return (A)withMaxUnavailable(new IntOrString(strVal));
    }

    public io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.MaxUnavailableNested<A> withNewMaxUnavailable() {
        return new io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluentImpl.MaxUnavailableNestedImpl();
    }

    public io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.MaxUnavailableNested<A> withNewMaxUnavailableLike(io.fabric8.kubernetes.api.model.IntOrString item) {
        return new io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluentImpl.MaxUnavailableNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.MaxUnavailableNested<A> editMaxUnavailable() {
        return withNewMaxUnavailableLike(getMaxUnavailable());
    }

    public io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.MaxUnavailableNested<A> editOrNewMaxUnavailable() {
        return withNewMaxUnavailableLike(getMaxUnavailable() != null ? getMaxUnavailable(): new io.fabric8.kubernetes.api.model.IntOrStringBuilder().build());
    }

    public io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.MaxUnavailableNested<A> editOrNewMaxUnavailableLike(io.fabric8.kubernetes.api.model.IntOrString item) {
        return withNewMaxUnavailableLike(getMaxUnavailable() != null ? getMaxUnavailable(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPost instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.LifecycleHook getPost() {
        return this.post!=null?this.post.build():null;
    }

    public io.fabric8.openshift.api.model.LifecycleHook buildPost() {
        return this.post!=null?this.post.build():null;
    }

    public A withPost(io.fabric8.openshift.api.model.LifecycleHook post) {
        _visitables.get("post").remove(this.post);
        if (post!=null){ this.post= new io.fabric8.openshift.api.model.LifecycleHookBuilder(post); _visitables.get("post").add(this.post);} return (A) this;
    }

    public java.lang.Boolean hasPost() {
        return this.post != null;
    }

    public io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.PostNested<A> withNewPost() {
        return new io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluentImpl.PostNestedImpl();
    }

    public io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.PostNested<A> withNewPostLike(io.fabric8.openshift.api.model.LifecycleHook item) {
        return new io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluentImpl.PostNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.PostNested<A> editPost() {
        return withNewPostLike(getPost());
    }

    public io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.PostNested<A> editOrNewPost() {
        return withNewPostLike(getPost() != null ? getPost(): new io.fabric8.openshift.api.model.LifecycleHookBuilder().build());
    }

    public io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.PostNested<A> editOrNewPostLike(io.fabric8.openshift.api.model.LifecycleHook item) {
        return withNewPostLike(getPost() != null ? getPost(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPre instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.LifecycleHook getPre() {
        return this.pre!=null?this.pre.build():null;
    }

    public io.fabric8.openshift.api.model.LifecycleHook buildPre() {
        return this.pre!=null?this.pre.build():null;
    }

    public A withPre(io.fabric8.openshift.api.model.LifecycleHook pre) {
        _visitables.get("pre").remove(this.pre);
        if (pre!=null){ this.pre= new io.fabric8.openshift.api.model.LifecycleHookBuilder(pre); _visitables.get("pre").add(this.pre);} return (A) this;
    }

    public java.lang.Boolean hasPre() {
        return this.pre != null;
    }

    public io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.PreNested<A> withNewPre() {
        return new io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluentImpl.PreNestedImpl();
    }

    public io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.PreNested<A> withNewPreLike(io.fabric8.openshift.api.model.LifecycleHook item) {
        return new io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluentImpl.PreNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.PreNested<A> editPre() {
        return withNewPreLike(getPre());
    }

    public io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.PreNested<A> editOrNewPre() {
        return withNewPreLike(getPre() != null ? getPre(): new io.fabric8.openshift.api.model.LifecycleHookBuilder().build());
    }

    public io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.PreNested<A> editOrNewPreLike(io.fabric8.openshift.api.model.LifecycleHook item) {
        return withNewPreLike(getPre() != null ? getPre(): item);
    }

    public java.lang.Long getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public A withTimeoutSeconds(java.lang.Long timeoutSeconds) {
        this.timeoutSeconds=timeoutSeconds; return (A) this;
    }

    public java.lang.Boolean hasTimeoutSeconds() {
        return this.timeoutSeconds != null;
    }

    public java.lang.Long getUpdatePeriodSeconds() {
        return this.updatePeriodSeconds;
    }

    public A withUpdatePeriodSeconds(java.lang.Long updatePeriodSeconds) {
        this.updatePeriodSeconds=updatePeriodSeconds; return (A) this;
    }

    public java.lang.Boolean hasUpdatePeriodSeconds() {
        return this.updatePeriodSeconds != null;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RollingDeploymentStrategyParamsFluentImpl that = (RollingDeploymentStrategyParamsFluentImpl) o;
        if (intervalSeconds != null ? !intervalSeconds.equals(that.intervalSeconds) :that.intervalSeconds != null) return false;
        if (maxSurge != null ? !maxSurge.equals(that.maxSurge) :that.maxSurge != null) return false;
        if (maxUnavailable != null ? !maxUnavailable.equals(that.maxUnavailable) :that.maxUnavailable != null) return false;
        if (post != null ? !post.equals(that.post) :that.post != null) return false;
        if (pre != null ? !pre.equals(that.pre) :that.pre != null) return false;
        if (timeoutSeconds != null ? !timeoutSeconds.equals(that.timeoutSeconds) :that.timeoutSeconds != null) return false;
        if (updatePeriodSeconds != null ? !updatePeriodSeconds.equals(that.updatePeriodSeconds) :that.updatePeriodSeconds != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(intervalSeconds,  maxSurge,  maxUnavailable,  post,  pre,  timeoutSeconds,  updatePeriodSeconds,  super.hashCode());
    }

    public class MaxSurgeNestedImpl<N> extends io.fabric8.kubernetes.api.model.IntOrStringFluentImpl<io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.MaxSurgeNested<N>> implements io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.MaxSurgeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.IntOrStringBuilder builder;

            MaxSurgeNestedImpl(io.fabric8.kubernetes.api.model.IntOrString item) {
                this.builder = new io.fabric8.kubernetes.api.model.IntOrStringBuilder(this, item);
                        
            }

            MaxSurgeNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.IntOrStringBuilder(this);
                        
            }

            public N and() {
                return (N) RollingDeploymentStrategyParamsFluentImpl.this.withMaxSurge(builder.build());
            }

            public N endMaxSurge() {
                return and();
            }
    }


    public class MaxUnavailableNestedImpl<N> extends io.fabric8.kubernetes.api.model.IntOrStringFluentImpl<io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.MaxUnavailableNested<N>> implements io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.MaxUnavailableNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.IntOrStringBuilder builder;

            MaxUnavailableNestedImpl(io.fabric8.kubernetes.api.model.IntOrString item) {
                this.builder = new io.fabric8.kubernetes.api.model.IntOrStringBuilder(this, item);
                        
            }

            MaxUnavailableNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.IntOrStringBuilder(this);
                        
            }

            public N and() {
                return (N) RollingDeploymentStrategyParamsFluentImpl.this.withMaxUnavailable(builder.build());
            }

            public N endMaxUnavailable() {
                return and();
            }
    }


    public class PostNestedImpl<N> extends io.fabric8.openshift.api.model.LifecycleHookFluentImpl<io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.PostNested<N>> implements io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.PostNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.LifecycleHookBuilder builder;

            PostNestedImpl(io.fabric8.openshift.api.model.LifecycleHook item) {
                this.builder = new io.fabric8.openshift.api.model.LifecycleHookBuilder(this, item);
                        
            }

            PostNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.LifecycleHookBuilder(this);
                        
            }

            public N and() {
                return (N) RollingDeploymentStrategyParamsFluentImpl.this.withPost(builder.build());
            }

            public N endPost() {
                return and();
            }
    }


    public class PreNestedImpl<N> extends io.fabric8.openshift.api.model.LifecycleHookFluentImpl<io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.PreNested<N>> implements io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent.PreNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.LifecycleHookBuilder builder;

            PreNestedImpl(io.fabric8.openshift.api.model.LifecycleHook item) {
                this.builder = new io.fabric8.openshift.api.model.LifecycleHookBuilder(this, item);
                        
            }

            PreNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.LifecycleHookBuilder(this);
                        
            }

            public N and() {
                return (N) RollingDeploymentStrategyParamsFluentImpl.this.withPre(builder.build());
            }

            public N endPre() {
                return and();
            }
    }


}
