package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class APIServerServingCertsFluentImpl<A extends io.fabric8.openshift.api.model.APIServerServingCertsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.APIServerServingCertsFluent<A> {

    private java.util.List<io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder> namedCertificates =  new java.util.ArrayList<io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder>();

    public APIServerServingCertsFluentImpl() {
    }

    public APIServerServingCertsFluentImpl(io.fabric8.openshift.api.model.APIServerServingCerts instance) {
        this.withNamedCertificates(instance.getNamedCertificates()); 
    }

    public A addToNamedCertificates(int index,io.fabric8.openshift.api.model.APIServerNamedServingCert item) {
        if (this.namedCertificates == null) {this.namedCertificates = new java.util.ArrayList<io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder>();}
        io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder builder = new io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder(item);_visitables.get("namedCertificates").add(index >= 0 ? index : _visitables.get("namedCertificates").size(), builder);this.namedCertificates.add(index >= 0 ? index : namedCertificates.size(), builder); return (A)this;
    }

    public A setToNamedCertificates(int index,io.fabric8.openshift.api.model.APIServerNamedServingCert item) {
        if (this.namedCertificates == null) {this.namedCertificates = new java.util.ArrayList<io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder>();}
        io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder builder = new io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder(item);
        if (index < 0 || index >= _visitables.get("namedCertificates").size()) { _visitables.get("namedCertificates").add(builder); } else { _visitables.get("namedCertificates").set(index, builder);}
        if (index < 0 || index >= namedCertificates.size()) { namedCertificates.add(builder); } else { namedCertificates.set(index, builder);}
         return (A)this;
    }

    public A addToNamedCertificates(io.fabric8.openshift.api.model.APIServerNamedServingCert... items) {
        if (this.namedCertificates == null) {this.namedCertificates = new java.util.ArrayList<io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder>();}
        for (io.fabric8.openshift.api.model.APIServerNamedServingCert item : items) {io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder builder = new io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder(item);_visitables.get("namedCertificates").add(builder);this.namedCertificates.add(builder);} return (A)this;
    }

    public A addAllToNamedCertificates(java.util.Collection<io.fabric8.openshift.api.model.APIServerNamedServingCert> items) {
        if (this.namedCertificates == null) {this.namedCertificates = new java.util.ArrayList<io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder>();}
        for (io.fabric8.openshift.api.model.APIServerNamedServingCert item : items) {io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder builder = new io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder(item);_visitables.get("namedCertificates").add(builder);this.namedCertificates.add(builder);} return (A)this;
    }

    public A removeFromNamedCertificates(io.fabric8.openshift.api.model.APIServerNamedServingCert... items) {
        for (io.fabric8.openshift.api.model.APIServerNamedServingCert item : items) {io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder builder = new io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder(item);_visitables.get("namedCertificates").remove(builder);if (this.namedCertificates != null) {this.namedCertificates.remove(builder);}} return (A)this;
    }

    public A removeAllFromNamedCertificates(java.util.Collection<io.fabric8.openshift.api.model.APIServerNamedServingCert> items) {
        for (io.fabric8.openshift.api.model.APIServerNamedServingCert item : items) {io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder builder = new io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder(item);_visitables.get("namedCertificates").remove(builder);if (this.namedCertificates != null) {this.namedCertificates.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromNamedCertificates(java.util.function.Predicate<io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder> predicate) {
        if (namedCertificates == null) return (A) this;
        final Iterator<io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder> each = namedCertificates.iterator();
        final List visitables = _visitables.get("namedCertificates");
        while (each.hasNext()) {
          io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildNamedCertificates instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.openshift.api.model.APIServerNamedServingCert> getNamedCertificates() {
        return build(namedCertificates);
    }

    public java.util.List<io.fabric8.openshift.api.model.APIServerNamedServingCert> buildNamedCertificates() {
        return build(namedCertificates);
    }

    public io.fabric8.openshift.api.model.APIServerNamedServingCert buildNamedCertificate(int index) {
        return this.namedCertificates.get(index).build();
    }

    public io.fabric8.openshift.api.model.APIServerNamedServingCert buildFirstNamedCertificate() {
        return this.namedCertificates.get(0).build();
    }

    public io.fabric8.openshift.api.model.APIServerNamedServingCert buildLastNamedCertificate() {
        return this.namedCertificates.get(namedCertificates.size() - 1).build();
    }

    public io.fabric8.openshift.api.model.APIServerNamedServingCert buildMatchingNamedCertificate(java.util.function.Predicate<io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder> predicate) {
        for (io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder item: namedCertificates) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingNamedCertificate(java.util.function.Predicate<io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder> predicate) {
        for (io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder item: namedCertificates) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withNamedCertificates(java.util.List<io.fabric8.openshift.api.model.APIServerNamedServingCert> namedCertificates) {
        if (this.namedCertificates != null) { _visitables.get("namedCertificates").removeAll(this.namedCertificates);}
        if (namedCertificates != null) {this.namedCertificates = new java.util.ArrayList<io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder>(); for (io.fabric8.openshift.api.model.APIServerNamedServingCert item : namedCertificates){this.addToNamedCertificates(item);}} else { this.namedCertificates = null;} return (A) this;
    }

    public A withNamedCertificates(io.fabric8.openshift.api.model.APIServerNamedServingCert... namedCertificates) {
        if (this.namedCertificates != null) {this.namedCertificates.clear();}
        if (namedCertificates != null) {for (io.fabric8.openshift.api.model.APIServerNamedServingCert item :namedCertificates){ this.addToNamedCertificates(item);}} return (A) this;
    }

    public java.lang.Boolean hasNamedCertificates() {
        return namedCertificates != null && !namedCertificates.isEmpty();
    }

    public io.fabric8.openshift.api.model.APIServerServingCertsFluent.NamedCertificatesNested<A> addNewNamedCertificate() {
        return new io.fabric8.openshift.api.model.APIServerServingCertsFluentImpl.NamedCertificatesNestedImpl();
    }

    public io.fabric8.openshift.api.model.APIServerServingCertsFluent.NamedCertificatesNested<A> addNewNamedCertificateLike(io.fabric8.openshift.api.model.APIServerNamedServingCert item) {
        return new io.fabric8.openshift.api.model.APIServerServingCertsFluentImpl.NamedCertificatesNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.APIServerServingCertsFluent.NamedCertificatesNested<A> setNewNamedCertificateLike(int index,io.fabric8.openshift.api.model.APIServerNamedServingCert item) {
        return new io.fabric8.openshift.api.model.APIServerServingCertsFluentImpl.NamedCertificatesNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.APIServerServingCertsFluent.NamedCertificatesNested<A> editNamedCertificate(int index) {
        if (namedCertificates.size() <= index) throw new RuntimeException("Can't edit namedCertificates. Index exceeds size.");
        return setNewNamedCertificateLike(index, buildNamedCertificate(index));
    }

    public io.fabric8.openshift.api.model.APIServerServingCertsFluent.NamedCertificatesNested<A> editFirstNamedCertificate() {
        if (namedCertificates.size() == 0) throw new RuntimeException("Can't edit first namedCertificates. The list is empty.");
        return setNewNamedCertificateLike(0, buildNamedCertificate(0));
    }

    public io.fabric8.openshift.api.model.APIServerServingCertsFluent.NamedCertificatesNested<A> editLastNamedCertificate() {
        int index = namedCertificates.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last namedCertificates. The list is empty.");
        return setNewNamedCertificateLike(index, buildNamedCertificate(index));
    }

    public io.fabric8.openshift.api.model.APIServerServingCertsFluent.NamedCertificatesNested<A> editMatchingNamedCertificate(java.util.function.Predicate<io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder> predicate) {
        int index = -1;
        for (int i=0;i<namedCertificates.size();i++) { 
        if (predicate.test(namedCertificates.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching namedCertificates. No match found.");
        return setNewNamedCertificateLike(index, buildNamedCertificate(index));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        APIServerServingCertsFluentImpl that = (APIServerServingCertsFluentImpl) o;
        if (namedCertificates != null ? !namedCertificates.equals(that.namedCertificates) :that.namedCertificates != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(namedCertificates,  super.hashCode());
    }

    public class NamedCertificatesNestedImpl<N> extends io.fabric8.openshift.api.model.APIServerNamedServingCertFluentImpl<io.fabric8.openshift.api.model.APIServerServingCertsFluent.NamedCertificatesNested<N>> implements io.fabric8.openshift.api.model.APIServerServingCertsFluent.NamedCertificatesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder builder;
        private final int index;

            NamedCertificatesNestedImpl(int index,io.fabric8.openshift.api.model.APIServerNamedServingCert item) {
                this.index = index;
                this.builder = new io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder(this, item);
                        
            }

            NamedCertificatesNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.openshift.api.model.APIServerNamedServingCertBuilder(this);
                        
            }

            public N and() {
                return (N) APIServerServingCertsFluentImpl.this.setToNamedCertificates(index,builder.build());
            }

            public N endNamedCertificate() {
                return and();
            }
    }


}
