package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class APIServerSpecFluentImpl<A extends io.fabric8.openshift.api.model.APIServerSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.APIServerSpecFluent<A> {

    private java.util.List<java.lang.String> additionalCORSAllowedOrigins = new java.util.ArrayList<java.lang.String>();
    private io.fabric8.openshift.api.model.AuditBuilder audit;
    private io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder clientCA;
    private io.fabric8.openshift.api.model.APIServerEncryptionBuilder encryption;
    private io.fabric8.openshift.api.model.APIServerServingCertsBuilder servingCerts;
    private io.fabric8.openshift.api.model.TLSSecurityProfileBuilder tlsSecurityProfile;

    public APIServerSpecFluentImpl() {
    }

    public APIServerSpecFluentImpl(io.fabric8.openshift.api.model.APIServerSpec instance) {
        this.withAdditionalCORSAllowedOrigins(instance.getAdditionalCORSAllowedOrigins()); 
        this.withAudit(instance.getAudit()); 
        this.withClientCA(instance.getClientCA()); 
        this.withEncryption(instance.getEncryption()); 
        this.withServingCerts(instance.getServingCerts()); 
        this.withTlsSecurityProfile(instance.getTlsSecurityProfile()); 
    }

    public A addToAdditionalCORSAllowedOrigins(int index,java.lang.String item) {
        if (this.additionalCORSAllowedOrigins == null) {this.additionalCORSAllowedOrigins = new java.util.ArrayList<java.lang.String>();}
        this.additionalCORSAllowedOrigins.add(index, item);
        return (A)this;
    }

    public A setToAdditionalCORSAllowedOrigins(int index,java.lang.String item) {
        if (this.additionalCORSAllowedOrigins == null) {this.additionalCORSAllowedOrigins = new java.util.ArrayList<java.lang.String>();}
        this.additionalCORSAllowedOrigins.set(index, item); return (A)this;
    }

    public A addToAdditionalCORSAllowedOrigins(java.lang.String... items) {
        if (this.additionalCORSAllowedOrigins == null) {this.additionalCORSAllowedOrigins = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.additionalCORSAllowedOrigins.add(item);} return (A)this;
    }

    public A addAllToAdditionalCORSAllowedOrigins(java.util.Collection<java.lang.String> items) {
        if (this.additionalCORSAllowedOrigins == null) {this.additionalCORSAllowedOrigins = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.additionalCORSAllowedOrigins.add(item);} return (A)this;
    }

    public A removeFromAdditionalCORSAllowedOrigins(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.additionalCORSAllowedOrigins!= null){ this.additionalCORSAllowedOrigins.remove(item);}} return (A)this;
    }

    public A removeAllFromAdditionalCORSAllowedOrigins(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.additionalCORSAllowedOrigins!= null){ this.additionalCORSAllowedOrigins.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getAdditionalCORSAllowedOrigins() {
        return this.additionalCORSAllowedOrigins;
    }

    public java.lang.String getAdditionalCORSAllowedOrigin(int index) {
        return this.additionalCORSAllowedOrigins.get(index);
    }

    public java.lang.String getFirstAdditionalCORSAllowedOrigin() {
        return this.additionalCORSAllowedOrigins.get(0);
    }

    public java.lang.String getLastAdditionalCORSAllowedOrigin() {
        return this.additionalCORSAllowedOrigins.get(additionalCORSAllowedOrigins.size() - 1);
    }

    public java.lang.String getMatchingAdditionalCORSAllowedOrigin(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: additionalCORSAllowedOrigins) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingAdditionalCORSAllowedOrigin(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: additionalCORSAllowedOrigins) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAdditionalCORSAllowedOrigins(java.util.List<java.lang.String> additionalCORSAllowedOrigins) {
        if (this.additionalCORSAllowedOrigins != null) { _visitables.get("additionalCORSAllowedOrigins").removeAll(this.additionalCORSAllowedOrigins);}
        if (additionalCORSAllowedOrigins != null) {this.additionalCORSAllowedOrigins = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : additionalCORSAllowedOrigins){this.addToAdditionalCORSAllowedOrigins(item);}} else { this.additionalCORSAllowedOrigins = null;} return (A) this;
    }

    public A withAdditionalCORSAllowedOrigins(java.lang.String... additionalCORSAllowedOrigins) {
        if (this.additionalCORSAllowedOrigins != null) {this.additionalCORSAllowedOrigins.clear();}
        if (additionalCORSAllowedOrigins != null) {for (java.lang.String item :additionalCORSAllowedOrigins){ this.addToAdditionalCORSAllowedOrigins(item);}} return (A) this;
    }

    public java.lang.Boolean hasAdditionalCORSAllowedOrigins() {
        return additionalCORSAllowedOrigins != null && !additionalCORSAllowedOrigins.isEmpty();
    }

    public A addNewAdditionalCORSAllowedOrigin(java.lang.String arg0) {
        return (A)addToAdditionalCORSAllowedOrigins(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAudit instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.Audit getAudit() {
        return this.audit!=null?this.audit.build():null;
    }

    public io.fabric8.openshift.api.model.Audit buildAudit() {
        return this.audit!=null?this.audit.build():null;
    }

    public A withAudit(io.fabric8.openshift.api.model.Audit audit) {
        _visitables.get("audit").remove(this.audit);
        if (audit!=null){ this.audit= new io.fabric8.openshift.api.model.AuditBuilder(audit); _visitables.get("audit").add(this.audit);} return (A) this;
    }

    public java.lang.Boolean hasAudit() {
        return this.audit != null;
    }

    public A withNewAudit(java.lang.String profile) {
        return (A)withAudit(new Audit(profile));
    }

    public io.fabric8.openshift.api.model.APIServerSpecFluent.AuditNested<A> withNewAudit() {
        return new io.fabric8.openshift.api.model.APIServerSpecFluentImpl.AuditNestedImpl();
    }

    public io.fabric8.openshift.api.model.APIServerSpecFluent.AuditNested<A> withNewAuditLike(io.fabric8.openshift.api.model.Audit item) {
        return new io.fabric8.openshift.api.model.APIServerSpecFluentImpl.AuditNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.APIServerSpecFluent.AuditNested<A> editAudit() {
        return withNewAuditLike(getAudit());
    }

    public io.fabric8.openshift.api.model.APIServerSpecFluent.AuditNested<A> editOrNewAudit() {
        return withNewAuditLike(getAudit() != null ? getAudit(): new io.fabric8.openshift.api.model.AuditBuilder().build());
    }

    public io.fabric8.openshift.api.model.APIServerSpecFluent.AuditNested<A> editOrNewAuditLike(io.fabric8.openshift.api.model.Audit item) {
        return withNewAuditLike(getAudit() != null ? getAudit(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildClientCA instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.ConfigMapNameReference getClientCA() {
        return this.clientCA!=null?this.clientCA.build():null;
    }

    public io.fabric8.openshift.api.model.ConfigMapNameReference buildClientCA() {
        return this.clientCA!=null?this.clientCA.build():null;
    }

    public A withClientCA(io.fabric8.openshift.api.model.ConfigMapNameReference clientCA) {
        _visitables.get("clientCA").remove(this.clientCA);
        if (clientCA!=null){ this.clientCA= new io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder(clientCA); _visitables.get("clientCA").add(this.clientCA);} return (A) this;
    }

    public java.lang.Boolean hasClientCA() {
        return this.clientCA != null;
    }

    public A withNewClientCA(java.lang.String name) {
        return (A)withClientCA(new ConfigMapNameReference(name));
    }

    public io.fabric8.openshift.api.model.APIServerSpecFluent.ClientCANested<A> withNewClientCA() {
        return new io.fabric8.openshift.api.model.APIServerSpecFluentImpl.ClientCANestedImpl();
    }

    public io.fabric8.openshift.api.model.APIServerSpecFluent.ClientCANested<A> withNewClientCALike(io.fabric8.openshift.api.model.ConfigMapNameReference item) {
        return new io.fabric8.openshift.api.model.APIServerSpecFluentImpl.ClientCANestedImpl(item);
    }

    public io.fabric8.openshift.api.model.APIServerSpecFluent.ClientCANested<A> editClientCA() {
        return withNewClientCALike(getClientCA());
    }

    public io.fabric8.openshift.api.model.APIServerSpecFluent.ClientCANested<A> editOrNewClientCA() {
        return withNewClientCALike(getClientCA() != null ? getClientCA(): new io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.APIServerSpecFluent.ClientCANested<A> editOrNewClientCALike(io.fabric8.openshift.api.model.ConfigMapNameReference item) {
        return withNewClientCALike(getClientCA() != null ? getClientCA(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildEncryption instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.APIServerEncryption getEncryption() {
        return this.encryption!=null?this.encryption.build():null;
    }

    public io.fabric8.openshift.api.model.APIServerEncryption buildEncryption() {
        return this.encryption!=null?this.encryption.build():null;
    }

    public A withEncryption(io.fabric8.openshift.api.model.APIServerEncryption encryption) {
        _visitables.get("encryption").remove(this.encryption);
        if (encryption!=null){ this.encryption= new io.fabric8.openshift.api.model.APIServerEncryptionBuilder(encryption); _visitables.get("encryption").add(this.encryption);} return (A) this;
    }

    public java.lang.Boolean hasEncryption() {
        return this.encryption != null;
    }

    public A withNewEncryption(java.lang.String type) {
        return (A)withEncryption(new APIServerEncryption(type));
    }

    public io.fabric8.openshift.api.model.APIServerSpecFluent.EncryptionNested<A> withNewEncryption() {
        return new io.fabric8.openshift.api.model.APIServerSpecFluentImpl.EncryptionNestedImpl();
    }

    public io.fabric8.openshift.api.model.APIServerSpecFluent.EncryptionNested<A> withNewEncryptionLike(io.fabric8.openshift.api.model.APIServerEncryption item) {
        return new io.fabric8.openshift.api.model.APIServerSpecFluentImpl.EncryptionNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.APIServerSpecFluent.EncryptionNested<A> editEncryption() {
        return withNewEncryptionLike(getEncryption());
    }

    public io.fabric8.openshift.api.model.APIServerSpecFluent.EncryptionNested<A> editOrNewEncryption() {
        return withNewEncryptionLike(getEncryption() != null ? getEncryption(): new io.fabric8.openshift.api.model.APIServerEncryptionBuilder().build());
    }

    public io.fabric8.openshift.api.model.APIServerSpecFluent.EncryptionNested<A> editOrNewEncryptionLike(io.fabric8.openshift.api.model.APIServerEncryption item) {
        return withNewEncryptionLike(getEncryption() != null ? getEncryption(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildServingCerts instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.APIServerServingCerts getServingCerts() {
        return this.servingCerts!=null?this.servingCerts.build():null;
    }

    public io.fabric8.openshift.api.model.APIServerServingCerts buildServingCerts() {
        return this.servingCerts!=null?this.servingCerts.build():null;
    }

    public A withServingCerts(io.fabric8.openshift.api.model.APIServerServingCerts servingCerts) {
        _visitables.get("servingCerts").remove(this.servingCerts);
        if (servingCerts!=null){ this.servingCerts= new io.fabric8.openshift.api.model.APIServerServingCertsBuilder(servingCerts); _visitables.get("servingCerts").add(this.servingCerts);} return (A) this;
    }

    public java.lang.Boolean hasServingCerts() {
        return this.servingCerts != null;
    }

    public io.fabric8.openshift.api.model.APIServerSpecFluent.ServingCertsNested<A> withNewServingCerts() {
        return new io.fabric8.openshift.api.model.APIServerSpecFluentImpl.ServingCertsNestedImpl();
    }

    public io.fabric8.openshift.api.model.APIServerSpecFluent.ServingCertsNested<A> withNewServingCertsLike(io.fabric8.openshift.api.model.APIServerServingCerts item) {
        return new io.fabric8.openshift.api.model.APIServerSpecFluentImpl.ServingCertsNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.APIServerSpecFluent.ServingCertsNested<A> editServingCerts() {
        return withNewServingCertsLike(getServingCerts());
    }

    public io.fabric8.openshift.api.model.APIServerSpecFluent.ServingCertsNested<A> editOrNewServingCerts() {
        return withNewServingCertsLike(getServingCerts() != null ? getServingCerts(): new io.fabric8.openshift.api.model.APIServerServingCertsBuilder().build());
    }

    public io.fabric8.openshift.api.model.APIServerSpecFluent.ServingCertsNested<A> editOrNewServingCertsLike(io.fabric8.openshift.api.model.APIServerServingCerts item) {
        return withNewServingCertsLike(getServingCerts() != null ? getServingCerts(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTlsSecurityProfile instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.TLSSecurityProfile getTlsSecurityProfile() {
        return this.tlsSecurityProfile!=null?this.tlsSecurityProfile.build():null;
    }

    public io.fabric8.openshift.api.model.TLSSecurityProfile buildTlsSecurityProfile() {
        return this.tlsSecurityProfile!=null?this.tlsSecurityProfile.build():null;
    }

    public A withTlsSecurityProfile(io.fabric8.openshift.api.model.TLSSecurityProfile tlsSecurityProfile) {
        _visitables.get("tlsSecurityProfile").remove(this.tlsSecurityProfile);
        if (tlsSecurityProfile!=null){ this.tlsSecurityProfile= new io.fabric8.openshift.api.model.TLSSecurityProfileBuilder(tlsSecurityProfile); _visitables.get("tlsSecurityProfile").add(this.tlsSecurityProfile);} return (A) this;
    }

    public java.lang.Boolean hasTlsSecurityProfile() {
        return this.tlsSecurityProfile != null;
    }

    public io.fabric8.openshift.api.model.APIServerSpecFluent.TlsSecurityProfileNested<A> withNewTlsSecurityProfile() {
        return new io.fabric8.openshift.api.model.APIServerSpecFluentImpl.TlsSecurityProfileNestedImpl();
    }

    public io.fabric8.openshift.api.model.APIServerSpecFluent.TlsSecurityProfileNested<A> withNewTlsSecurityProfileLike(io.fabric8.openshift.api.model.TLSSecurityProfile item) {
        return new io.fabric8.openshift.api.model.APIServerSpecFluentImpl.TlsSecurityProfileNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.APIServerSpecFluent.TlsSecurityProfileNested<A> editTlsSecurityProfile() {
        return withNewTlsSecurityProfileLike(getTlsSecurityProfile());
    }

    public io.fabric8.openshift.api.model.APIServerSpecFluent.TlsSecurityProfileNested<A> editOrNewTlsSecurityProfile() {
        return withNewTlsSecurityProfileLike(getTlsSecurityProfile() != null ? getTlsSecurityProfile(): new io.fabric8.openshift.api.model.TLSSecurityProfileBuilder().build());
    }

    public io.fabric8.openshift.api.model.APIServerSpecFluent.TlsSecurityProfileNested<A> editOrNewTlsSecurityProfileLike(io.fabric8.openshift.api.model.TLSSecurityProfile item) {
        return withNewTlsSecurityProfileLike(getTlsSecurityProfile() != null ? getTlsSecurityProfile(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        APIServerSpecFluentImpl that = (APIServerSpecFluentImpl) o;
        if (additionalCORSAllowedOrigins != null ? !additionalCORSAllowedOrigins.equals(that.additionalCORSAllowedOrigins) :that.additionalCORSAllowedOrigins != null) return false;
        if (audit != null ? !audit.equals(that.audit) :that.audit != null) return false;
        if (clientCA != null ? !clientCA.equals(that.clientCA) :that.clientCA != null) return false;
        if (encryption != null ? !encryption.equals(that.encryption) :that.encryption != null) return false;
        if (servingCerts != null ? !servingCerts.equals(that.servingCerts) :that.servingCerts != null) return false;
        if (tlsSecurityProfile != null ? !tlsSecurityProfile.equals(that.tlsSecurityProfile) :that.tlsSecurityProfile != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(additionalCORSAllowedOrigins,  audit,  clientCA,  encryption,  servingCerts,  tlsSecurityProfile,  super.hashCode());
    }

    public class AuditNestedImpl<N> extends io.fabric8.openshift.api.model.AuditFluentImpl<io.fabric8.openshift.api.model.APIServerSpecFluent.AuditNested<N>> implements io.fabric8.openshift.api.model.APIServerSpecFluent.AuditNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.AuditBuilder builder;

            AuditNestedImpl(io.fabric8.openshift.api.model.Audit item) {
                this.builder = new io.fabric8.openshift.api.model.AuditBuilder(this, item);
                        
            }

            AuditNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.AuditBuilder(this);
                        
            }

            public N and() {
                return (N) APIServerSpecFluentImpl.this.withAudit(builder.build());
            }

            public N endAudit() {
                return and();
            }
    }


    public class ClientCANestedImpl<N> extends io.fabric8.openshift.api.model.ConfigMapNameReferenceFluentImpl<io.fabric8.openshift.api.model.APIServerSpecFluent.ClientCANested<N>> implements io.fabric8.openshift.api.model.APIServerSpecFluent.ClientCANested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder builder;

            ClientCANestedImpl(io.fabric8.openshift.api.model.ConfigMapNameReference item) {
                this.builder = new io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder(this, item);
                        
            }

            ClientCANestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) APIServerSpecFluentImpl.this.withClientCA(builder.build());
            }

            public N endClientCA() {
                return and();
            }
    }


    public class EncryptionNestedImpl<N> extends io.fabric8.openshift.api.model.APIServerEncryptionFluentImpl<io.fabric8.openshift.api.model.APIServerSpecFluent.EncryptionNested<N>> implements io.fabric8.openshift.api.model.APIServerSpecFluent.EncryptionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.APIServerEncryptionBuilder builder;

            EncryptionNestedImpl(io.fabric8.openshift.api.model.APIServerEncryption item) {
                this.builder = new io.fabric8.openshift.api.model.APIServerEncryptionBuilder(this, item);
                        
            }

            EncryptionNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.APIServerEncryptionBuilder(this);
                        
            }

            public N and() {
                return (N) APIServerSpecFluentImpl.this.withEncryption(builder.build());
            }

            public N endEncryption() {
                return and();
            }
    }


    public class ServingCertsNestedImpl<N> extends io.fabric8.openshift.api.model.APIServerServingCertsFluentImpl<io.fabric8.openshift.api.model.APIServerSpecFluent.ServingCertsNested<N>> implements io.fabric8.openshift.api.model.APIServerSpecFluent.ServingCertsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.APIServerServingCertsBuilder builder;

            ServingCertsNestedImpl(io.fabric8.openshift.api.model.APIServerServingCerts item) {
                this.builder = new io.fabric8.openshift.api.model.APIServerServingCertsBuilder(this, item);
                        
            }

            ServingCertsNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.APIServerServingCertsBuilder(this);
                        
            }

            public N and() {
                return (N) APIServerSpecFluentImpl.this.withServingCerts(builder.build());
            }

            public N endServingCerts() {
                return and();
            }
    }


    public class TlsSecurityProfileNestedImpl<N> extends io.fabric8.openshift.api.model.TLSSecurityProfileFluentImpl<io.fabric8.openshift.api.model.APIServerSpecFluent.TlsSecurityProfileNested<N>> implements io.fabric8.openshift.api.model.APIServerSpecFluent.TlsSecurityProfileNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.TLSSecurityProfileBuilder builder;

            TlsSecurityProfileNestedImpl(io.fabric8.openshift.api.model.TLSSecurityProfile item) {
                this.builder = new io.fabric8.openshift.api.model.TLSSecurityProfileBuilder(this, item);
                        
            }

            TlsSecurityProfileNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.TLSSecurityProfileBuilder(this);
                        
            }

            public N and() {
                return (N) APIServerSpecFluentImpl.this.withTlsSecurityProfile(builder.build());
            }

            public N endTlsSecurityProfile() {
                return and();
            }
    }


}
