package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BrokerTemplateInstanceBuilder extends io.fabric8.openshift.api.model.BrokerTemplateInstanceFluentImpl<io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.BrokerTemplateInstance,io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder> {

    io.fabric8.openshift.api.model.BrokerTemplateInstanceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public BrokerTemplateInstanceBuilder() {
        this(true);
    }

    public BrokerTemplateInstanceBuilder(java.lang.Boolean validationEnabled) {
        this(new BrokerTemplateInstance(), validationEnabled);
    }

    public BrokerTemplateInstanceBuilder(io.fabric8.openshift.api.model.BrokerTemplateInstanceFluent<?> fluent) {
        this(fluent, true);
    }

    public BrokerTemplateInstanceBuilder(io.fabric8.openshift.api.model.BrokerTemplateInstanceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new BrokerTemplateInstance(), validationEnabled);
    }

    public BrokerTemplateInstanceBuilder(io.fabric8.openshift.api.model.BrokerTemplateInstanceFluent<?> fluent,io.fabric8.openshift.api.model.BrokerTemplateInstance instance) {
        this(fluent, instance, true);
    }

    public BrokerTemplateInstanceBuilder(io.fabric8.openshift.api.model.BrokerTemplateInstanceFluent<?> fluent,io.fabric8.openshift.api.model.BrokerTemplateInstance instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public BrokerTemplateInstanceBuilder(io.fabric8.openshift.api.model.BrokerTemplateInstance instance) {
        this(instance,true);
    }

    public BrokerTemplateInstanceBuilder(io.fabric8.openshift.api.model.BrokerTemplateInstance instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.BrokerTemplateInstance build() {
        BrokerTemplateInstance buildable = new BrokerTemplateInstance(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BrokerTemplateInstanceBuilder that = (BrokerTemplateInstanceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
