package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;

public class BuildOutputFluentImpl<A extends io.fabric8.openshift.api.model.BuildOutputFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.BuildOutputFluent<A> {

    private java.util.List<io.fabric8.openshift.api.model.ImageLabelBuilder> imageLabels =  new java.util.ArrayList<io.fabric8.openshift.api.model.ImageLabelBuilder>();
    private io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder pushSecret;
    private io.fabric8.kubernetes.api.model.ObjectReferenceBuilder to;

    public BuildOutputFluentImpl() {
    }

    public BuildOutputFluentImpl(io.fabric8.openshift.api.model.BuildOutput instance) {
        this.withImageLabels(instance.getImageLabels()); 
        this.withPushSecret(instance.getPushSecret()); 
        this.withTo(instance.getTo()); 
    }

    public A addToImageLabels(int index,io.fabric8.openshift.api.model.ImageLabel item) {
        if (this.imageLabels == null) {this.imageLabels = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageLabelBuilder>();}
        io.fabric8.openshift.api.model.ImageLabelBuilder builder = new io.fabric8.openshift.api.model.ImageLabelBuilder(item);_visitables.get("imageLabels").add(index >= 0 ? index : _visitables.get("imageLabels").size(), builder);this.imageLabels.add(index >= 0 ? index : imageLabels.size(), builder); return (A)this;
    }

    public A setToImageLabels(int index,io.fabric8.openshift.api.model.ImageLabel item) {
        if (this.imageLabels == null) {this.imageLabels = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageLabelBuilder>();}
        io.fabric8.openshift.api.model.ImageLabelBuilder builder = new io.fabric8.openshift.api.model.ImageLabelBuilder(item);
        if (index < 0 || index >= _visitables.get("imageLabels").size()) { _visitables.get("imageLabels").add(builder); } else { _visitables.get("imageLabels").set(index, builder);}
        if (index < 0 || index >= imageLabels.size()) { imageLabels.add(builder); } else { imageLabels.set(index, builder);}
         return (A)this;
    }

    public A addToImageLabels(io.fabric8.openshift.api.model.ImageLabel... items) {
        if (this.imageLabels == null) {this.imageLabels = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageLabelBuilder>();}
        for (io.fabric8.openshift.api.model.ImageLabel item : items) {io.fabric8.openshift.api.model.ImageLabelBuilder builder = new io.fabric8.openshift.api.model.ImageLabelBuilder(item);_visitables.get("imageLabels").add(builder);this.imageLabels.add(builder);} return (A)this;
    }

    public A addAllToImageLabels(java.util.Collection<io.fabric8.openshift.api.model.ImageLabel> items) {
        if (this.imageLabels == null) {this.imageLabels = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageLabelBuilder>();}
        for (io.fabric8.openshift.api.model.ImageLabel item : items) {io.fabric8.openshift.api.model.ImageLabelBuilder builder = new io.fabric8.openshift.api.model.ImageLabelBuilder(item);_visitables.get("imageLabels").add(builder);this.imageLabels.add(builder);} return (A)this;
    }

    public A removeFromImageLabels(io.fabric8.openshift.api.model.ImageLabel... items) {
        for (io.fabric8.openshift.api.model.ImageLabel item : items) {io.fabric8.openshift.api.model.ImageLabelBuilder builder = new io.fabric8.openshift.api.model.ImageLabelBuilder(item);_visitables.get("imageLabels").remove(builder);if (this.imageLabels != null) {this.imageLabels.remove(builder);}} return (A)this;
    }

    public A removeAllFromImageLabels(java.util.Collection<io.fabric8.openshift.api.model.ImageLabel> items) {
        for (io.fabric8.openshift.api.model.ImageLabel item : items) {io.fabric8.openshift.api.model.ImageLabelBuilder builder = new io.fabric8.openshift.api.model.ImageLabelBuilder(item);_visitables.get("imageLabels").remove(builder);if (this.imageLabels != null) {this.imageLabels.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromImageLabels(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageLabelBuilder> predicate) {
        if (imageLabels == null) return (A) this;
        final Iterator<io.fabric8.openshift.api.model.ImageLabelBuilder> each = imageLabels.iterator();
        final List visitables = _visitables.get("imageLabels");
        while (each.hasNext()) {
          io.fabric8.openshift.api.model.ImageLabelBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildImageLabels instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.openshift.api.model.ImageLabel> getImageLabels() {
        return build(imageLabels);
    }

    public java.util.List<io.fabric8.openshift.api.model.ImageLabel> buildImageLabels() {
        return build(imageLabels);
    }

    public io.fabric8.openshift.api.model.ImageLabel buildImageLabel(int index) {
        return this.imageLabels.get(index).build();
    }

    public io.fabric8.openshift.api.model.ImageLabel buildFirstImageLabel() {
        return this.imageLabels.get(0).build();
    }

    public io.fabric8.openshift.api.model.ImageLabel buildLastImageLabel() {
        return this.imageLabels.get(imageLabels.size() - 1).build();
    }

    public io.fabric8.openshift.api.model.ImageLabel buildMatchingImageLabel(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageLabelBuilder> predicate) {
        for (io.fabric8.openshift.api.model.ImageLabelBuilder item: imageLabels) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingImageLabel(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageLabelBuilder> predicate) {
        for (io.fabric8.openshift.api.model.ImageLabelBuilder item: imageLabels) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withImageLabels(java.util.List<io.fabric8.openshift.api.model.ImageLabel> imageLabels) {
        if (this.imageLabels != null) { _visitables.get("imageLabels").removeAll(this.imageLabels);}
        if (imageLabels != null) {this.imageLabels = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageLabelBuilder>(); for (io.fabric8.openshift.api.model.ImageLabel item : imageLabels){this.addToImageLabels(item);}} else { this.imageLabels = null;} return (A) this;
    }

    public A withImageLabels(io.fabric8.openshift.api.model.ImageLabel... imageLabels) {
        if (this.imageLabels != null) {this.imageLabels.clear();}
        if (imageLabels != null) {for (io.fabric8.openshift.api.model.ImageLabel item :imageLabels){ this.addToImageLabels(item);}} return (A) this;
    }

    public java.lang.Boolean hasImageLabels() {
        return imageLabels != null && !imageLabels.isEmpty();
    }

    public A addNewImageLabel(java.lang.String name,java.lang.String value) {
        return (A)addToImageLabels(new ImageLabel(name, value));
    }

    public io.fabric8.openshift.api.model.BuildOutputFluent.ImageLabelsNested<A> addNewImageLabel() {
        return new io.fabric8.openshift.api.model.BuildOutputFluentImpl.ImageLabelsNestedImpl();
    }

    public io.fabric8.openshift.api.model.BuildOutputFluent.ImageLabelsNested<A> addNewImageLabelLike(io.fabric8.openshift.api.model.ImageLabel item) {
        return new io.fabric8.openshift.api.model.BuildOutputFluentImpl.ImageLabelsNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.BuildOutputFluent.ImageLabelsNested<A> setNewImageLabelLike(int index,io.fabric8.openshift.api.model.ImageLabel item) {
        return new io.fabric8.openshift.api.model.BuildOutputFluentImpl.ImageLabelsNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.BuildOutputFluent.ImageLabelsNested<A> editImageLabel(int index) {
        if (imageLabels.size() <= index) throw new RuntimeException("Can't edit imageLabels. Index exceeds size.");
        return setNewImageLabelLike(index, buildImageLabel(index));
    }

    public io.fabric8.openshift.api.model.BuildOutputFluent.ImageLabelsNested<A> editFirstImageLabel() {
        if (imageLabels.size() == 0) throw new RuntimeException("Can't edit first imageLabels. The list is empty.");
        return setNewImageLabelLike(0, buildImageLabel(0));
    }

    public io.fabric8.openshift.api.model.BuildOutputFluent.ImageLabelsNested<A> editLastImageLabel() {
        int index = imageLabels.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last imageLabels. The list is empty.");
        return setNewImageLabelLike(index, buildImageLabel(index));
    }

    public io.fabric8.openshift.api.model.BuildOutputFluent.ImageLabelsNested<A> editMatchingImageLabel(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageLabelBuilder> predicate) {
        int index = -1;
        for (int i=0;i<imageLabels.size();i++) { 
        if (predicate.test(imageLabels.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching imageLabels. No match found.");
        return setNewImageLabelLike(index, buildImageLabel(index));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPushSecret instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.LocalObjectReference getPushSecret() {
        return this.pushSecret!=null?this.pushSecret.build():null;
    }

    public io.fabric8.kubernetes.api.model.LocalObjectReference buildPushSecret() {
        return this.pushSecret!=null?this.pushSecret.build():null;
    }

    public A withPushSecret(io.fabric8.kubernetes.api.model.LocalObjectReference pushSecret) {
        _visitables.get("pushSecret").remove(this.pushSecret);
        if (pushSecret!=null){ this.pushSecret= new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(pushSecret); _visitables.get("pushSecret").add(this.pushSecret);} return (A) this;
    }

    public java.lang.Boolean hasPushSecret() {
        return this.pushSecret != null;
    }

    public A withNewPushSecret(java.lang.String name) {
        return (A)withPushSecret(new LocalObjectReference(name));
    }

    public io.fabric8.openshift.api.model.BuildOutputFluent.PushSecretNested<A> withNewPushSecret() {
        return new io.fabric8.openshift.api.model.BuildOutputFluentImpl.PushSecretNestedImpl();
    }

    public io.fabric8.openshift.api.model.BuildOutputFluent.PushSecretNested<A> withNewPushSecretLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
        return new io.fabric8.openshift.api.model.BuildOutputFluentImpl.PushSecretNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.BuildOutputFluent.PushSecretNested<A> editPushSecret() {
        return withNewPushSecretLike(getPushSecret());
    }

    public io.fabric8.openshift.api.model.BuildOutputFluent.PushSecretNested<A> editOrNewPushSecret() {
        return withNewPushSecretLike(getPushSecret() != null ? getPushSecret(): new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.BuildOutputFluent.PushSecretNested<A> editOrNewPushSecretLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
        return withNewPushSecretLike(getPushSecret() != null ? getPushSecret(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTo instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectReference getTo() {
        return this.to!=null?this.to.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectReference buildTo() {
        return this.to!=null?this.to.build():null;
    }

    public A withTo(io.fabric8.kubernetes.api.model.ObjectReference to) {
        _visitables.get("to").remove(this.to);
        if (to!=null){ this.to= new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(to); _visitables.get("to").add(this.to);} return (A) this;
    }

    public java.lang.Boolean hasTo() {
        return this.to != null;
    }

    public io.fabric8.openshift.api.model.BuildOutputFluent.ToNested<A> withNewTo() {
        return new io.fabric8.openshift.api.model.BuildOutputFluentImpl.ToNestedImpl();
    }

    public io.fabric8.openshift.api.model.BuildOutputFluent.ToNested<A> withNewToLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return new io.fabric8.openshift.api.model.BuildOutputFluentImpl.ToNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.BuildOutputFluent.ToNested<A> editTo() {
        return withNewToLike(getTo());
    }

    public io.fabric8.openshift.api.model.BuildOutputFluent.ToNested<A> editOrNewTo() {
        return withNewToLike(getTo() != null ? getTo(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.BuildOutputFluent.ToNested<A> editOrNewToLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return withNewToLike(getTo() != null ? getTo(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BuildOutputFluentImpl that = (BuildOutputFluentImpl) o;
        if (imageLabels != null ? !imageLabels.equals(that.imageLabels) :that.imageLabels != null) return false;
        if (pushSecret != null ? !pushSecret.equals(that.pushSecret) :that.pushSecret != null) return false;
        if (to != null ? !to.equals(that.to) :that.to != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(imageLabels,  pushSecret,  to,  super.hashCode());
    }

    public class ImageLabelsNestedImpl<N> extends io.fabric8.openshift.api.model.ImageLabelFluentImpl<io.fabric8.openshift.api.model.BuildOutputFluent.ImageLabelsNested<N>> implements io.fabric8.openshift.api.model.BuildOutputFluent.ImageLabelsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.ImageLabelBuilder builder;
        private final int index;

            ImageLabelsNestedImpl(int index,io.fabric8.openshift.api.model.ImageLabel item) {
                this.index = index;
                this.builder = new io.fabric8.openshift.api.model.ImageLabelBuilder(this, item);
                        
            }

            ImageLabelsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.openshift.api.model.ImageLabelBuilder(this);
                        
            }

            public N and() {
                return (N) BuildOutputFluentImpl.this.setToImageLabels(index,builder.build());
            }

            public N endImageLabel() {
                return and();
            }
    }


    public class PushSecretNestedImpl<N> extends io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl<io.fabric8.openshift.api.model.BuildOutputFluent.PushSecretNested<N>> implements io.fabric8.openshift.api.model.BuildOutputFluent.PushSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder;

            PushSecretNestedImpl(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
                this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this, item);
                        
            }

            PushSecretNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) BuildOutputFluentImpl.this.withPushSecret(builder.build());
            }

            public N endPushSecret() {
                return and();
            }
    }


    public class ToNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<io.fabric8.openshift.api.model.BuildOutputFluent.ToNested<N>> implements io.fabric8.openshift.api.model.BuildOutputFluent.ToNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;

            ToNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
                        
            }

            ToNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) BuildOutputFluentImpl.this.withTo(builder.build());
            }

            public N endTo() {
                return and();
            }
    }


}
