package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterOperatorListBuilder extends io.fabric8.openshift.api.model.ClusterOperatorListFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ClusterOperatorList,io.fabric8.openshift.api.model.ClusterOperatorListBuilder> {

    io.fabric8.openshift.api.model.ClusterOperatorListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ClusterOperatorListBuilder() {
        this(true);
    }

    public ClusterOperatorListBuilder(java.lang.Boolean validationEnabled) {
        this(new ClusterOperatorList(), validationEnabled);
    }

    public ClusterOperatorListBuilder(io.fabric8.openshift.api.model.ClusterOperatorListFluent<?> fluent) {
        this(fluent, true);
    }

    public ClusterOperatorListBuilder(io.fabric8.openshift.api.model.ClusterOperatorListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ClusterOperatorList(), validationEnabled);
    }

    public ClusterOperatorListBuilder(io.fabric8.openshift.api.model.ClusterOperatorListFluent<?> fluent,io.fabric8.openshift.api.model.ClusterOperatorList instance) {
        this(fluent, instance, true);
    }

    public ClusterOperatorListBuilder(io.fabric8.openshift.api.model.ClusterOperatorListFluent<?> fluent,io.fabric8.openshift.api.model.ClusterOperatorList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterOperatorListBuilder(io.fabric8.openshift.api.model.ClusterOperatorList instance) {
        this(instance,true);
    }

    public ClusterOperatorListBuilder(io.fabric8.openshift.api.model.ClusterOperatorList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.ClusterOperatorList build() {
        ClusterOperatorList buildable = new ClusterOperatorList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterOperatorListBuilder that = (ClusterOperatorListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
