package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterOperatorStatusBuilder extends io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ClusterOperatorStatus,io.fabric8.openshift.api.model.ClusterOperatorStatusBuilder> {

    io.fabric8.openshift.api.model.ClusterOperatorStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ClusterOperatorStatusBuilder() {
        this(true);
    }

    public ClusterOperatorStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new ClusterOperatorStatus(), validationEnabled);
    }

    public ClusterOperatorStatusBuilder(io.fabric8.openshift.api.model.ClusterOperatorStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public ClusterOperatorStatusBuilder(io.fabric8.openshift.api.model.ClusterOperatorStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ClusterOperatorStatus(), validationEnabled);
    }

    public ClusterOperatorStatusBuilder(io.fabric8.openshift.api.model.ClusterOperatorStatusFluent<?> fluent,io.fabric8.openshift.api.model.ClusterOperatorStatus instance) {
        this(fluent, instance, true);
    }

    public ClusterOperatorStatusBuilder(io.fabric8.openshift.api.model.ClusterOperatorStatusFluent<?> fluent,io.fabric8.openshift.api.model.ClusterOperatorStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConditions(instance.getConditions()); 
        fluent.withExtension(instance.getExtension()); 
        fluent.withRelatedObjects(instance.getRelatedObjects()); 
        fluent.withVersions(instance.getVersions()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterOperatorStatusBuilder(io.fabric8.openshift.api.model.ClusterOperatorStatus instance) {
        this(instance,true);
    }

    public ClusterOperatorStatusBuilder(io.fabric8.openshift.api.model.ClusterOperatorStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withConditions(instance.getConditions()); 
        this.withExtension(instance.getExtension()); 
        this.withRelatedObjects(instance.getRelatedObjects()); 
        this.withVersions(instance.getVersions()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.ClusterOperatorStatus build() {
        ClusterOperatorStatus buildable = new ClusterOperatorStatus(fluent.getConditions(),fluent.getExtension(),fluent.getRelatedObjects(),fluent.getVersions());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterOperatorStatusBuilder that = (ClusterOperatorStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
