package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.rbac.AggregationRule;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.Collection;
import java.lang.Object;

public class ClusterRoleFluentImpl<A extends io.fabric8.openshift.api.model.ClusterRoleFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.ClusterRoleFluent<A> {

    private io.fabric8.kubernetes.api.model.rbac.AggregationRule aggregationRule;
    private java.lang.String apiVersion;
    private java.lang.String kind;
    private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
    private java.util.List<io.fabric8.openshift.api.model.PolicyRuleBuilder> rules =  new java.util.ArrayList<io.fabric8.openshift.api.model.PolicyRuleBuilder>();

    public ClusterRoleFluentImpl() {
    }

    public ClusterRoleFluentImpl(io.fabric8.openshift.api.model.ClusterRole instance) {
        this.withAggregationRule(instance.getAggregationRule()); 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withRules(instance.getRules()); 
    }

    public io.fabric8.kubernetes.api.model.rbac.AggregationRule getAggregationRule() {
        return this.aggregationRule;
    }

    public A withAggregationRule(io.fabric8.kubernetes.api.model.rbac.AggregationRule aggregationRule) {
        this.aggregationRule=aggregationRule; return (A) this;
    }

    public java.lang.Boolean hasAggregationRule() {
        return this.aggregationRule != null;
    }

    public java.lang.String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(java.lang.String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public java.lang.Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0) {
        return (A)withApiVersion(new String(arg0));
    }

    public java.lang.String getKind() {
        return this.kind;
    }

    public A withKind(java.lang.String kind) {
        this.kind=kind; return (A) this;
    }

    public java.lang.Boolean hasKind() {
        return this.kind != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String arg0) {
        return (A)withKind(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetadata instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public java.lang.Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.fabric8.openshift.api.model.ClusterRoleFluent.MetadataNested<A> withNewMetadata() {
        return new io.fabric8.openshift.api.model.ClusterRoleFluentImpl.MetadataNestedImpl();
    }

    public io.fabric8.openshift.api.model.ClusterRoleFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return new io.fabric8.openshift.api.model.ClusterRoleFluentImpl.MetadataNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.ClusterRoleFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.fabric8.openshift.api.model.ClusterRoleFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
    }

    public io.fabric8.openshift.api.model.ClusterRoleFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A addToRules(int index,io.fabric8.openshift.api.model.PolicyRule item) {
        if (this.rules == null) {this.rules = new java.util.ArrayList<io.fabric8.openshift.api.model.PolicyRuleBuilder>();}
        io.fabric8.openshift.api.model.PolicyRuleBuilder builder = new io.fabric8.openshift.api.model.PolicyRuleBuilder(item);_visitables.get("rules").add(index >= 0 ? index : _visitables.get("rules").size(), builder);this.rules.add(index >= 0 ? index : rules.size(), builder); return (A)this;
    }

    public A setToRules(int index,io.fabric8.openshift.api.model.PolicyRule item) {
        if (this.rules == null) {this.rules = new java.util.ArrayList<io.fabric8.openshift.api.model.PolicyRuleBuilder>();}
        io.fabric8.openshift.api.model.PolicyRuleBuilder builder = new io.fabric8.openshift.api.model.PolicyRuleBuilder(item);
        if (index < 0 || index >= _visitables.get("rules").size()) { _visitables.get("rules").add(builder); } else { _visitables.get("rules").set(index, builder);}
        if (index < 0 || index >= rules.size()) { rules.add(builder); } else { rules.set(index, builder);}
         return (A)this;
    }

    public A addToRules(io.fabric8.openshift.api.model.PolicyRule... items) {
        if (this.rules == null) {this.rules = new java.util.ArrayList<io.fabric8.openshift.api.model.PolicyRuleBuilder>();}
        for (io.fabric8.openshift.api.model.PolicyRule item : items) {io.fabric8.openshift.api.model.PolicyRuleBuilder builder = new io.fabric8.openshift.api.model.PolicyRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A addAllToRules(java.util.Collection<io.fabric8.openshift.api.model.PolicyRule> items) {
        if (this.rules == null) {this.rules = new java.util.ArrayList<io.fabric8.openshift.api.model.PolicyRuleBuilder>();}
        for (io.fabric8.openshift.api.model.PolicyRule item : items) {io.fabric8.openshift.api.model.PolicyRuleBuilder builder = new io.fabric8.openshift.api.model.PolicyRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A removeFromRules(io.fabric8.openshift.api.model.PolicyRule... items) {
        for (io.fabric8.openshift.api.model.PolicyRule item : items) {io.fabric8.openshift.api.model.PolicyRuleBuilder builder = new io.fabric8.openshift.api.model.PolicyRuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeAllFromRules(java.util.Collection<io.fabric8.openshift.api.model.PolicyRule> items) {
        for (io.fabric8.openshift.api.model.PolicyRule item : items) {io.fabric8.openshift.api.model.PolicyRuleBuilder builder = new io.fabric8.openshift.api.model.PolicyRuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRules(java.util.function.Predicate<io.fabric8.openshift.api.model.PolicyRuleBuilder> predicate) {
        if (rules == null) return (A) this;
        final Iterator<io.fabric8.openshift.api.model.PolicyRuleBuilder> each = rules.iterator();
        final List visitables = _visitables.get("rules");
        while (each.hasNext()) {
          io.fabric8.openshift.api.model.PolicyRuleBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildRules instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.openshift.api.model.PolicyRule> getRules() {
        return build(rules);
    }

    public java.util.List<io.fabric8.openshift.api.model.PolicyRule> buildRules() {
        return build(rules);
    }

    public io.fabric8.openshift.api.model.PolicyRule buildRule(int index) {
        return this.rules.get(index).build();
    }

    public io.fabric8.openshift.api.model.PolicyRule buildFirstRule() {
        return this.rules.get(0).build();
    }

    public io.fabric8.openshift.api.model.PolicyRule buildLastRule() {
        return this.rules.get(rules.size() - 1).build();
    }

    public io.fabric8.openshift.api.model.PolicyRule buildMatchingRule(java.util.function.Predicate<io.fabric8.openshift.api.model.PolicyRuleBuilder> predicate) {
        for (io.fabric8.openshift.api.model.PolicyRuleBuilder item: rules) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingRule(java.util.function.Predicate<io.fabric8.openshift.api.model.PolicyRuleBuilder> predicate) {
        for (io.fabric8.openshift.api.model.PolicyRuleBuilder item: rules) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withRules(java.util.List<io.fabric8.openshift.api.model.PolicyRule> rules) {
        if (this.rules != null) { _visitables.get("rules").removeAll(this.rules);}
        if (rules != null) {this.rules = new java.util.ArrayList<io.fabric8.openshift.api.model.PolicyRuleBuilder>(); for (io.fabric8.openshift.api.model.PolicyRule item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
    }

    public A withRules(io.fabric8.openshift.api.model.PolicyRule... rules) {
        if (this.rules != null) {this.rules.clear();}
        if (rules != null) {for (io.fabric8.openshift.api.model.PolicyRule item :rules){ this.addToRules(item);}} return (A) this;
    }

    public java.lang.Boolean hasRules() {
        return rules != null && !rules.isEmpty();
    }

    public io.fabric8.openshift.api.model.ClusterRoleFluent.RulesNested<A> addNewRule() {
        return new io.fabric8.openshift.api.model.ClusterRoleFluentImpl.RulesNestedImpl();
    }

    public io.fabric8.openshift.api.model.ClusterRoleFluent.RulesNested<A> addNewRuleLike(io.fabric8.openshift.api.model.PolicyRule item) {
        return new io.fabric8.openshift.api.model.ClusterRoleFluentImpl.RulesNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.ClusterRoleFluent.RulesNested<A> setNewRuleLike(int index,io.fabric8.openshift.api.model.PolicyRule item) {
        return new io.fabric8.openshift.api.model.ClusterRoleFluentImpl.RulesNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.ClusterRoleFluent.RulesNested<A> editRule(int index) {
        if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
        return setNewRuleLike(index, buildRule(index));
    }

    public io.fabric8.openshift.api.model.ClusterRoleFluent.RulesNested<A> editFirstRule() {
        if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
        return setNewRuleLike(0, buildRule(0));
    }

    public io.fabric8.openshift.api.model.ClusterRoleFluent.RulesNested<A> editLastRule() {
        int index = rules.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
        return setNewRuleLike(index, buildRule(index));
    }

    public io.fabric8.openshift.api.model.ClusterRoleFluent.RulesNested<A> editMatchingRule(java.util.function.Predicate<io.fabric8.openshift.api.model.PolicyRuleBuilder> predicate) {
        int index = -1;
        for (int i=0;i<rules.size();i++) { 
        if (predicate.test(rules.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
        return setNewRuleLike(index, buildRule(index));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ClusterRoleFluentImpl that = (ClusterRoleFluentImpl) o;
        if (aggregationRule != null ? !aggregationRule.equals(that.aggregationRule) :that.aggregationRule != null) return false;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(aggregationRule,  apiVersion,  kind,  metadata,  rules,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.openshift.api.model.ClusterRoleFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.ClusterRoleFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;

            MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterRoleFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


    public class RulesNestedImpl<N> extends io.fabric8.openshift.api.model.PolicyRuleFluentImpl<io.fabric8.openshift.api.model.ClusterRoleFluent.RulesNested<N>> implements io.fabric8.openshift.api.model.ClusterRoleFluent.RulesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.PolicyRuleBuilder builder;
        private final int index;

            RulesNestedImpl(int index,io.fabric8.openshift.api.model.PolicyRule item) {
                this.index = index;
                this.builder = new io.fabric8.openshift.api.model.PolicyRuleBuilder(this, item);
                        
            }

            RulesNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.openshift.api.model.PolicyRuleBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterRoleFluentImpl.this.setToRules(index,builder.build());
            }

            public N endRule() {
                return and();
            }
    }


}
