package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterRoleListBuilder extends io.fabric8.openshift.api.model.ClusterRoleListFluentImpl<io.fabric8.openshift.api.model.ClusterRoleListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ClusterRoleList,io.fabric8.openshift.api.model.ClusterRoleListBuilder> {

    io.fabric8.openshift.api.model.ClusterRoleListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ClusterRoleListBuilder() {
        this(true);
    }

    public ClusterRoleListBuilder(java.lang.Boolean validationEnabled) {
        this(new ClusterRoleList(), validationEnabled);
    }

    public ClusterRoleListBuilder(io.fabric8.openshift.api.model.ClusterRoleListFluent<?> fluent) {
        this(fluent, true);
    }

    public ClusterRoleListBuilder(io.fabric8.openshift.api.model.ClusterRoleListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ClusterRoleList(), validationEnabled);
    }

    public ClusterRoleListBuilder(io.fabric8.openshift.api.model.ClusterRoleListFluent<?> fluent,io.fabric8.openshift.api.model.ClusterRoleList instance) {
        this(fluent, instance, true);
    }

    public ClusterRoleListBuilder(io.fabric8.openshift.api.model.ClusterRoleListFluent<?> fluent,io.fabric8.openshift.api.model.ClusterRoleList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterRoleListBuilder(io.fabric8.openshift.api.model.ClusterRoleList instance) {
        this(instance,true);
    }

    public ClusterRoleListBuilder(io.fabric8.openshift.api.model.ClusterRoleList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.ClusterRoleList build() {
        ClusterRoleList buildable = new ClusterRoleList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterRoleListBuilder that = (ClusterRoleListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
