package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleSpecBuilder extends io.fabric8.openshift.api.model.ConsoleSpecFluentImpl<io.fabric8.openshift.api.model.ConsoleSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ConsoleSpec,io.fabric8.openshift.api.model.ConsoleSpecBuilder> {

    io.fabric8.openshift.api.model.ConsoleSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ConsoleSpecBuilder() {
        this(true);
    }

    public ConsoleSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new ConsoleSpec(), validationEnabled);
    }

    public ConsoleSpecBuilder(io.fabric8.openshift.api.model.ConsoleSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public ConsoleSpecBuilder(io.fabric8.openshift.api.model.ConsoleSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ConsoleSpec(), validationEnabled);
    }

    public ConsoleSpecBuilder(io.fabric8.openshift.api.model.ConsoleSpecFluent<?> fluent,io.fabric8.openshift.api.model.ConsoleSpec instance) {
        this(fluent, instance, true);
    }

    public ConsoleSpecBuilder(io.fabric8.openshift.api.model.ConsoleSpecFluent<?> fluent,io.fabric8.openshift.api.model.ConsoleSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAuthentication(instance.getAuthentication()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConsoleSpecBuilder(io.fabric8.openshift.api.model.ConsoleSpec instance) {
        this(instance,true);
    }

    public ConsoleSpecBuilder(io.fabric8.openshift.api.model.ConsoleSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAuthentication(instance.getAuthentication()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.ConsoleSpec build() {
        ConsoleSpec buildable = new ConsoleSpec(fluent.getAuthentication());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConsoleSpecBuilder that = (ConsoleSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
