package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class DeploymentConfigSpecFluentImpl<A extends io.fabric8.openshift.api.model.DeploymentConfigSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.DeploymentConfigSpecFluent<A> {

    private java.lang.Integer minReadySeconds;
    private java.lang.Boolean paused;
    private java.lang.Integer replicas;
    private java.lang.Integer revisionHistoryLimit;
    private java.util.Map<java.lang.String,java.lang.String> selector;
    private io.fabric8.openshift.api.model.DeploymentStrategyBuilder strategy;
    private io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder template;
    private java.lang.Boolean test;
    private java.util.List<io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder> triggers =  new java.util.ArrayList<io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder>();

    public DeploymentConfigSpecFluentImpl() {
    }

    public DeploymentConfigSpecFluentImpl(io.fabric8.openshift.api.model.DeploymentConfigSpec instance) {
        this.withMinReadySeconds(instance.getMinReadySeconds()); 
        this.withPaused(instance.getPaused()); 
        this.withReplicas(instance.getReplicas()); 
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit()); 
        this.withSelector(instance.getSelector()); 
        this.withStrategy(instance.getStrategy()); 
        this.withTemplate(instance.getTemplate()); 
        this.withTest(instance.getTest()); 
        this.withTriggers(instance.getTriggers()); 
    }

    public java.lang.Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public A withMinReadySeconds(java.lang.Integer minReadySeconds) {
        this.minReadySeconds=minReadySeconds; return (A) this;
    }

    public java.lang.Boolean hasMinReadySeconds() {
        return this.minReadySeconds != null;
    }

    public java.lang.Boolean getPaused() {
        return this.paused;
    }

    public A withPaused(java.lang.Boolean paused) {
        this.paused=paused; return (A) this;
    }

    public java.lang.Boolean hasPaused() {
        return this.paused != null;
    }

    public java.lang.Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(java.lang.Integer replicas) {
        this.replicas=replicas; return (A) this;
    }

    public java.lang.Boolean hasReplicas() {
        return this.replicas != null;
    }

    public java.lang.Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    public A withRevisionHistoryLimit(java.lang.Integer revisionHistoryLimit) {
        this.revisionHistoryLimit=revisionHistoryLimit; return (A) this;
    }

    public java.lang.Boolean hasRevisionHistoryLimit() {
        return this.revisionHistoryLimit != null;
    }

    public A addToSelector(java.lang.String key,java.lang.String value) {
        if(this.selector == null && key != null && value != null) { this.selector = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(key != null && value != null) {this.selector.put(key, value);} return (A)this;
    }

    public A addToSelector(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.selector == null && map != null) { this.selector = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(map != null) { this.selector.putAll(map);} return (A)this;
    }

    public A removeFromSelector(java.lang.String key) {
        if(this.selector == null) { return (A) this; }
        if(key != null && this.selector != null) {this.selector.remove(key);} return (A)this;
    }

    public A removeFromSelector(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.selector == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.selector != null){this.selector.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.lang.String> getSelector() {
        return this.selector;
    }

    public <K,V>A withSelector(java.util.Map<java.lang.String,java.lang.String> selector) {
        if (selector == null) { this.selector =  null;} else {this.selector = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(selector);} return (A) this;
    }

    public java.lang.Boolean hasSelector() {
        return this.selector != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildStrategy instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.DeploymentStrategy getStrategy() {
        return this.strategy!=null?this.strategy.build():null;
    }

    public io.fabric8.openshift.api.model.DeploymentStrategy buildStrategy() {
        return this.strategy!=null?this.strategy.build():null;
    }

    public A withStrategy(io.fabric8.openshift.api.model.DeploymentStrategy strategy) {
        _visitables.get("strategy").remove(this.strategy);
        if (strategy!=null){ this.strategy= new io.fabric8.openshift.api.model.DeploymentStrategyBuilder(strategy); _visitables.get("strategy").add(this.strategy);} return (A) this;
    }

    public java.lang.Boolean hasStrategy() {
        return this.strategy != null;
    }

    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.StrategyNested<A> withNewStrategy() {
        return new io.fabric8.openshift.api.model.DeploymentConfigSpecFluentImpl.StrategyNestedImpl();
    }

    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.StrategyNested<A> withNewStrategyLike(io.fabric8.openshift.api.model.DeploymentStrategy item) {
        return new io.fabric8.openshift.api.model.DeploymentConfigSpecFluentImpl.StrategyNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.StrategyNested<A> editStrategy() {
        return withNewStrategyLike(getStrategy());
    }

    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.StrategyNested<A> editOrNewStrategy() {
        return withNewStrategyLike(getStrategy() != null ? getStrategy(): new io.fabric8.openshift.api.model.DeploymentStrategyBuilder().build());
    }

    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.StrategyNested<A> editOrNewStrategyLike(io.fabric8.openshift.api.model.DeploymentStrategy item) {
        return withNewStrategyLike(getStrategy() != null ? getStrategy(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTemplate instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.PodTemplateSpec getTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public io.fabric8.kubernetes.api.model.PodTemplateSpec buildTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public A withTemplate(io.fabric8.kubernetes.api.model.PodTemplateSpec template) {
        _visitables.get("template").remove(this.template);
        if (template!=null){ this.template= new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public java.lang.Boolean hasTemplate() {
        return this.template != null;
    }

    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TemplateNested<A> withNewTemplate() {
        return new io.fabric8.openshift.api.model.DeploymentConfigSpecFluentImpl.TemplateNestedImpl();
    }

    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TemplateNested<A> withNewTemplateLike(io.fabric8.kubernetes.api.model.PodTemplateSpec item) {
        return new io.fabric8.openshift.api.model.DeploymentConfigSpecFluentImpl.TemplateNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TemplateNested<A> editTemplate() {
        return withNewTemplateLike(getTemplate());
    }

    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder().build());
    }

    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.fabric8.kubernetes.api.model.PodTemplateSpec item) {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public java.lang.Boolean getTest() {
        return this.test;
    }

    public A withTest(java.lang.Boolean test) {
        this.test=test; return (A) this;
    }

    public java.lang.Boolean hasTest() {
        return this.test != null;
    }

    public A addToTriggers(int index,io.fabric8.openshift.api.model.DeploymentTriggerPolicy item) {
        if (this.triggers == null) {this.triggers = new java.util.ArrayList<io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder>();}
        io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder builder = new io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder(item);_visitables.get("triggers").add(index >= 0 ? index : _visitables.get("triggers").size(), builder);this.triggers.add(index >= 0 ? index : triggers.size(), builder); return (A)this;
    }

    public A setToTriggers(int index,io.fabric8.openshift.api.model.DeploymentTriggerPolicy item) {
        if (this.triggers == null) {this.triggers = new java.util.ArrayList<io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder>();}
        io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder builder = new io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder(item);
        if (index < 0 || index >= _visitables.get("triggers").size()) { _visitables.get("triggers").add(builder); } else { _visitables.get("triggers").set(index, builder);}
        if (index < 0 || index >= triggers.size()) { triggers.add(builder); } else { triggers.set(index, builder);}
         return (A)this;
    }

    public A addToTriggers(io.fabric8.openshift.api.model.DeploymentTriggerPolicy... items) {
        if (this.triggers == null) {this.triggers = new java.util.ArrayList<io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder>();}
        for (io.fabric8.openshift.api.model.DeploymentTriggerPolicy item : items) {io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder builder = new io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder(item);_visitables.get("triggers").add(builder);this.triggers.add(builder);} return (A)this;
    }

    public A addAllToTriggers(java.util.Collection<io.fabric8.openshift.api.model.DeploymentTriggerPolicy> items) {
        if (this.triggers == null) {this.triggers = new java.util.ArrayList<io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder>();}
        for (io.fabric8.openshift.api.model.DeploymentTriggerPolicy item : items) {io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder builder = new io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder(item);_visitables.get("triggers").add(builder);this.triggers.add(builder);} return (A)this;
    }

    public A removeFromTriggers(io.fabric8.openshift.api.model.DeploymentTriggerPolicy... items) {
        for (io.fabric8.openshift.api.model.DeploymentTriggerPolicy item : items) {io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder builder = new io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder(item);_visitables.get("triggers").remove(builder);if (this.triggers != null) {this.triggers.remove(builder);}} return (A)this;
    }

    public A removeAllFromTriggers(java.util.Collection<io.fabric8.openshift.api.model.DeploymentTriggerPolicy> items) {
        for (io.fabric8.openshift.api.model.DeploymentTriggerPolicy item : items) {io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder builder = new io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder(item);_visitables.get("triggers").remove(builder);if (this.triggers != null) {this.triggers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTriggers(java.util.function.Predicate<io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder> predicate) {
        if (triggers == null) return (A) this;
        final Iterator<io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder> each = triggers.iterator();
        final List visitables = _visitables.get("triggers");
        while (each.hasNext()) {
          io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTriggers instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.openshift.api.model.DeploymentTriggerPolicy> getTriggers() {
        return build(triggers);
    }

    public java.util.List<io.fabric8.openshift.api.model.DeploymentTriggerPolicy> buildTriggers() {
        return build(triggers);
    }

    public io.fabric8.openshift.api.model.DeploymentTriggerPolicy buildTrigger(int index) {
        return this.triggers.get(index).build();
    }

    public io.fabric8.openshift.api.model.DeploymentTriggerPolicy buildFirstTrigger() {
        return this.triggers.get(0).build();
    }

    public io.fabric8.openshift.api.model.DeploymentTriggerPolicy buildLastTrigger() {
        return this.triggers.get(triggers.size() - 1).build();
    }

    public io.fabric8.openshift.api.model.DeploymentTriggerPolicy buildMatchingTrigger(java.util.function.Predicate<io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder> predicate) {
        for (io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder item: triggers) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingTrigger(java.util.function.Predicate<io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder> predicate) {
        for (io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder item: triggers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTriggers(java.util.List<io.fabric8.openshift.api.model.DeploymentTriggerPolicy> triggers) {
        if (this.triggers != null) { _visitables.get("triggers").removeAll(this.triggers);}
        if (triggers != null) {this.triggers = new java.util.ArrayList<io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder>(); for (io.fabric8.openshift.api.model.DeploymentTriggerPolicy item : triggers){this.addToTriggers(item);}} else { this.triggers = null;} return (A) this;
    }

    public A withTriggers(io.fabric8.openshift.api.model.DeploymentTriggerPolicy... triggers) {
        if (this.triggers != null) {this.triggers.clear();}
        if (triggers != null) {for (io.fabric8.openshift.api.model.DeploymentTriggerPolicy item :triggers){ this.addToTriggers(item);}} return (A) this;
    }

    public java.lang.Boolean hasTriggers() {
        return triggers != null && !triggers.isEmpty();
    }

    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TriggersNested<A> addNewTrigger() {
        return new io.fabric8.openshift.api.model.DeploymentConfigSpecFluentImpl.TriggersNestedImpl();
    }

    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TriggersNested<A> addNewTriggerLike(io.fabric8.openshift.api.model.DeploymentTriggerPolicy item) {
        return new io.fabric8.openshift.api.model.DeploymentConfigSpecFluentImpl.TriggersNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TriggersNested<A> setNewTriggerLike(int index,io.fabric8.openshift.api.model.DeploymentTriggerPolicy item) {
        return new io.fabric8.openshift.api.model.DeploymentConfigSpecFluentImpl.TriggersNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TriggersNested<A> editTrigger(int index) {
        if (triggers.size() <= index) throw new RuntimeException("Can't edit triggers. Index exceeds size.");
        return setNewTriggerLike(index, buildTrigger(index));
    }

    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TriggersNested<A> editFirstTrigger() {
        if (triggers.size() == 0) throw new RuntimeException("Can't edit first triggers. The list is empty.");
        return setNewTriggerLike(0, buildTrigger(0));
    }

    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TriggersNested<A> editLastTrigger() {
        int index = triggers.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last triggers. The list is empty.");
        return setNewTriggerLike(index, buildTrigger(index));
    }

    public io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TriggersNested<A> editMatchingTrigger(java.util.function.Predicate<io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder> predicate) {
        int index = -1;
        for (int i=0;i<triggers.size();i++) { 
        if (predicate.test(triggers.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching triggers. No match found.");
        return setNewTriggerLike(index, buildTrigger(index));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DeploymentConfigSpecFluentImpl that = (DeploymentConfigSpecFluentImpl) o;
        if (minReadySeconds != null ? !minReadySeconds.equals(that.minReadySeconds) :that.minReadySeconds != null) return false;
        if (paused != null ? !paused.equals(that.paused) :that.paused != null) return false;
        if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
        if (revisionHistoryLimit != null ? !revisionHistoryLimit.equals(that.revisionHistoryLimit) :that.revisionHistoryLimit != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        if (strategy != null ? !strategy.equals(that.strategy) :that.strategy != null) return false;
        if (template != null ? !template.equals(that.template) :that.template != null) return false;
        if (test != null ? !test.equals(that.test) :that.test != null) return false;
        if (triggers != null ? !triggers.equals(that.triggers) :that.triggers != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(minReadySeconds,  paused,  replicas,  revisionHistoryLimit,  selector,  strategy,  template,  test,  triggers,  super.hashCode());
    }

    public class StrategyNestedImpl<N> extends io.fabric8.openshift.api.model.DeploymentStrategyFluentImpl<io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.StrategyNested<N>> implements io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.StrategyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.DeploymentStrategyBuilder builder;

            StrategyNestedImpl(io.fabric8.openshift.api.model.DeploymentStrategy item) {
                this.builder = new io.fabric8.openshift.api.model.DeploymentStrategyBuilder(this, item);
                        
            }

            StrategyNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.DeploymentStrategyBuilder(this);
                        
            }

            public N and() {
                return (N) DeploymentConfigSpecFluentImpl.this.withStrategy(builder.build());
            }

            public N endStrategy() {
                return and();
            }
    }


    public class TemplateNestedImpl<N> extends io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl<io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TemplateNested<N>> implements io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder builder;

            TemplateNestedImpl(io.fabric8.kubernetes.api.model.PodTemplateSpec item) {
                this.builder = new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder(this, item);
                        
            }

            TemplateNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder(this);
                        
            }

            public N and() {
                return (N) DeploymentConfigSpecFluentImpl.this.withTemplate(builder.build());
            }

            public N endTemplate() {
                return and();
            }
    }


    public class TriggersNestedImpl<N> extends io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluentImpl<io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TriggersNested<N>> implements io.fabric8.openshift.api.model.DeploymentConfigSpecFluent.TriggersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder builder;
        private final int index;

            TriggersNestedImpl(int index,io.fabric8.openshift.api.model.DeploymentTriggerPolicy item) {
                this.index = index;
                this.builder = new io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder(this, item);
                        
            }

            TriggersNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder(this);
                        
            }

            public N and() {
                return (N) DeploymentConfigSpecFluentImpl.this.setToTriggers(index,builder.build());
            }

            public N endTrigger() {
                return and();
            }
    }


}
