package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EgressNetworkPolicyPeerBuilder extends io.fabric8.openshift.api.model.EgressNetworkPolicyPeerFluentImpl<io.fabric8.openshift.api.model.EgressNetworkPolicyPeerBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.EgressNetworkPolicyPeer,io.fabric8.openshift.api.model.EgressNetworkPolicyPeerBuilder> {

    io.fabric8.openshift.api.model.EgressNetworkPolicyPeerFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public EgressNetworkPolicyPeerBuilder() {
        this(true);
    }

    public EgressNetworkPolicyPeerBuilder(java.lang.Boolean validationEnabled) {
        this(new EgressNetworkPolicyPeer(), validationEnabled);
    }

    public EgressNetworkPolicyPeerBuilder(io.fabric8.openshift.api.model.EgressNetworkPolicyPeerFluent<?> fluent) {
        this(fluent, true);
    }

    public EgressNetworkPolicyPeerBuilder(io.fabric8.openshift.api.model.EgressNetworkPolicyPeerFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new EgressNetworkPolicyPeer(), validationEnabled);
    }

    public EgressNetworkPolicyPeerBuilder(io.fabric8.openshift.api.model.EgressNetworkPolicyPeerFluent<?> fluent,io.fabric8.openshift.api.model.EgressNetworkPolicyPeer instance) {
        this(fluent, instance, true);
    }

    public EgressNetworkPolicyPeerBuilder(io.fabric8.openshift.api.model.EgressNetworkPolicyPeerFluent<?> fluent,io.fabric8.openshift.api.model.EgressNetworkPolicyPeer instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCidrSelector(instance.getCidrSelector()); 
        fluent.withDnsName(instance.getDnsName()); 
        this.validationEnabled = validationEnabled; 
    }

    public EgressNetworkPolicyPeerBuilder(io.fabric8.openshift.api.model.EgressNetworkPolicyPeer instance) {
        this(instance,true);
    }

    public EgressNetworkPolicyPeerBuilder(io.fabric8.openshift.api.model.EgressNetworkPolicyPeer instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withCidrSelector(instance.getCidrSelector()); 
        this.withDnsName(instance.getDnsName()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.EgressNetworkPolicyPeer build() {
        EgressNetworkPolicyPeer buildable = new EgressNetworkPolicyPeer(fluent.getCidrSelector(),fluent.getDnsName());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EgressNetworkPolicyPeerBuilder that = (EgressNetworkPolicyPeerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
