package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GitBuildSourceBuilder extends io.fabric8.openshift.api.model.GitBuildSourceFluentImpl<io.fabric8.openshift.api.model.GitBuildSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.GitBuildSource,io.fabric8.openshift.api.model.GitBuildSourceBuilder> {

    io.fabric8.openshift.api.model.GitBuildSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public GitBuildSourceBuilder() {
        this(true);
    }

    public GitBuildSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new GitBuildSource(), validationEnabled);
    }

    public GitBuildSourceBuilder(io.fabric8.openshift.api.model.GitBuildSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public GitBuildSourceBuilder(io.fabric8.openshift.api.model.GitBuildSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new GitBuildSource(), validationEnabled);
    }

    public GitBuildSourceBuilder(io.fabric8.openshift.api.model.GitBuildSourceFluent<?> fluent,io.fabric8.openshift.api.model.GitBuildSource instance) {
        this(fluent, instance, true);
    }

    public GitBuildSourceBuilder(io.fabric8.openshift.api.model.GitBuildSourceFluent<?> fluent,io.fabric8.openshift.api.model.GitBuildSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withHttpProxy(instance.getHttpProxy()); 
        fluent.withHttpsProxy(instance.getHttpsProxy()); 
        fluent.withNoProxy(instance.getNoProxy()); 
        fluent.withRef(instance.getRef()); 
        fluent.withUri(instance.getUri()); 
        this.validationEnabled = validationEnabled; 
    }

    public GitBuildSourceBuilder(io.fabric8.openshift.api.model.GitBuildSource instance) {
        this(instance,true);
    }

    public GitBuildSourceBuilder(io.fabric8.openshift.api.model.GitBuildSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withHttpProxy(instance.getHttpProxy()); 
        this.withHttpsProxy(instance.getHttpsProxy()); 
        this.withNoProxy(instance.getNoProxy()); 
        this.withRef(instance.getRef()); 
        this.withUri(instance.getUri()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.GitBuildSource build() {
        GitBuildSource buildable = new GitBuildSource(fluent.getHttpProxy(),fluent.getHttpsProxy(),fluent.getNoProxy(),fluent.getRef(),fluent.getUri());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GitBuildSourceBuilder that = (GitBuildSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
