package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.function.Predicate;

public class HelmChartRepositoryStatusFluentImpl<A extends io.fabric8.openshift.api.model.HelmChartRepositoryStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.HelmChartRepositoryStatusFluent<A> {

    private java.util.List<io.fabric8.kubernetes.api.model.Condition> conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();

    public HelmChartRepositoryStatusFluentImpl() {
    }

    public HelmChartRepositoryStatusFluentImpl(io.fabric8.openshift.api.model.HelmChartRepositoryStatus instance) {
        this.withConditions(instance.getConditions()); 
    }

    public A addToConditions(int index,io.fabric8.kubernetes.api.model.Condition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
        this.conditions.add(index, item);
        return (A)this;
    }

    public A setToConditions(int index,io.fabric8.kubernetes.api.model.Condition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
        this.conditions.set(index, item); return (A)this;
    }

    public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
        for (io.fabric8.kubernetes.api.model.Condition item : items) {this.conditions.add(item);} return (A)this;
    }

    public A addAllToConditions(java.util.Collection<io.fabric8.kubernetes.api.model.Condition> items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
        for (io.fabric8.kubernetes.api.model.Condition item : items) {this.conditions.add(item);} return (A)this;
    }

    public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
        for (io.fabric8.kubernetes.api.model.Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
    }

    public A removeAllFromConditions(java.util.Collection<io.fabric8.kubernetes.api.model.Condition> items) {
        for (io.fabric8.kubernetes.api.model.Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
    }

    public java.util.List<io.fabric8.kubernetes.api.model.Condition> getConditions() {
        return this.conditions;
    }

    public io.fabric8.kubernetes.api.model.Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public io.fabric8.kubernetes.api.model.Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public io.fabric8.kubernetes.api.model.Condition getLastCondition() {
        return this.conditions.get(conditions.size() - 1);
    }

    public io.fabric8.kubernetes.api.model.Condition getMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Condition> predicate) {
        for (io.fabric8.kubernetes.api.model.Condition item: conditions) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Condition> predicate) {
        for (io.fabric8.kubernetes.api.model.Condition item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(java.util.List<io.fabric8.kubernetes.api.model.Condition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>(); for (io.fabric8.kubernetes.api.model.Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (io.fabric8.kubernetes.api.model.Condition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public java.lang.Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        HelmChartRepositoryStatusFluentImpl that = (HelmChartRepositoryStatusFluentImpl) o;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(conditions,  super.hashCode());
    }

}
