package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HostSubnetListBuilder extends io.fabric8.openshift.api.model.HostSubnetListFluentImpl<io.fabric8.openshift.api.model.HostSubnetListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.HostSubnetList,io.fabric8.openshift.api.model.HostSubnetListBuilder> {

    io.fabric8.openshift.api.model.HostSubnetListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public HostSubnetListBuilder() {
        this(true);
    }

    public HostSubnetListBuilder(java.lang.Boolean validationEnabled) {
        this(new HostSubnetList(), validationEnabled);
    }

    public HostSubnetListBuilder(io.fabric8.openshift.api.model.HostSubnetListFluent<?> fluent) {
        this(fluent, true);
    }

    public HostSubnetListBuilder(io.fabric8.openshift.api.model.HostSubnetListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new HostSubnetList(), validationEnabled);
    }

    public HostSubnetListBuilder(io.fabric8.openshift.api.model.HostSubnetListFluent<?> fluent,io.fabric8.openshift.api.model.HostSubnetList instance) {
        this(fluent, instance, true);
    }

    public HostSubnetListBuilder(io.fabric8.openshift.api.model.HostSubnetListFluent<?> fluent,io.fabric8.openshift.api.model.HostSubnetList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public HostSubnetListBuilder(io.fabric8.openshift.api.model.HostSubnetList instance) {
        this(instance,true);
    }

    public HostSubnetListBuilder(io.fabric8.openshift.api.model.HostSubnetList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.HostSubnetList build() {
        HostSubnetList buildable = new HostSubnetList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        HostSubnetListBuilder that = (HostSubnetListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
