package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ImageStreamImageFluentImpl<A extends io.fabric8.openshift.api.model.ImageStreamImageFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.ImageStreamImageFluent<A> {

    private java.lang.String apiVersion;
    private io.fabric8.openshift.api.model.ImageBuilder image;
    private java.lang.String kind;
    private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;

    public ImageStreamImageFluentImpl() {
    }

    public ImageStreamImageFluentImpl(io.fabric8.openshift.api.model.ImageStreamImage instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withImage(instance.getImage()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
    }

    public java.lang.String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(java.lang.String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public java.lang.Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0) {
        return (A)withApiVersion(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildImage instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.Image getImage() {
        return this.image!=null?this.image.build():null;
    }

    public io.fabric8.openshift.api.model.Image buildImage() {
        return this.image!=null?this.image.build():null;
    }

    public A withImage(io.fabric8.openshift.api.model.Image image) {
        _visitables.get("image").remove(this.image);
        if (image!=null){ this.image= new io.fabric8.openshift.api.model.ImageBuilder(image); _visitables.get("image").add(this.image);} return (A) this;
    }

    public java.lang.Boolean hasImage() {
        return this.image != null;
    }

    public io.fabric8.openshift.api.model.ImageStreamImageFluent.ImageNested<A> withNewImage() {
        return new io.fabric8.openshift.api.model.ImageStreamImageFluentImpl.ImageNestedImpl();
    }

    public io.fabric8.openshift.api.model.ImageStreamImageFluent.ImageNested<A> withNewImageLike(io.fabric8.openshift.api.model.Image item) {
        return new io.fabric8.openshift.api.model.ImageStreamImageFluentImpl.ImageNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.ImageStreamImageFluent.ImageNested<A> editImage() {
        return withNewImageLike(getImage());
    }

    public io.fabric8.openshift.api.model.ImageStreamImageFluent.ImageNested<A> editOrNewImage() {
        return withNewImageLike(getImage() != null ? getImage(): new io.fabric8.openshift.api.model.ImageBuilder().build());
    }

    public io.fabric8.openshift.api.model.ImageStreamImageFluent.ImageNested<A> editOrNewImageLike(io.fabric8.openshift.api.model.Image item) {
        return withNewImageLike(getImage() != null ? getImage(): item);
    }

    public java.lang.String getKind() {
        return this.kind;
    }

    public A withKind(java.lang.String kind) {
        this.kind=kind; return (A) this;
    }

    public java.lang.Boolean hasKind() {
        return this.kind != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String arg0) {
        return (A)withKind(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetadata instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public java.lang.Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.fabric8.openshift.api.model.ImageStreamImageFluent.MetadataNested<A> withNewMetadata() {
        return new io.fabric8.openshift.api.model.ImageStreamImageFluentImpl.MetadataNestedImpl();
    }

    public io.fabric8.openshift.api.model.ImageStreamImageFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return new io.fabric8.openshift.api.model.ImageStreamImageFluentImpl.MetadataNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.ImageStreamImageFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.fabric8.openshift.api.model.ImageStreamImageFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
    }

    public io.fabric8.openshift.api.model.ImageStreamImageFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ImageStreamImageFluentImpl that = (ImageStreamImageFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  image,  kind,  metadata,  super.hashCode());
    }

    public class ImageNestedImpl<N> extends io.fabric8.openshift.api.model.ImageFluentImpl<io.fabric8.openshift.api.model.ImageStreamImageFluent.ImageNested<N>> implements io.fabric8.openshift.api.model.ImageStreamImageFluent.ImageNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.ImageBuilder builder;

            ImageNestedImpl(io.fabric8.openshift.api.model.Image item) {
                this.builder = new io.fabric8.openshift.api.model.ImageBuilder(this, item);
                        
            }

            ImageNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.ImageBuilder(this);
                        
            }

            public N and() {
                return (N) ImageStreamImageFluentImpl.this.withImage(builder.build());
            }

            public N endImage() {
                return and();
            }
    }


    public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.openshift.api.model.ImageStreamImageFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.ImageStreamImageFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;

            MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) ImageStreamImageFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


}
