package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class InfrastructureSpecBuilder extends io.fabric8.openshift.api.model.InfrastructureSpecFluentImpl<io.fabric8.openshift.api.model.InfrastructureSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.InfrastructureSpec,io.fabric8.openshift.api.model.InfrastructureSpecBuilder> {

    io.fabric8.openshift.api.model.InfrastructureSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public InfrastructureSpecBuilder() {
        this(true);
    }

    public InfrastructureSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new InfrastructureSpec(), validationEnabled);
    }

    public InfrastructureSpecBuilder(io.fabric8.openshift.api.model.InfrastructureSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public InfrastructureSpecBuilder(io.fabric8.openshift.api.model.InfrastructureSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new InfrastructureSpec(), validationEnabled);
    }

    public InfrastructureSpecBuilder(io.fabric8.openshift.api.model.InfrastructureSpecFluent<?> fluent,io.fabric8.openshift.api.model.InfrastructureSpec instance) {
        this(fluent, instance, true);
    }

    public InfrastructureSpecBuilder(io.fabric8.openshift.api.model.InfrastructureSpecFluent<?> fluent,io.fabric8.openshift.api.model.InfrastructureSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCloudConfig(instance.getCloudConfig()); 
        fluent.withPlatformSpec(instance.getPlatformSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public InfrastructureSpecBuilder(io.fabric8.openshift.api.model.InfrastructureSpec instance) {
        this(instance,true);
    }

    public InfrastructureSpecBuilder(io.fabric8.openshift.api.model.InfrastructureSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withCloudConfig(instance.getCloudConfig()); 
        this.withPlatformSpec(instance.getPlatformSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.InfrastructureSpec build() {
        InfrastructureSpec buildable = new InfrastructureSpec(fluent.getCloudConfig(),fluent.getPlatformSpec());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        InfrastructureSpecBuilder that = (InfrastructureSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
