package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class InfrastructureSpecFluentImpl<A extends io.fabric8.openshift.api.model.InfrastructureSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.InfrastructureSpecFluent<A> {

    private io.fabric8.openshift.api.model.ConfigMapFileReferenceBuilder cloudConfig;
    private io.fabric8.openshift.api.model.PlatformSpecBuilder platformSpec;

    public InfrastructureSpecFluentImpl() {
    }

    public InfrastructureSpecFluentImpl(io.fabric8.openshift.api.model.InfrastructureSpec instance) {
        this.withCloudConfig(instance.getCloudConfig()); 
        this.withPlatformSpec(instance.getPlatformSpec()); 
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildCloudConfig instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.ConfigMapFileReference getCloudConfig() {
        return this.cloudConfig!=null?this.cloudConfig.build():null;
    }

    public io.fabric8.openshift.api.model.ConfigMapFileReference buildCloudConfig() {
        return this.cloudConfig!=null?this.cloudConfig.build():null;
    }

    public A withCloudConfig(io.fabric8.openshift.api.model.ConfigMapFileReference cloudConfig) {
        _visitables.get("cloudConfig").remove(this.cloudConfig);
        if (cloudConfig!=null){ this.cloudConfig= new io.fabric8.openshift.api.model.ConfigMapFileReferenceBuilder(cloudConfig); _visitables.get("cloudConfig").add(this.cloudConfig);} return (A) this;
    }

    public java.lang.Boolean hasCloudConfig() {
        return this.cloudConfig != null;
    }

    public A withNewCloudConfig(java.lang.String key,java.lang.String name) {
        return (A)withCloudConfig(new ConfigMapFileReference(key, name));
    }

    public io.fabric8.openshift.api.model.InfrastructureSpecFluent.CloudConfigNested<A> withNewCloudConfig() {
        return new io.fabric8.openshift.api.model.InfrastructureSpecFluentImpl.CloudConfigNestedImpl();
    }

    public io.fabric8.openshift.api.model.InfrastructureSpecFluent.CloudConfigNested<A> withNewCloudConfigLike(io.fabric8.openshift.api.model.ConfigMapFileReference item) {
        return new io.fabric8.openshift.api.model.InfrastructureSpecFluentImpl.CloudConfigNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.InfrastructureSpecFluent.CloudConfigNested<A> editCloudConfig() {
        return withNewCloudConfigLike(getCloudConfig());
    }

    public io.fabric8.openshift.api.model.InfrastructureSpecFluent.CloudConfigNested<A> editOrNewCloudConfig() {
        return withNewCloudConfigLike(getCloudConfig() != null ? getCloudConfig(): new io.fabric8.openshift.api.model.ConfigMapFileReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.InfrastructureSpecFluent.CloudConfigNested<A> editOrNewCloudConfigLike(io.fabric8.openshift.api.model.ConfigMapFileReference item) {
        return withNewCloudConfigLike(getCloudConfig() != null ? getCloudConfig(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPlatformSpec instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.PlatformSpec getPlatformSpec() {
        return this.platformSpec!=null?this.platformSpec.build():null;
    }

    public io.fabric8.openshift.api.model.PlatformSpec buildPlatformSpec() {
        return this.platformSpec!=null?this.platformSpec.build():null;
    }

    public A withPlatformSpec(io.fabric8.openshift.api.model.PlatformSpec platformSpec) {
        _visitables.get("platformSpec").remove(this.platformSpec);
        if (platformSpec!=null){ this.platformSpec= new io.fabric8.openshift.api.model.PlatformSpecBuilder(platformSpec); _visitables.get("platformSpec").add(this.platformSpec);} return (A) this;
    }

    public java.lang.Boolean hasPlatformSpec() {
        return this.platformSpec != null;
    }

    public io.fabric8.openshift.api.model.InfrastructureSpecFluent.PlatformSpecNested<A> withNewPlatformSpec() {
        return new io.fabric8.openshift.api.model.InfrastructureSpecFluentImpl.PlatformSpecNestedImpl();
    }

    public io.fabric8.openshift.api.model.InfrastructureSpecFluent.PlatformSpecNested<A> withNewPlatformSpecLike(io.fabric8.openshift.api.model.PlatformSpec item) {
        return new io.fabric8.openshift.api.model.InfrastructureSpecFluentImpl.PlatformSpecNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.InfrastructureSpecFluent.PlatformSpecNested<A> editPlatformSpec() {
        return withNewPlatformSpecLike(getPlatformSpec());
    }

    public io.fabric8.openshift.api.model.InfrastructureSpecFluent.PlatformSpecNested<A> editOrNewPlatformSpec() {
        return withNewPlatformSpecLike(getPlatformSpec() != null ? getPlatformSpec(): new io.fabric8.openshift.api.model.PlatformSpecBuilder().build());
    }

    public io.fabric8.openshift.api.model.InfrastructureSpecFluent.PlatformSpecNested<A> editOrNewPlatformSpecLike(io.fabric8.openshift.api.model.PlatformSpec item) {
        return withNewPlatformSpecLike(getPlatformSpec() != null ? getPlatformSpec(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        InfrastructureSpecFluentImpl that = (InfrastructureSpecFluentImpl) o;
        if (cloudConfig != null ? !cloudConfig.equals(that.cloudConfig) :that.cloudConfig != null) return false;
        if (platformSpec != null ? !platformSpec.equals(that.platformSpec) :that.platformSpec != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(cloudConfig,  platformSpec,  super.hashCode());
    }

    public class CloudConfigNestedImpl<N> extends io.fabric8.openshift.api.model.ConfigMapFileReferenceFluentImpl<io.fabric8.openshift.api.model.InfrastructureSpecFluent.CloudConfigNested<N>> implements io.fabric8.openshift.api.model.InfrastructureSpecFluent.CloudConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.ConfigMapFileReferenceBuilder builder;

            CloudConfigNestedImpl(io.fabric8.openshift.api.model.ConfigMapFileReference item) {
                this.builder = new io.fabric8.openshift.api.model.ConfigMapFileReferenceBuilder(this, item);
                        
            }

            CloudConfigNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.ConfigMapFileReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) InfrastructureSpecFluentImpl.this.withCloudConfig(builder.build());
            }

            public N endCloudConfig() {
                return and();
            }
    }


    public class PlatformSpecNestedImpl<N> extends io.fabric8.openshift.api.model.PlatformSpecFluentImpl<io.fabric8.openshift.api.model.InfrastructureSpecFluent.PlatformSpecNested<N>> implements io.fabric8.openshift.api.model.InfrastructureSpecFluent.PlatformSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.PlatformSpecBuilder builder;

            PlatformSpecNestedImpl(io.fabric8.openshift.api.model.PlatformSpec item) {
                this.builder = new io.fabric8.openshift.api.model.PlatformSpecBuilder(this, item);
                        
            }

            PlatformSpecNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.PlatformSpecBuilder(this);
                        
            }

            public N and() {
                return (N) InfrastructureSpecFluentImpl.this.withPlatformSpec(builder.build());
            }

            public N endPlatformSpec() {
                return and();
            }
    }


}
