package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class InfrastructureStatusFluentImpl<A extends io.fabric8.openshift.api.model.InfrastructureStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.InfrastructureStatusFluent<A> {

    private java.lang.String apiServerInternalURI;
    private java.lang.String apiServerURL;
    private java.lang.String controlPlaneTopology;
    private java.lang.String etcdDiscoveryDomain;
    private java.lang.String infrastructureName;
    private java.lang.String infrastructureTopology;
    private java.lang.String platform;
    private io.fabric8.openshift.api.model.PlatformStatusBuilder platformStatus;

    public InfrastructureStatusFluentImpl() {
    }

    public InfrastructureStatusFluentImpl(io.fabric8.openshift.api.model.InfrastructureStatus instance) {
        this.withApiServerInternalURI(instance.getApiServerInternalURI()); 
        this.withApiServerURL(instance.getApiServerURL()); 
        this.withControlPlaneTopology(instance.getControlPlaneTopology()); 
        this.withEtcdDiscoveryDomain(instance.getEtcdDiscoveryDomain()); 
        this.withInfrastructureName(instance.getInfrastructureName()); 
        this.withInfrastructureTopology(instance.getInfrastructureTopology()); 
        this.withPlatform(instance.getPlatform()); 
        this.withPlatformStatus(instance.getPlatformStatus()); 
    }

    public java.lang.String getApiServerInternalURI() {
        return this.apiServerInternalURI;
    }

    public A withApiServerInternalURI(java.lang.String apiServerInternalURI) {
        this.apiServerInternalURI=apiServerInternalURI; return (A) this;
    }

    public java.lang.Boolean hasApiServerInternalURI() {
        return this.apiServerInternalURI != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiServerInternalURI instead.
     */
        public A withNewApiServerInternalURI(java.lang.String arg0) {
        return (A)withApiServerInternalURI(new String(arg0));
    }

    public java.lang.String getApiServerURL() {
        return this.apiServerURL;
    }

    public A withApiServerURL(java.lang.String apiServerURL) {
        this.apiServerURL=apiServerURL; return (A) this;
    }

    public java.lang.Boolean hasApiServerURL() {
        return this.apiServerURL != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiServerURL instead.
     */
        public A withNewApiServerURL(java.lang.String arg0) {
        return (A)withApiServerURL(new String(arg0));
    }

    public java.lang.String getControlPlaneTopology() {
        return this.controlPlaneTopology;
    }

    public A withControlPlaneTopology(java.lang.String controlPlaneTopology) {
        this.controlPlaneTopology=controlPlaneTopology; return (A) this;
    }

    public java.lang.Boolean hasControlPlaneTopology() {
        return this.controlPlaneTopology != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withControlPlaneTopology instead.
     */
        public A withNewControlPlaneTopology(java.lang.String arg0) {
        return (A)withControlPlaneTopology(new String(arg0));
    }

    public java.lang.String getEtcdDiscoveryDomain() {
        return this.etcdDiscoveryDomain;
    }

    public A withEtcdDiscoveryDomain(java.lang.String etcdDiscoveryDomain) {
        this.etcdDiscoveryDomain=etcdDiscoveryDomain; return (A) this;
    }

    public java.lang.Boolean hasEtcdDiscoveryDomain() {
        return this.etcdDiscoveryDomain != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withEtcdDiscoveryDomain instead.
     */
        public A withNewEtcdDiscoveryDomain(java.lang.String arg0) {
        return (A)withEtcdDiscoveryDomain(new String(arg0));
    }

    public java.lang.String getInfrastructureName() {
        return this.infrastructureName;
    }

    public A withInfrastructureName(java.lang.String infrastructureName) {
        this.infrastructureName=infrastructureName; return (A) this;
    }

    public java.lang.Boolean hasInfrastructureName() {
        return this.infrastructureName != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withInfrastructureName instead.
     */
        public A withNewInfrastructureName(java.lang.String arg0) {
        return (A)withInfrastructureName(new String(arg0));
    }

    public java.lang.String getInfrastructureTopology() {
        return this.infrastructureTopology;
    }

    public A withInfrastructureTopology(java.lang.String infrastructureTopology) {
        this.infrastructureTopology=infrastructureTopology; return (A) this;
    }

    public java.lang.Boolean hasInfrastructureTopology() {
        return this.infrastructureTopology != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withInfrastructureTopology instead.
     */
        public A withNewInfrastructureTopology(java.lang.String arg0) {
        return (A)withInfrastructureTopology(new String(arg0));
    }

    public java.lang.String getPlatform() {
        return this.platform;
    }

    public A withPlatform(java.lang.String platform) {
        this.platform=platform; return (A) this;
    }

    public java.lang.Boolean hasPlatform() {
        return this.platform != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPlatform instead.
     */
        public A withNewPlatform(java.lang.String arg0) {
        return (A)withPlatform(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPlatformStatus instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.PlatformStatus getPlatformStatus() {
        return this.platformStatus!=null?this.platformStatus.build():null;
    }

    public io.fabric8.openshift.api.model.PlatformStatus buildPlatformStatus() {
        return this.platformStatus!=null?this.platformStatus.build():null;
    }

    public A withPlatformStatus(io.fabric8.openshift.api.model.PlatformStatus platformStatus) {
        _visitables.get("platformStatus").remove(this.platformStatus);
        if (platformStatus!=null){ this.platformStatus= new io.fabric8.openshift.api.model.PlatformStatusBuilder(platformStatus); _visitables.get("platformStatus").add(this.platformStatus);} return (A) this;
    }

    public java.lang.Boolean hasPlatformStatus() {
        return this.platformStatus != null;
    }

    public io.fabric8.openshift.api.model.InfrastructureStatusFluent.PlatformStatusNested<A> withNewPlatformStatus() {
        return new io.fabric8.openshift.api.model.InfrastructureStatusFluentImpl.PlatformStatusNestedImpl();
    }

    public io.fabric8.openshift.api.model.InfrastructureStatusFluent.PlatformStatusNested<A> withNewPlatformStatusLike(io.fabric8.openshift.api.model.PlatformStatus item) {
        return new io.fabric8.openshift.api.model.InfrastructureStatusFluentImpl.PlatformStatusNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.InfrastructureStatusFluent.PlatformStatusNested<A> editPlatformStatus() {
        return withNewPlatformStatusLike(getPlatformStatus());
    }

    public io.fabric8.openshift.api.model.InfrastructureStatusFluent.PlatformStatusNested<A> editOrNewPlatformStatus() {
        return withNewPlatformStatusLike(getPlatformStatus() != null ? getPlatformStatus(): new io.fabric8.openshift.api.model.PlatformStatusBuilder().build());
    }

    public io.fabric8.openshift.api.model.InfrastructureStatusFluent.PlatformStatusNested<A> editOrNewPlatformStatusLike(io.fabric8.openshift.api.model.PlatformStatus item) {
        return withNewPlatformStatusLike(getPlatformStatus() != null ? getPlatformStatus(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        InfrastructureStatusFluentImpl that = (InfrastructureStatusFluentImpl) o;
        if (apiServerInternalURI != null ? !apiServerInternalURI.equals(that.apiServerInternalURI) :that.apiServerInternalURI != null) return false;
        if (apiServerURL != null ? !apiServerURL.equals(that.apiServerURL) :that.apiServerURL != null) return false;
        if (controlPlaneTopology != null ? !controlPlaneTopology.equals(that.controlPlaneTopology) :that.controlPlaneTopology != null) return false;
        if (etcdDiscoveryDomain != null ? !etcdDiscoveryDomain.equals(that.etcdDiscoveryDomain) :that.etcdDiscoveryDomain != null) return false;
        if (infrastructureName != null ? !infrastructureName.equals(that.infrastructureName) :that.infrastructureName != null) return false;
        if (infrastructureTopology != null ? !infrastructureTopology.equals(that.infrastructureTopology) :that.infrastructureTopology != null) return false;
        if (platform != null ? !platform.equals(that.platform) :that.platform != null) return false;
        if (platformStatus != null ? !platformStatus.equals(that.platformStatus) :that.platformStatus != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiServerInternalURI,  apiServerURL,  controlPlaneTopology,  etcdDiscoveryDomain,  infrastructureName,  infrastructureTopology,  platform,  platformStatus,  super.hashCode());
    }

    public class PlatformStatusNestedImpl<N> extends io.fabric8.openshift.api.model.PlatformStatusFluentImpl<io.fabric8.openshift.api.model.InfrastructureStatusFluent.PlatformStatusNested<N>> implements io.fabric8.openshift.api.model.InfrastructureStatusFluent.PlatformStatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.PlatformStatusBuilder builder;

            PlatformStatusNestedImpl(io.fabric8.openshift.api.model.PlatformStatus item) {
                this.builder = new io.fabric8.openshift.api.model.PlatformStatusBuilder(this, item);
                        
            }

            PlatformStatusNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.PlatformStatusBuilder(this);
                        
            }

            public N and() {
                return (N) InfrastructureStatusFluentImpl.this.withPlatformStatus(builder.build());
            }

            public N endPlatformStatus() {
                return and();
            }
    }


}
