package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class IngressSpecFluentImpl<A extends io.fabric8.openshift.api.model.IngressSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.IngressSpecFluent<A> {

    private java.lang.String appsDomain;
    private java.util.List<io.fabric8.openshift.api.model.ComponentRouteSpecBuilder> componentRoutes =  new java.util.ArrayList<io.fabric8.openshift.api.model.ComponentRouteSpecBuilder>();
    private java.lang.String domain;

    public IngressSpecFluentImpl() {
    }

    public IngressSpecFluentImpl(io.fabric8.openshift.api.model.IngressSpec instance) {
        this.withAppsDomain(instance.getAppsDomain()); 
        this.withComponentRoutes(instance.getComponentRoutes()); 
        this.withDomain(instance.getDomain()); 
    }

    public java.lang.String getAppsDomain() {
        return this.appsDomain;
    }

    public A withAppsDomain(java.lang.String appsDomain) {
        this.appsDomain=appsDomain; return (A) this;
    }

    public java.lang.Boolean hasAppsDomain() {
        return this.appsDomain != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withAppsDomain instead.
     */
        public A withNewAppsDomain(java.lang.String arg0) {
        return (A)withAppsDomain(new String(arg0));
    }

    public A addToComponentRoutes(int index,io.fabric8.openshift.api.model.ComponentRouteSpec item) {
        if (this.componentRoutes == null) {this.componentRoutes = new java.util.ArrayList<io.fabric8.openshift.api.model.ComponentRouteSpecBuilder>();}
        io.fabric8.openshift.api.model.ComponentRouteSpecBuilder builder = new io.fabric8.openshift.api.model.ComponentRouteSpecBuilder(item);_visitables.get("componentRoutes").add(index >= 0 ? index : _visitables.get("componentRoutes").size(), builder);this.componentRoutes.add(index >= 0 ? index : componentRoutes.size(), builder); return (A)this;
    }

    public A setToComponentRoutes(int index,io.fabric8.openshift.api.model.ComponentRouteSpec item) {
        if (this.componentRoutes == null) {this.componentRoutes = new java.util.ArrayList<io.fabric8.openshift.api.model.ComponentRouteSpecBuilder>();}
        io.fabric8.openshift.api.model.ComponentRouteSpecBuilder builder = new io.fabric8.openshift.api.model.ComponentRouteSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("componentRoutes").size()) { _visitables.get("componentRoutes").add(builder); } else { _visitables.get("componentRoutes").set(index, builder);}
        if (index < 0 || index >= componentRoutes.size()) { componentRoutes.add(builder); } else { componentRoutes.set(index, builder);}
         return (A)this;
    }

    public A addToComponentRoutes(io.fabric8.openshift.api.model.ComponentRouteSpec... items) {
        if (this.componentRoutes == null) {this.componentRoutes = new java.util.ArrayList<io.fabric8.openshift.api.model.ComponentRouteSpecBuilder>();}
        for (io.fabric8.openshift.api.model.ComponentRouteSpec item : items) {io.fabric8.openshift.api.model.ComponentRouteSpecBuilder builder = new io.fabric8.openshift.api.model.ComponentRouteSpecBuilder(item);_visitables.get("componentRoutes").add(builder);this.componentRoutes.add(builder);} return (A)this;
    }

    public A addAllToComponentRoutes(java.util.Collection<io.fabric8.openshift.api.model.ComponentRouteSpec> items) {
        if (this.componentRoutes == null) {this.componentRoutes = new java.util.ArrayList<io.fabric8.openshift.api.model.ComponentRouteSpecBuilder>();}
        for (io.fabric8.openshift.api.model.ComponentRouteSpec item : items) {io.fabric8.openshift.api.model.ComponentRouteSpecBuilder builder = new io.fabric8.openshift.api.model.ComponentRouteSpecBuilder(item);_visitables.get("componentRoutes").add(builder);this.componentRoutes.add(builder);} return (A)this;
    }

    public A removeFromComponentRoutes(io.fabric8.openshift.api.model.ComponentRouteSpec... items) {
        for (io.fabric8.openshift.api.model.ComponentRouteSpec item : items) {io.fabric8.openshift.api.model.ComponentRouteSpecBuilder builder = new io.fabric8.openshift.api.model.ComponentRouteSpecBuilder(item);_visitables.get("componentRoutes").remove(builder);if (this.componentRoutes != null) {this.componentRoutes.remove(builder);}} return (A)this;
    }

    public A removeAllFromComponentRoutes(java.util.Collection<io.fabric8.openshift.api.model.ComponentRouteSpec> items) {
        for (io.fabric8.openshift.api.model.ComponentRouteSpec item : items) {io.fabric8.openshift.api.model.ComponentRouteSpecBuilder builder = new io.fabric8.openshift.api.model.ComponentRouteSpecBuilder(item);_visitables.get("componentRoutes").remove(builder);if (this.componentRoutes != null) {this.componentRoutes.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromComponentRoutes(java.util.function.Predicate<io.fabric8.openshift.api.model.ComponentRouteSpecBuilder> predicate) {
        if (componentRoutes == null) return (A) this;
        final Iterator<io.fabric8.openshift.api.model.ComponentRouteSpecBuilder> each = componentRoutes.iterator();
        final List visitables = _visitables.get("componentRoutes");
        while (each.hasNext()) {
          io.fabric8.openshift.api.model.ComponentRouteSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildComponentRoutes instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.openshift.api.model.ComponentRouteSpec> getComponentRoutes() {
        return build(componentRoutes);
    }

    public java.util.List<io.fabric8.openshift.api.model.ComponentRouteSpec> buildComponentRoutes() {
        return build(componentRoutes);
    }

    public io.fabric8.openshift.api.model.ComponentRouteSpec buildComponentRoute(int index) {
        return this.componentRoutes.get(index).build();
    }

    public io.fabric8.openshift.api.model.ComponentRouteSpec buildFirstComponentRoute() {
        return this.componentRoutes.get(0).build();
    }

    public io.fabric8.openshift.api.model.ComponentRouteSpec buildLastComponentRoute() {
        return this.componentRoutes.get(componentRoutes.size() - 1).build();
    }

    public io.fabric8.openshift.api.model.ComponentRouteSpec buildMatchingComponentRoute(java.util.function.Predicate<io.fabric8.openshift.api.model.ComponentRouteSpecBuilder> predicate) {
        for (io.fabric8.openshift.api.model.ComponentRouteSpecBuilder item: componentRoutes) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingComponentRoute(java.util.function.Predicate<io.fabric8.openshift.api.model.ComponentRouteSpecBuilder> predicate) {
        for (io.fabric8.openshift.api.model.ComponentRouteSpecBuilder item: componentRoutes) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withComponentRoutes(java.util.List<io.fabric8.openshift.api.model.ComponentRouteSpec> componentRoutes) {
        if (this.componentRoutes != null) { _visitables.get("componentRoutes").removeAll(this.componentRoutes);}
        if (componentRoutes != null) {this.componentRoutes = new java.util.ArrayList<io.fabric8.openshift.api.model.ComponentRouteSpecBuilder>(); for (io.fabric8.openshift.api.model.ComponentRouteSpec item : componentRoutes){this.addToComponentRoutes(item);}} else { this.componentRoutes = null;} return (A) this;
    }

    public A withComponentRoutes(io.fabric8.openshift.api.model.ComponentRouteSpec... componentRoutes) {
        if (this.componentRoutes != null) {this.componentRoutes.clear();}
        if (componentRoutes != null) {for (io.fabric8.openshift.api.model.ComponentRouteSpec item :componentRoutes){ this.addToComponentRoutes(item);}} return (A) this;
    }

    public java.lang.Boolean hasComponentRoutes() {
        return componentRoutes != null && !componentRoutes.isEmpty();
    }

    public io.fabric8.openshift.api.model.IngressSpecFluent.ComponentRoutesNested<A> addNewComponentRoute() {
        return new io.fabric8.openshift.api.model.IngressSpecFluentImpl.ComponentRoutesNestedImpl();
    }

    public io.fabric8.openshift.api.model.IngressSpecFluent.ComponentRoutesNested<A> addNewComponentRouteLike(io.fabric8.openshift.api.model.ComponentRouteSpec item) {
        return new io.fabric8.openshift.api.model.IngressSpecFluentImpl.ComponentRoutesNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.IngressSpecFluent.ComponentRoutesNested<A> setNewComponentRouteLike(int index,io.fabric8.openshift.api.model.ComponentRouteSpec item) {
        return new io.fabric8.openshift.api.model.IngressSpecFluentImpl.ComponentRoutesNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.IngressSpecFluent.ComponentRoutesNested<A> editComponentRoute(int index) {
        if (componentRoutes.size() <= index) throw new RuntimeException("Can't edit componentRoutes. Index exceeds size.");
        return setNewComponentRouteLike(index, buildComponentRoute(index));
    }

    public io.fabric8.openshift.api.model.IngressSpecFluent.ComponentRoutesNested<A> editFirstComponentRoute() {
        if (componentRoutes.size() == 0) throw new RuntimeException("Can't edit first componentRoutes. The list is empty.");
        return setNewComponentRouteLike(0, buildComponentRoute(0));
    }

    public io.fabric8.openshift.api.model.IngressSpecFluent.ComponentRoutesNested<A> editLastComponentRoute() {
        int index = componentRoutes.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last componentRoutes. The list is empty.");
        return setNewComponentRouteLike(index, buildComponentRoute(index));
    }

    public io.fabric8.openshift.api.model.IngressSpecFluent.ComponentRoutesNested<A> editMatchingComponentRoute(java.util.function.Predicate<io.fabric8.openshift.api.model.ComponentRouteSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<componentRoutes.size();i++) { 
        if (predicate.test(componentRoutes.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching componentRoutes. No match found.");
        return setNewComponentRouteLike(index, buildComponentRoute(index));
    }

    public java.lang.String getDomain() {
        return this.domain;
    }

    public A withDomain(java.lang.String domain) {
        this.domain=domain; return (A) this;
    }

    public java.lang.Boolean hasDomain() {
        return this.domain != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withDomain instead.
     */
        public A withNewDomain(java.lang.String arg0) {
        return (A)withDomain(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IngressSpecFluentImpl that = (IngressSpecFluentImpl) o;
        if (appsDomain != null ? !appsDomain.equals(that.appsDomain) :that.appsDomain != null) return false;
        if (componentRoutes != null ? !componentRoutes.equals(that.componentRoutes) :that.componentRoutes != null) return false;
        if (domain != null ? !domain.equals(that.domain) :that.domain != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(appsDomain,  componentRoutes,  domain,  super.hashCode());
    }

    public class ComponentRoutesNestedImpl<N> extends io.fabric8.openshift.api.model.ComponentRouteSpecFluentImpl<io.fabric8.openshift.api.model.IngressSpecFluent.ComponentRoutesNested<N>> implements io.fabric8.openshift.api.model.IngressSpecFluent.ComponentRoutesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.ComponentRouteSpecBuilder builder;
        private final int index;

            ComponentRoutesNestedImpl(int index,io.fabric8.openshift.api.model.ComponentRouteSpec item) {
                this.index = index;
                this.builder = new io.fabric8.openshift.api.model.ComponentRouteSpecBuilder(this, item);
                        
            }

            ComponentRoutesNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.openshift.api.model.ComponentRouteSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IngressSpecFluentImpl.this.setToComponentRoutes(index,builder.build());
            }

            public N endComponentRoute() {
                return and();
            }
    }


}
